/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.protobuf;

import com.linkedin.data.protobuf.ByteArrayReader;
import com.linkedin.data.protobuf.InputStreamReader;
import com.linkedin.data.protobuf.TextBuffer;
import java.io.IOException;
import java.io.InputStream;

public abstract class ProtoReader {
    static final int DEFAULT_BYTE_BUFFER_SIZE = 4096;
    public static final int DEFAULT_TEXT_BUFFER_SIZE = 1024;
    static final int DEFAULT_SIZE_LIMIT = Integer.MAX_VALUE;
    protected final TextBuffer _textBuffer = new TextBuffer(1024);

    public static ProtoReader newInstance(InputStream input) {
        return new InputStreamReader(input, 4096);
    }

    public static ProtoReader newInstance(byte[] buf) {
        return ProtoReader.newInstance(buf, 0, buf.length);
    }

    public static ProtoReader newInstance(byte[] buf, int off, int len) {
        return new ByteArrayReader(buf, off, len);
    }

    protected ProtoReader() {
    }

    public abstract String readString() throws IOException;

    public String readASCIIString() throws IOException {
        return this.readString();
    }

    public abstract byte[] readByteArray() throws IOException;

    public abstract int readInt32() throws IOException;

    public abstract long readInt64() throws IOException;

    public int readFixedInt32() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long readFixedInt64() throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract byte readRawByte() throws IOException;
}

