/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.codec.entitystream.DataDecoder;
import com.linkedin.data.codec.entitystream.JacksonLICORStreamDataCodec;
import com.linkedin.data.codec.symbol.SymbolTable;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.entitystream.ReadHandle;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.core.async.ByteArrayFeeder;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

class JacksonLICORDataDecoder<T extends DataComplex>
implements DataDecoder<T> {
    private static final byte VALUE = (byte)(Token.SIMPLE_VALUE.bitPattern | Token.START_ARRAY.bitPattern);
    private static final byte NEXT_ARRAY_ITEM = (byte)(VALUE | Token.END_ARRAY.bitPattern);
    private static final byte NEXT_MAP_KEY = (byte)(Token.FIELD_NAME.bitPattern | Token.END_ARRAY.bitPattern);
    private final JsonFactory _jsonFactory;
    private final SymbolTable _symbolTable;
    private CompletableFuture<T> _completable;
    private T _result;
    private ReadHandle _readHandle;
    private JsonParser _jsonParser;
    private ByteArrayFeeder _byteArrayFeeder;
    private Deque<DataComplex> _stack;
    private String _currField;
    private Byte _expectedStartMarker;
    private byte _expectedTokens;
    private boolean _isCurrList;
    private boolean _isFieldNameExpected;
    private boolean _isStructStart;
    private ByteString _currentChunk;
    private int _currentChunkIndex = -1;

    public JacksonLICORDataDecoder(boolean decodeBinary) {
        this(decodeBinary, false, null);
        this._expectedStartMarker = null;
    }

    public JacksonLICORDataDecoder(boolean decodeBinary, boolean isDataList, SymbolTable symbolTable) {
        this._jsonFactory = JacksonLICORStreamDataCodec.getFactory(decodeBinary);
        this._completable = new CompletableFuture();
        this._result = null;
        this._stack = new ArrayDeque<DataComplex>();
        this._expectedTokens = Token.START_ARRAY.bitPattern;
        this._expectedStartMarker = isDataList ? (byte)1 : 0;
        this._symbolTable = symbolTable;
    }

    @Override
    public void onInit(ReadHandle rh) {
        this._readHandle = rh;
        try {
            this._jsonParser = this._jsonFactory.createNonBlockingByteArrayParser();
            this._byteArrayFeeder = (ByteArrayFeeder)((Object)this._jsonParser);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        this.readNextChunk();
    }

    @Override
    public void onDataAvailable(ByteString data) {
        this._currentChunk = data;
        this._currentChunkIndex = 0;
        this.processCurrentChunk();
    }

    private void readNextChunk() {
        if (this._currentChunkIndex == -1) {
            this._readHandle.request(1);
            return;
        }
        this.processCurrentChunk();
    }

    private void processCurrentChunk() {
        try {
            this._currentChunkIndex = this._currentChunk.feed(this._byteArrayFeeder, this._currentChunkIndex);
            this.processTokens();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTokens() {
        try {
            JsonToken token;
            block22: while ((token = this._jsonParser.nextToken()) != null) {
                switch (token) {
                    case START_ARRAY: {
                        this.validate(Token.START_ARRAY);
                        this._isStructStart = true;
                        this._expectedTokens = Token.STRUCT_MARKER.bitPattern;
                        continue block22;
                    }
                    case END_ARRAY: {
                        this.validate(Token.END_ARRAY);
                        this.pop();
                        continue block22;
                    }
                    case VALUE_STRING: {
                        if (this._isFieldNameExpected) {
                            this.validate(Token.FIELD_NAME);
                            this._isFieldNameExpected = false;
                            this._currField = this._jsonParser.getText();
                            this._expectedTokens = VALUE;
                            continue block22;
                        }
                        this.validate(Token.SIMPLE_VALUE);
                        this.addValue(this._jsonParser.getText());
                        continue block22;
                    }
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: {
                        JsonParser.NumberType numberType = this._jsonParser.getNumberType();
                        switch (numberType) {
                            case INT: {
                                if (this._isStructStart) {
                                    this._isStructStart = false;
                                    this.validate(Token.STRUCT_MARKER);
                                    byte marker = this._jsonParser.getByteValue();
                                    if (this._expectedStartMarker != null && marker != this._expectedStartMarker) {
                                        marker = -1;
                                    } else {
                                        this._expectedStartMarker = null;
                                    }
                                    switch (marker) {
                                        case 1: {
                                            this.push(new DataList(), true);
                                            continue block22;
                                        }
                                        case 0: {
                                            this.push(new DataMap(), false);
                                            continue block22;
                                        }
                                    }
                                    throw new DataDecodingException("Unexpected marker: " + marker + " " + this._jsonParser.getText());
                                }
                                if (this._isFieldNameExpected) {
                                    this.validate(Token.FIELD_NAME);
                                    this._isFieldNameExpected = false;
                                    int sid = this._jsonParser.getIntValue();
                                    if (this._symbolTable == null || (this._currField = this._symbolTable.getSymbolName(sid)) == null) {
                                        throw new DataDecodingException("Did not find mapping for symbol: " + sid);
                                    }
                                    this._expectedTokens = VALUE;
                                    continue block22;
                                }
                                this.validate(Token.SIMPLE_VALUE);
                                this.addValue(this._jsonParser.getIntValue());
                                continue block22;
                            }
                            case LONG: {
                                this.validate(Token.SIMPLE_VALUE);
                                this.addValue(this._jsonParser.getLongValue());
                                continue block22;
                            }
                            case FLOAT: {
                                this.validate(Token.SIMPLE_VALUE);
                                this.addValue(Float.valueOf(this._jsonParser.getFloatValue()));
                                continue block22;
                            }
                            case DOUBLE: {
                                this.validate(Token.SIMPLE_VALUE);
                                this.addValue(this._jsonParser.getDoubleValue());
                                continue block22;
                            }
                        }
                        this.handleException(new Exception("Unexpected number value type " + (Object)((Object)numberType) + " at " + this._jsonParser.getTokenLocation()));
                        continue block22;
                    }
                    case VALUE_TRUE: {
                        this.validate(Token.SIMPLE_VALUE);
                        this.addValue(Boolean.TRUE);
                        continue block22;
                    }
                    case VALUE_FALSE: {
                        this.validate(Token.SIMPLE_VALUE);
                        this.addValue(Boolean.FALSE);
                        continue block22;
                    }
                    case VALUE_NULL: {
                        this.validate(Token.SIMPLE_VALUE);
                        this.addValue(Data.NULL);
                        continue block22;
                    }
                    case NOT_AVAILABLE: {
                        this.readNextChunk();
                        return;
                    }
                }
                this.handleException(new Exception("Unexpected token " + (Object)((Object)token) + " at " + this._jsonParser.getTokenLocation()));
            }
            return;
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    private void validate(Token token) {
        if ((this._expectedTokens & token.bitPattern) == 0) {
            this.handleException(new Exception("Expecting " + this.joinTokens(this._expectedTokens) + " but got " + (Object)((Object)token) + " at " + this._jsonParser.getTokenLocation()));
        }
    }

    private void push(DataComplex dataComplex, boolean isList) {
        this.addValue(dataComplex);
        this._stack.push(dataComplex);
        this._isCurrList = isList;
        this._isFieldNameExpected = !this._isCurrList;
        this._expectedTokens = this._isFieldNameExpected ? NEXT_MAP_KEY : NEXT_ARRAY_ITEM;
    }

    private void pop() {
        assert (!this._stack.isEmpty()) : "Trying to pop empty stack at " + this._jsonParser.getTokenLocation();
        DataComplex tmp = this._stack.pop();
        if (this._stack.isEmpty()) {
            this._result = tmp;
            this._expectedTokens = 0;
        } else {
            this._isCurrList = this._stack.peek() instanceof DataList;
            this._isFieldNameExpected = !this._isCurrList;
            this._expectedTokens = this._isFieldNameExpected ? NEXT_MAP_KEY : NEXT_ARRAY_ITEM;
        }
    }

    private void addValue(Object value) {
        if (!this._stack.isEmpty()) {
            DataComplex currItem = this._stack.peek();
            if (this._isCurrList) {
                CheckedUtil.addWithoutChecking((DataList)currItem, value);
                this._expectedTokens = NEXT_ARRAY_ITEM;
            } else {
                CheckedUtil.putWithoutChecking((DataMap)currItem, this._currField, value);
                this._isFieldNameExpected = true;
                this._expectedTokens = NEXT_MAP_KEY;
            }
        }
    }

    @Override
    public void onDone() {
        this._byteArrayFeeder.endOfInput();
        this.processTokens();
        if (this._stack.isEmpty()) {
            this._completable.complete(this._result);
        } else {
            this.handleException(new Exception("Unexpected end of source at " + this._jsonParser.getTokenLocation()));
        }
    }

    @Override
    public void onError(Throwable e) {
        this._completable.completeExceptionally(e);
    }

    @Override
    public CompletionStage<T> getResult() {
        return this._completable;
    }

    private void handleException(Throwable e) {
        this._readHandle.cancel();
        this._completable.completeExceptionally(e);
    }

    private String joinTokens(byte tokens) {
        return tokens == 0 ? "no tokens" : Arrays.stream(Token.values()).filter(token -> (tokens & token.bitPattern) > 0).map(Enum::name).collect(Collectors.joining(", "));
    }

    static enum Token {
        START_ARRAY(1),
        END_ARRAY(2),
        SIMPLE_VALUE(4),
        FIELD_NAME(8),
        STRUCT_MARKER(16);

        final byte bitPattern;

        private Token(int bp) {
            this.bitPattern = (byte)bp;
        }
    }
}

