/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.AbstractJacksonDataCodec;
import com.linkedin.data.codec.DataCodec;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.codec.symbol.SymbolTable;
import com.linkedin.data.collections.CheckedUtil;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.dataformat.smile.SmileFactory;
import datahub.shaded.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JacksonLICORDataCodec
extends AbstractJacksonDataCodec {
    private static final JsonFactory TEXT_FACTORY = new JsonFactory();
    private static final JsonFactory BINARY_FACTORY = new SmileFactory().enable(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES);
    private static final byte MAP_ORDINAL = 0;
    private static final byte LIST_ORDINAL = 1;
    protected final SymbolTable _symbolTable;

    public JacksonLICORDataCodec(boolean useBinary) {
        this(useBinary, (SymbolTable)null);
    }

    public JacksonLICORDataCodec(boolean useBinary, SymbolTable symbolTable) {
        super(JacksonLICORDataCodec.getFactory(useBinary));
        this._symbolTable = symbolTable;
    }

    @Deprecated
    public JacksonLICORDataCodec(boolean useBinary, String symbolTableName) {
        this(useBinary);
    }

    @Override
    protected <T extends DataComplex> T parse(JsonParser jsonParser, Class<T> expectType) throws IOException {
        try {
            Object object = new LICORParser(jsonParser, this._symbolTable).parse(true);
            if (expectType == DataMap.class && object instanceof DataMap) {
                DataComplex dataComplex = (DataComplex)object;
                return (T)dataComplex;
            }
            if (expectType == DataList.class && object instanceof DataList) {
                DataComplex dataComplex = (DataComplex)object;
                return (T)dataComplex;
            }
            throw new DataDecodingException("Unexpected object type: " + object.getClass() + ", expected " + expectType);
        }
        finally {
            DataCodec.closeQuietly(jsonParser);
        }
    }

    @Override
    protected List<Object> parse(JsonParser jsonParser, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws IOException {
        throw new UnsupportedOperationException("Debug mode is not supported with LICOR");
    }

    @Override
    protected Data.TraverseCallback createTraverseCallback(JsonGenerator generator) {
        return new LICORTraverseCallback(generator, this._symbolTable);
    }

    private static JsonFactory getFactory(boolean encodeBinary) {
        return encodeBinary ? BINARY_FACTORY : TEXT_FACTORY;
    }

    public static class LICORTraverseCallback
    extends AbstractJacksonDataCodec.JacksonTraverseCallback {
        private final SymbolTable _symbolTable;

        public LICORTraverseCallback(JsonGenerator generator, SymbolTable symbolTable) {
            super(generator);
            this._symbolTable = symbolTable;
        }

        @Override
        public void key(String key) throws IOException {
            int token;
            if (this._symbolTable != null && (token = this._symbolTable.getSymbolId(key)) != -1) {
                this._generator.writeNumber(token);
            } else {
                this._generator.writeString(key);
            }
        }

        @Override
        public void startList(DataList list) throws IOException {
            this._generator.writeStartArray();
            this._generator.writeNumber((short)1);
        }

        @Override
        public void startMap(DataMap map) throws IOException {
            this._generator.writeStartArray();
            this._generator.writeNumber((short)0);
        }

        @Override
        public void emptyList() throws IOException {
            this._generator.writeStartArray();
            this._generator.writeNumber((short)1);
            this.endList();
        }

        @Override
        public void emptyMap() throws IOException {
            this._generator.writeStartArray();
            this._generator.writeNumber((short)0);
            this.endMap();
        }

        @Override
        public void endMap() throws IOException {
            this._generator.writeEndArray();
        }
    }

    private static class LICORParser {
        private final JsonParser _parser;
        private final SymbolTable _symbolTable;

        LICORParser(JsonParser jsonParser, SymbolTable symbolTable) {
            this._parser = jsonParser;
            this._symbolTable = symbolTable;
        }

        Object parse(boolean moveToNext) throws IOException {
            JsonToken token;
            JsonToken jsonToken = token = moveToNext ? this._parser.nextToken() : this._parser.currentToken();
            if (token == null) {
                return null;
            }
            switch (token) {
                case START_ARRAY: {
                    this._parser.nextToken();
                    byte marker = this._parser.getByteValue();
                    switch (marker) {
                        case 0: {
                            DataMap dataMap = new DataMap();
                            while (this._parser.nextToken() != JsonToken.END_ARRAY) {
                                String key;
                                switch (this._parser.currentToken()) {
                                    case VALUE_STRING: {
                                        key = this._parser.getValueAsString();
                                        break;
                                    }
                                    case VALUE_NUMBER_INT: {
                                        int symbol = this._parser.getIntValue();
                                        if (this._symbolTable != null && (key = this._symbolTable.getSymbolName(symbol)) != null) break;
                                        throw new DataDecodingException("No mapping found for symbol " + symbol);
                                    }
                                    default: {
                                        throw new DataDecodingException("Unexpected token: " + this._parser.currentToken().asString());
                                    }
                                }
                                JsonToken valueType = this._parser.nextToken();
                                if (valueType == null) {
                                    throw new DataDecodingException("Found key: " + key + " without corresponding value");
                                }
                                Object value = this.parse(false);
                                CheckedUtil.putWithoutChecking(dataMap, key, value);
                            }
                            return dataMap;
                        }
                        case 1: {
                            DataList dataList = new DataList();
                            JsonToken elementType;
                            while ((elementType = this._parser.nextToken()) != JsonToken.END_ARRAY) {
                                Object listElement = this.parse(false);
                                if (listElement == null) continue;
                                CheckedUtil.addWithoutChecking(dataList, listElement);
                            }
                            return dataList;
                        }
                    }
                    throw new DataDecodingException("Unexpected marker: " + marker);
                }
                case VALUE_STRING: {
                    return this._parser.getValueAsString();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    JsonParser.NumberType numberType = this._parser.getNumberType();
                    if (numberType == null) {
                        throw new DataDecodingException("Unexpected Number Type: " + token.asString());
                    }
                    switch (numberType) {
                        case INT: {
                            return this._parser.getIntValue();
                        }
                        case LONG: {
                            return this._parser.getLongValue();
                        }
                        case FLOAT: {
                            return Float.valueOf(this._parser.getFloatValue());
                        }
                        case DOUBLE: {
                            return this._parser.getDoubleValue();
                        }
                    }
                    throw new DataDecodingException("Unexpected Number Type: " + token.asString());
                }
                case VALUE_TRUE: {
                    return Boolean.TRUE;
                }
                case VALUE_FALSE: {
                    return Boolean.FALSE;
                }
                case VALUE_NULL: {
                    return Data.NULL;
                }
            }
            throw new DataDecodingException("Unexpected JSON Type: " + token.asString());
        }
    }
}

