/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.FabricType;
import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public class DatasetFieldUrn
extends Urn {
    public static final String ENTITY_TYPE = "datasetField";
    private final DatasetUrn _dataset;
    private final String _fieldPath;

    public DatasetFieldUrn(String dataPlatform, String datasetName, FabricType fabricType, String fieldPath) {
        this(new DatasetUrn(new DataPlatformUrn(dataPlatform), datasetName, fabricType), fieldPath);
    }

    public DatasetFieldUrn(DatasetUrn dataset, String fieldPath) {
        super(ENTITY_TYPE, TupleKey.create(dataset, fieldPath));
        this._dataset = dataset;
        this._fieldPath = fieldPath;
    }

    public static DatasetFieldUrn createFromString(String rawUrn) throws URISyntaxException {
        return DatasetFieldUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static DatasetFieldUrn deserialize(String rawUrn) throws URISyntaxException {
        return DatasetFieldUrn.createFromString(rawUrn);
    }

    public static DatasetFieldUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'datasetField'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 2) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new DatasetFieldUrn(key.getAs(0, DatasetUrn.class), key.getAs(1, String.class));
        }
        catch (Exception var3) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + var3.getMessage());
        }
    }

    public DatasetUrn getDatasetEntity() {
        return this._dataset;
    }

    public String getFieldPathEntity() {
        return this._fieldPath;
    }

    static {
        Custom.initializeCustomClass(DatasetUrn.class);
        Custom.registerCoercer(new DirectCoercer<DatasetFieldUrn>(){

            public String coerceInput(DatasetFieldUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public DatasetFieldUrn coerceOutput(Object object) throws TemplateOutputCastException {
                if (object instanceof String) {
                    try {
                        return DatasetFieldUrn.createFromString((String)object);
                    }
                    catch (URISyntaxException e) {
                        throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                    }
                }
                throw new TemplateOutputCastException("Output '" + object + "' is not a String, and cannot be coerced to " + DatasetFieldUrn.class.getName());
            }
        }, DatasetFieldUrn.class);
    }
}

