/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.InstitutionalMemoryMetadata;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class InstitutionalMemoryMetadataArray
extends WrappingArrayTemplate<InstitutionalMemoryMetadata> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.common/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp associated with updation of this record*/updateStamp:optional AuditStamp}}]", SchemaFormatType.PDL);

    public InstitutionalMemoryMetadataArray() {
        this(new DataList());
    }

    public InstitutionalMemoryMetadataArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public InstitutionalMemoryMetadataArray(Collection<InstitutionalMemoryMetadata> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public InstitutionalMemoryMetadataArray(DataList data) {
        super(data, SCHEMA, InstitutionalMemoryMetadata.class);
    }

    public InstitutionalMemoryMetadataArray(InstitutionalMemoryMetadata first, InstitutionalMemoryMetadata ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public InstitutionalMemoryMetadataArray clone() throws CloneNotSupportedException {
        InstitutionalMemoryMetadataArray __clone = (InstitutionalMemoryMetadataArray)super.clone();
        return __clone;
    }

    @Override
    public InstitutionalMemoryMetadataArray copy() throws CloneNotSupportedException {
        InstitutionalMemoryMetadataArray __copy = (InstitutionalMemoryMetadataArray)super.copy();
        return __copy;
    }

    @Override
    protected InstitutionalMemoryMetadata coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new InstitutionalMemoryMetadata(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private InstitutionalMemoryMetadata.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<InstitutionalMemoryMetadata.ProjectionMask, InstitutionalMemoryMetadata.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? InstitutionalMemoryMetadata.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public InstitutionalMemoryMetadata.Fields items() {
            return new InstitutionalMemoryMetadata.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

