/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.fieldtransformer.TransformationType;
import com.linkedin.common.fieldtransformer.UDFTransformer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseFieldMapping
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Base model representing field mappings*/record BaseFieldMapping{/**Audit stamp containing who reported the field mapping and when*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Transfomration function between the fields involved*/transformation:union[{namespace com.linkedin.common.fieldtransformer/**Type of the transformation involved in generating destination fields from source fields.*/enum TransformationType{/**Field transformation expressed as unknown black box function.*/BLACKBOX/**Field transformation expressed as Identity function.*/IDENTITY}}{namespace com.linkedin.common.fieldtransformer/**Field transformation expressed in UDF*/record UDFTransformer{/**A UDF mentioning how the source fields got transformed to destination field. This is the FQCN(Fully Qualified Class Name) of the udf.*/udf:string}}]}", SchemaFormatType.PDL);
    private AuditStamp _createdField = null;
    private Transformation _transformationField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_Transformation = SCHEMA.getField("transformation");

    public BaseFieldMapping() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public BaseFieldMapping(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public BaseFieldMapping setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.common.BaseFieldMapping");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public BaseFieldMapping setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.common.BaseFieldMapping to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasTransformation() {
        if (this._transformationField != null) {
            return true;
        }
        return this._map.containsKey("transformation");
    }

    public void removeTransformation() {
        this._map.remove("transformation");
    }

    @Nullable
    public Transformation getTransformation(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTransformation();
            }
            case DEFAULT: 
            case NULL: {
                if (this._transformationField != null) {
                    return this._transformationField;
                }
                Object __rawValue = this._map.get("transformation");
                this._transformationField = __rawValue == null ? null : new Transformation(__rawValue);
                return this._transformationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Transformation getTransformation() {
        if (this._transformationField != null) {
            return this._transformationField;
        }
        Object __rawValue = this._map.get("transformation");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("transformation");
        }
        this._transformationField = __rawValue == null ? null : new Transformation(__rawValue);
        return this._transformationField;
    }

    public BaseFieldMapping setTransformation(@Nullable Transformation value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTransformation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field transformation of com.linkedin.common.BaseFieldMapping");
                }
                CheckedUtil.putWithoutChecking(this._map, "transformation", value.data());
                this._transformationField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTransformation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "transformation", value.data());
                this._transformationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "transformation", value.data());
                this._transformationField = value;
            }
        }
        return this;
    }

    public BaseFieldMapping setTransformation(@Nonnull Transformation value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field transformation of com.linkedin.common.BaseFieldMapping to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "transformation", value.data());
        this._transformationField = value;
        return this;
    }

    @Override
    public BaseFieldMapping clone() throws CloneNotSupportedException {
        BaseFieldMapping __clone = (BaseFieldMapping)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BaseFieldMapping copy() throws CloneNotSupportedException {
        BaseFieldMapping __copy = (BaseFieldMapping)super.copy();
        __copy._createdField = null;
        __copy._transformationField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    public static class Transformation
    extends UnionTemplate {
        private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.common.fieldtransformer/**Type of the transformation involved in generating destination fields from source fields.*/enum TransformationType{/**Field transformation expressed as unknown black box function.*/BLACKBOX/**Field transformation expressed as Identity function.*/IDENTITY}}{namespace com.linkedin.common.fieldtransformer/**Field transformation expressed in UDF*/record UDFTransformer{/**A UDF mentioning how the source fields got transformed to destination field. This is the FQCN(Fully Qualified Class Name) of the udf.*/udf:string}}]", SchemaFormatType.PDL);
        private TransformationType _transformationTypeMember = null;
        private UDFTransformer _uDFTransformerMember = null;
        private ChangeListener __changeListener = new ChangeListener(this);
        private static final DataSchema MEMBER_TransformationType = SCHEMA.getTypeByMemberKey("com.linkedin.common.fieldtransformer.TransformationType");
        public static final String MEMBERKEY_TransformationType = "com.linkedin.common.fieldtransformer.TransformationType";
        private static final DataSchema MEMBER_UDFTransformer = SCHEMA.getTypeByMemberKey("com.linkedin.common.fieldtransformer.UDFTransformer");
        public static final String MEMBERKEY_UDFTransformer = "com.linkedin.common.fieldtransformer.UDFTransformer";

        public Transformation() {
            super(new DataMap(2, 0.75f), SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public Transformation(Object data) {
            super(data, SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public static UnionDataSchema dataSchema() {
            return SCHEMA;
        }

        public static Transformation create(TransformationType value) {
            Transformation newUnion = new Transformation();
            newUnion.setTransformationType(value);
            return newUnion;
        }

        public boolean isTransformationType() {
            return this.memberIs(MEMBERKEY_TransformationType);
        }

        public TransformationType getTransformationType() {
            this.checkNotNull();
            if (this._transformationTypeMember != null) {
                return this._transformationTypeMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_TransformationType);
            this._transformationTypeMember = DataTemplateUtil.coerceEnumOutput(__rawValue, TransformationType.class, TransformationType.$UNKNOWN);
            return this._transformationTypeMember;
        }

        public void setTransformationType(TransformationType value) {
            this.checkNotNull();
            this._map.clear();
            this._transformationTypeMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_TransformationType, value.name());
        }

        public static Transformation create(UDFTransformer value) {
            Transformation newUnion = new Transformation();
            newUnion.setUDFTransformer(value);
            return newUnion;
        }

        public boolean isUDFTransformer() {
            return this.memberIs(MEMBERKEY_UDFTransformer);
        }

        public UDFTransformer getUDFTransformer() {
            this.checkNotNull();
            if (this._uDFTransformerMember != null) {
                return this._uDFTransformerMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_UDFTransformer);
            this._uDFTransformerMember = __rawValue == null ? null : new UDFTransformer(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._uDFTransformerMember;
        }

        public void setUDFTransformer(UDFTransformer value) {
            this.checkNotNull();
            this._map.clear();
            this._uDFTransformerMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_UDFTransformer, value.data());
        }

        public static ProjectionMask createMask() {
            return new ProjectionMask();
        }

        @Override
        public Transformation clone() throws CloneNotSupportedException {
            Transformation __clone = (Transformation)super.clone();
            __clone.__changeListener = new ChangeListener(__clone);
            __clone.addChangeListener(__clone.__changeListener);
            return __clone;
        }

        @Override
        public Transformation copy() throws CloneNotSupportedException {
            Transformation __copy = (Transformation)super.copy();
            __copy._uDFTransformerMember = null;
            __copy._transformationTypeMember = null;
            __copy.__changeListener = new ChangeListener(__copy);
            __copy.addChangeListener(__copy.__changeListener);
            return __copy;
        }

        private static class ChangeListener
        implements CheckedMap.ChangeListener<String, Object> {
            private final Transformation __objectRef;

            private ChangeListener(Transformation reference) {
                this.__objectRef = reference;
            }

            @Override
            public void onUnderlyingMapChanged(String key, Object value) {
                switch (key) {
                    case "com.linkedin.common.fieldtransformer.UDFTransformer": {
                        this.__objectRef._uDFTransformerMember = null;
                        break;
                    }
                    case "com.linkedin.common.fieldtransformer.TransformationType": {
                        this.__objectRef._transformationTypeMember = null;
                    }
                }
            }
        }

        public static class ProjectionMask
        extends MaskMap {
            private UDFTransformer.ProjectionMask _UDFTransformerMask;

            ProjectionMask() {
                super(3);
            }

            public ProjectionMask withTransformationType() {
                this.getDataMap().put(Transformation.MEMBERKEY_TransformationType, 1);
                return this;
            }

            public ProjectionMask withUDFTransformer(Function<UDFTransformer.ProjectionMask, UDFTransformer.ProjectionMask> nestedMask) {
                this._UDFTransformerMask = nestedMask.apply(this._UDFTransformerMask == null ? UDFTransformer.createMask() : this._UDFTransformerMask);
                this.getDataMap().put(Transformation.MEMBERKEY_UDFTransformer, this._UDFTransformerMask.getDataMap());
                return this;
            }
        }

        public static class Fields
        extends PathSpec {
            public Fields(List<String> path, String name) {
                super(path, name);
            }

            public Fields() {
            }

            public PathSpec TransformationType() {
                return new PathSpec(this.getPathComponents(), Transformation.MEMBERKEY_TransformationType);
            }

            public UDFTransformer.Fields UDFTransformer() {
                return new UDFTransformer.Fields(this.getPathComponents(), Transformation.MEMBERKEY_UDFTransformer);
            }
        }
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BaseFieldMapping __objectRef;

        private ChangeListener(BaseFieldMapping reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "transformation": {
                    this.__objectRef._transformationField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public Transformation.Fields transformation() {
            return new Transformation.Fields(this.getPathComponents(), "transformation");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;
        private Transformation.ProjectionMask _transformationMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withTransformation(Function<Transformation.ProjectionMask, Transformation.ProjectionMask> nestedMask) {
            this._transformationMask = nestedMask.apply(this._transformationMask == null ? Transformation.createMask() : this._transformationMask);
            this.getDataMap().put("transformation", this._transformationMask.getDataMap());
            return this;
        }

        public ProjectionMask withTransformation() {
            this._transformationMask = null;
            this.getDataMap().put("transformation", 1);
            return this;
        }
    }
}

