/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.FixedIntervalSchedule;
import com.linkedin.assertion.FreshnessAssertionScheduleType;
import com.linkedin.assertion.FreshnessCronSchedule;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FreshnessAssertionSchedule
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a single Freshness schedule.*/record FreshnessAssertionSchedule{/**The type of a Freshness Assertion Schedule.\n\nOnce we support data-time-relative schedules (e.g. schedules relative to time partitions),\nwe will add those schedule types here.*/type:enum FreshnessAssertionScheduleType{/**A highly configurable recurring schedule which describes the times of events described\nby a CRON schedule, with the evaluation schedule assuming to be matching the cron schedule.\n\nIn a CRON schedule type, we compute the look-back window to be the time between the last scheduled event\nand the current event (evaluation time). This means that the evaluation schedule must match exactly\nthe schedule defined inside the cron schedule.\n\nFor example, a CRON schedule defined as \"0 8 * * *\" would represent a schedule of \"every day by 8am\". Assuming\nthat the assertion evaluation schedule is defined to match this, the freshness assertion would be evaluated in the following way:\n\n    1. Compute the \"last scheduled occurrence\" of the event using the CRON schedule. For example, yesterday at 8am.\n    2. Compute the bounds of a time window between the \"last scheduled occurrence\" (yesterday at 8am) until the \"current occurrence\" (today at 8am)\n    3. Verify that the target event has occurred within the CRON-interval window.\n    4. If the target event has occurred within the time window, then assertion passes.\n    5. If the target event has not occurred within the time window, then the assertion fails.\n*/CRON/**A fixed interval which is used to compute a look-back window for use when evaluating the assertion relative\nto the Evaluation Time of the Assertion.\n\nTo compute the valid look-back window, we subtract the fixed interval from the evaluation time. Then, we verify\nthat the target event has occurred within that window.\n\nFor example, a fixed interval of \"24h\" would represent a schedule of \"in the last 24 hours\".\nThe 24 hour interval is relative to the evaluation time of the assertion. For example if we schedule the assertion\nto be evaluated each hour, we'd compute the result as follows:\n\n    1. Subtract the fixed interval from the current time (Evaluation time) to compute the bounds of a fixed look-back window.\n    2. Verify that the target event has occurred within the look-back window.\n    3. If the target event has occurred within the time window, then assertion passes.\n    4. If the target event has not occurred within the time window, then the assertion fails.\n*/FIXED_INTERVAL/**A stateful check that takes the last time this check ran to determine the look-back window.\n\nTo compute the valid look-back- window, we start at the time the monitor last evaluated this assertion,\nand we end at the point in time the check is currently running.\n\nFor example, let's say a Freshness assertion is of type SINCE_THE_LAST_CHECK, and the monitor is configured to\nrun every day at 12:00am. Let's assume this assertion was last evaluated yesterday at 12:04am. We'd compute\nthe result as follows:\n\n    1. Get the timestamp for the last run of the monitor on this assertion.\n    2. look_back_window_start_time = latest_monitor_run.timestampMillis [ie. 12:04a yesterday]\n    3. look_back_window_end_time = nowMillis [ie. 12:02a today]\n    4. If the target event has occurred within the window [ie. 12:04a yday to 12:02a today],\n       then the assertion passes.\n    5. If the target event has not occurred within the window, then the assertion fails.\n*/SINCE_THE_LAST_CHECK}/**A cron schedule. This field is required when type is CRON.*/cron:optional/**Attributes defining a CRON-formatted schedule used for defining a freshness assertion.*/record FreshnessCronSchedule{/**A cron-formatted execution interval, as a cron string, e.g. 1 * * * **/cron:string/**Timezone in which the cron interval applies, e.g. America/Los Angeles*/timezone:string/**An optional offset in milliseconds to SUBTRACT from the timestamp generated by the cron schedule\nto generate the lower bounds of the \"freshness window\", or the window of time in which an event must have occurred in order for the Freshness check\nto be considering passing.\n\nIf left empty, the start of the SLA window will be the _end_ of the previously evaluated Freshness window.*/windowStartOffsetMs:optional long}/**A fixed interval schedule. This field is required when type is FIXED_INTERVAL.*/fixedInterval:optional/**Attributes defining a relative fixed interval SLA schedule.*/record FixedIntervalSchedule includes{namespace com.linkedin.timeseries/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}}{}}", SchemaFormatType.PDL);
    private FreshnessAssertionScheduleType _typeField = null;
    private FreshnessCronSchedule _cronField = null;
    private FixedIntervalSchedule _fixedIntervalField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Cron = SCHEMA.getField("cron");
    private static final RecordDataSchema.Field FIELD_FixedInterval = SCHEMA.getField("fixedInterval");

    public FreshnessAssertionSchedule() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FreshnessAssertionSchedule(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public FreshnessAssertionScheduleType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FreshnessAssertionScheduleType.class, FreshnessAssertionScheduleType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FreshnessAssertionScheduleType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FreshnessAssertionScheduleType.class, FreshnessAssertionScheduleType.$UNKNOWN);
        return this._typeField;
    }

    public FreshnessAssertionSchedule setType(@Nullable FreshnessAssertionScheduleType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.FreshnessAssertionSchedule");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public FreshnessAssertionSchedule setType(@Nonnull FreshnessAssertionScheduleType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.FreshnessAssertionSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasCron() {
        if (this._cronField != null) {
            return true;
        }
        return this._map.containsKey("cron");
    }

    public void removeCron() {
        this._map.remove("cron");
    }

    @Nullable
    public FreshnessCronSchedule getCron(GetMode mode) {
        return this.getCron();
    }

    @Nullable
    public FreshnessCronSchedule getCron() {
        if (this._cronField != null) {
            return this._cronField;
        }
        Object __rawValue = this._map.get("cron");
        this._cronField = __rawValue == null ? null : new FreshnessCronSchedule(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._cronField;
    }

    public FreshnessAssertionSchedule setCron(@Nullable FreshnessCronSchedule value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCron(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCron();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cron", value.data());
                this._cronField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cron", value.data());
                this._cronField = value;
            }
        }
        return this;
    }

    public FreshnessAssertionSchedule setCron(@Nonnull FreshnessCronSchedule value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cron of com.linkedin.assertion.FreshnessAssertionSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cron", value.data());
        this._cronField = value;
        return this;
    }

    public boolean hasFixedInterval() {
        if (this._fixedIntervalField != null) {
            return true;
        }
        return this._map.containsKey("fixedInterval");
    }

    public void removeFixedInterval() {
        this._map.remove("fixedInterval");
    }

    @Nullable
    public FixedIntervalSchedule getFixedInterval(GetMode mode) {
        return this.getFixedInterval();
    }

    @Nullable
    public FixedIntervalSchedule getFixedInterval() {
        if (this._fixedIntervalField != null) {
            return this._fixedIntervalField;
        }
        Object __rawValue = this._map.get("fixedInterval");
        this._fixedIntervalField = __rawValue == null ? null : new FixedIntervalSchedule(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._fixedIntervalField;
    }

    public FreshnessAssertionSchedule setFixedInterval(@Nullable FixedIntervalSchedule value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFixedInterval(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFixedInterval();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fixedInterval", value.data());
                this._fixedIntervalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fixedInterval", value.data());
                this._fixedIntervalField = value;
            }
        }
        return this;
    }

    public FreshnessAssertionSchedule setFixedInterval(@Nonnull FixedIntervalSchedule value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fixedInterval of com.linkedin.assertion.FreshnessAssertionSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fixedInterval", value.data());
        this._fixedIntervalField = value;
        return this;
    }

    @Override
    public FreshnessAssertionSchedule clone() throws CloneNotSupportedException {
        FreshnessAssertionSchedule __clone = (FreshnessAssertionSchedule)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FreshnessAssertionSchedule copy() throws CloneNotSupportedException {
        FreshnessAssertionSchedule __copy = (FreshnessAssertionSchedule)super.copy();
        __copy._cronField = null;
        __copy._typeField = null;
        __copy._fixedIntervalField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FreshnessAssertionSchedule __objectRef;

        private ChangeListener(FreshnessAssertionSchedule reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "cron": {
                    this.__objectRef._cronField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "fixedInterval": {
                    this.__objectRef._fixedIntervalField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public FreshnessCronSchedule.Fields cron() {
            return new FreshnessCronSchedule.Fields(this.getPathComponents(), "cron");
        }

        public FixedIntervalSchedule.Fields fixedInterval() {
            return new FixedIntervalSchedule.Fields(this.getPathComponents(), "fixedInterval");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FreshnessCronSchedule.ProjectionMask _cronMask;
        private FixedIntervalSchedule.ProjectionMask _fixedIntervalMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withCron(Function<FreshnessCronSchedule.ProjectionMask, FreshnessCronSchedule.ProjectionMask> nestedMask) {
            this._cronMask = nestedMask.apply(this._cronMask == null ? FreshnessCronSchedule.createMask() : this._cronMask);
            this.getDataMap().put("cron", this._cronMask.getDataMap());
            return this;
        }

        public ProjectionMask withCron() {
            this._cronMask = null;
            this.getDataMap().put("cron", 1);
            return this;
        }

        public ProjectionMask withFixedInterval(Function<FixedIntervalSchedule.ProjectionMask, FixedIntervalSchedule.ProjectionMask> nestedMask) {
            this._fixedIntervalMask = nestedMask.apply(this._fixedIntervalMask == null ? FixedIntervalSchedule.createMask() : this._fixedIntervalMask);
            this.getDataMap().put("fixedInterval", this._fixedIntervalMask.getDataMap());
            return this;
        }

        public ProjectionMask withFixedInterval() {
            this._fixedIntervalMask = null;
            this.getDataMap().put("fixedInterval", 1);
            return this;
        }
    }
}

