/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.timeseries;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.timeseries.GroupingBucketType;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroupingBucket
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.timeseries/**Defines the group by bucket definitions for time series requests.*/record GroupingBucket{/**Type of the grouping bucket.*/type:/**Defines a grouping bucket type.*/enum GroupingBucketType{DATE_GROUPING_BUCKET,STRING_GROUPING_BUCKET}/**Key that specifies the column name to be used as the timestamp field for bucketing.*/key:string/**Bucket size (like a day/hour etc) for the date grouping buckets.*/timeWindowSize:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}}", SchemaFormatType.PDL);
    private GroupingBucketType _typeField = null;
    private String _keyField = null;
    private TimeWindowSize _timeWindowSizeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Key = SCHEMA.getField("key");
    private static final RecordDataSchema.Field FIELD_TimeWindowSize = SCHEMA.getField("timeWindowSize");

    public GroupingBucket() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public GroupingBucket(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public GroupingBucketType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, GroupingBucketType.class, GroupingBucketType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public GroupingBucketType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, GroupingBucketType.class, GroupingBucketType.$UNKNOWN);
        return this._typeField;
    }

    public GroupingBucket setType(@Nullable GroupingBucketType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.timeseries.GroupingBucket");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public GroupingBucket setType(@Nonnull GroupingBucketType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.timeseries.GroupingBucket to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasKey() {
        if (this._keyField != null) {
            return true;
        }
        return this._map.containsKey("key");
    }

    public void removeKey() {
        this._map.remove("key");
    }

    @Nullable
    public String getKey(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getKey();
            }
            case DEFAULT: 
            case NULL: {
                if (this._keyField != null) {
                    return this._keyField;
                }
                Object __rawValue = this._map.get("key");
                this._keyField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._keyField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getKey() {
        if (this._keyField != null) {
            return this._keyField;
        }
        Object __rawValue = this._map.get("key");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("key");
        }
        this._keyField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._keyField;
    }

    public GroupingBucket setKey(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setKey(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field key of com.linkedin.timeseries.GroupingBucket");
                }
                CheckedUtil.putWithoutChecking(this._map, "key", value);
                this._keyField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeKey();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "key", value);
                this._keyField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "key", value);
                this._keyField = value;
            }
        }
        return this;
    }

    public GroupingBucket setKey(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field key of com.linkedin.timeseries.GroupingBucket to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "key", value);
        this._keyField = value;
        return this;
    }

    public boolean hasTimeWindowSize() {
        if (this._timeWindowSizeField != null) {
            return true;
        }
        return this._map.containsKey("timeWindowSize");
    }

    public void removeTimeWindowSize() {
        this._map.remove("timeWindowSize");
    }

    @Nullable
    public TimeWindowSize getTimeWindowSize(GetMode mode) {
        return this.getTimeWindowSize();
    }

    @Nullable
    public TimeWindowSize getTimeWindowSize() {
        if (this._timeWindowSizeField != null) {
            return this._timeWindowSizeField;
        }
        Object __rawValue = this._map.get("timeWindowSize");
        this._timeWindowSizeField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._timeWindowSizeField;
    }

    public GroupingBucket setTimeWindowSize(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimeWindowSize(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimeWindowSize();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timeWindowSize", value.data());
                this._timeWindowSizeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timeWindowSize", value.data());
                this._timeWindowSizeField = value;
            }
        }
        return this;
    }

    public GroupingBucket setTimeWindowSize(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timeWindowSize of com.linkedin.timeseries.GroupingBucket to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timeWindowSize", value.data());
        this._timeWindowSizeField = value;
        return this;
    }

    @Override
    public GroupingBucket clone() throws CloneNotSupportedException {
        GroupingBucket __clone = (GroupingBucket)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GroupingBucket copy() throws CloneNotSupportedException {
        GroupingBucket __copy = (GroupingBucket)super.copy();
        __copy._typeField = null;
        __copy._keyField = null;
        __copy._timeWindowSizeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GroupingBucket __objectRef;

        private ChangeListener(GroupingBucket reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "key": {
                    this.__objectRef._keyField = null;
                    break;
                }
                case "timeWindowSize": {
                    this.__objectRef._timeWindowSizeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec key() {
            return new PathSpec(this.getPathComponents(), "key");
        }

        public TimeWindowSize.Fields timeWindowSize() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "timeWindowSize");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _timeWindowSizeMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withKey() {
            this.getDataMap().put("key", 1);
            return this;
        }

        public ProjectionMask withTimeWindowSize(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._timeWindowSizeMask = nestedMask.apply(this._timeWindowSizeMask == null ? TimeWindowSize.createMask() : this._timeWindowSizeMask);
            this.getDataMap().put("timeWindowSize", this._timeWindowSizeMask.getDataMap());
            return this;
        }

        public ProjectionMask withTimeWindowSize() {
            this._timeWindowSizeMask = null;
            this.getDataMap().put("timeWindowSize", 1);
            return this;
        }
    }
}

