/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.global;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.settings.global.DocPropagationFeatureSettings;
import com.linkedin.settings.global.GlobalViewsSettings;
import com.linkedin.settings.global.SsoSettings;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlobalSettingsInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.global/**DataHub Global platform settings. Careful - these should not be modified by the outside world!*/@Aspect.name=\"globalSettingsInfo\"record GlobalSettingsInfo{/**SSO integrations between DataHub and identity providers*/sso:optional/**SSO Integrations, supported on the UI.*/record SsoSettings{/**Auth base URL.*/baseUrl:string/**Optional OIDC SSO settings.*/oidcSettings:optional/**Settings for OIDC SSO integration.*/record OidcSettings{/**Whether OIDC SSO is enabled.*/enabled:boolean/**Unique client id issued by the identity provider.*/clientId:string/**Unique client secret issued by the identity provider.*/clientSecret:string/**The IdP OIDC discovery url.*/discoveryUri:string/**ADVANCED. The attribute / claim used to derive the DataHub username. Defaults to \"preferred_username\".*/userNameClaim:optional string/**ADVANCED. TThe regex used to parse the DataHub username from the user name claim. Defaults to (.*) (all).*/userNameClaimRegex:optional string/**ADVANCED. String representing the requested scope from the IdP. Defaults to \"oidc email profile\".*/scope:optional string/**ADVANCED. Which authentication method to use to pass credentials (clientId and clientSecret) to the token endpoint: Defaults to \"client_secret_basic\".*/clientAuthenticationMethod:optional string/**ADVANCED. Whether DataHub users should be provisioned on login if they do not exist. Defaults to true.*/jitProvisioningEnabled:optional boolean/**ADVANCED. Whether the user should already exist in DataHub on login, failing login if they are not. Defaults to false.*/preProvisioningRequired:optional boolean/**ADVANCED. Whether groups should be extracted from a claim in the OIDC profile. Only applies if JIT provisioning is enabled. Groups will be created if they do not exist. Defaults to true.*/extractGroupsEnabled:optional boolean/**ADVANCED. The OIDC claim to extract groups information from. Defaults to 'groups'.*/groupsClaim:optional string/**ADVANCED. Response type.*/responseType:optional string/**ADVANCED. Response mode.*/responseMode:optional string/**ADVANCED. Use Nonce.*/useNonce:optional boolean/**ADVANCED. Read timeout.*/readTimeout:optional long/**ADVANCED. Whether to extract claims from JWT access token.  Defaults to false.*/extractJwtAccessTokenClaims:optional boolean/** ADVANCED. Which jws algorithm to use. Unused.*/preferredJwsAlgorithm:optional string/** ADVANCED. Which jws algorithm to use.*/preferredJwsAlgorithm2:optional string}}/**Settings related to the Views Feature*/views:optional/**Settings for DataHub Views feature.*/record GlobalViewsSettings{/**The default View for the instance, or organization.*/@Relationship={\"entityTypes\":[\"dataHubView\"],\"name\":\"viewedWith\"}defaultView:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**Settings related to the documentation propagation feature*/docPropagation:optional record DocPropagationFeatureSettings includes/**A standardized settings template for a feature.*/record FeatureSettings{enabled:boolean/**The configuration for the feature, in JSON format.*/config:optional string/**The version of the configuration schema that has been used to serialize\n       the config.\nIf not provided, the version is assumed to be the latest version.*/configVersion:optional string}{columnPropagationEnabled:boolean=true}={\"enabled\":true,\"columnPropagationEnabled\":true}}", SchemaFormatType.PDL);
    private SsoSettings _ssoField = null;
    private GlobalViewsSettings _viewsField = null;
    private DocPropagationFeatureSettings _docPropagationField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Sso = SCHEMA.getField("sso");
    private static final RecordDataSchema.Field FIELD_Views = SCHEMA.getField("views");
    private static final RecordDataSchema.Field FIELD_DocPropagation = SCHEMA.getField("docPropagation");
    private static final DocPropagationFeatureSettings DEFAULT_DocPropagation = FIELD_DocPropagation.getDefault() == null ? null : new DocPropagationFeatureSettings(DataTemplateUtil.castOrThrow(FIELD_DocPropagation.getDefault(), DataMap.class));

    public GlobalSettingsInfo() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public GlobalSettingsInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSso() {
        if (this._ssoField != null) {
            return true;
        }
        return this._map.containsKey("sso");
    }

    public void removeSso() {
        this._map.remove("sso");
    }

    @Nullable
    public SsoSettings getSso(GetMode mode) {
        return this.getSso();
    }

    @Nullable
    public SsoSettings getSso() {
        if (this._ssoField != null) {
            return this._ssoField;
        }
        Object __rawValue = this._map.get("sso");
        this._ssoField = __rawValue == null ? null : new SsoSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._ssoField;
    }

    public GlobalSettingsInfo setSso(@Nullable SsoSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSso(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSso();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sso", value.data());
                this._ssoField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sso", value.data());
                this._ssoField = value;
            }
        }
        return this;
    }

    public GlobalSettingsInfo setSso(@Nonnull SsoSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sso of com.linkedin.settings.global.GlobalSettingsInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sso", value.data());
        this._ssoField = value;
        return this;
    }

    public boolean hasViews() {
        if (this._viewsField != null) {
            return true;
        }
        return this._map.containsKey("views");
    }

    public void removeViews() {
        this._map.remove("views");
    }

    @Nullable
    public GlobalViewsSettings getViews(GetMode mode) {
        return this.getViews();
    }

    @Nullable
    public GlobalViewsSettings getViews() {
        if (this._viewsField != null) {
            return this._viewsField;
        }
        Object __rawValue = this._map.get("views");
        this._viewsField = __rawValue == null ? null : new GlobalViewsSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._viewsField;
    }

    public GlobalSettingsInfo setViews(@Nullable GlobalViewsSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setViews(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeViews();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "views", value.data());
                this._viewsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "views", value.data());
                this._viewsField = value;
            }
        }
        return this;
    }

    public GlobalSettingsInfo setViews(@Nonnull GlobalViewsSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field views of com.linkedin.settings.global.GlobalSettingsInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "views", value.data());
        this._viewsField = value;
        return this;
    }

    public boolean hasDocPropagation() {
        if (this._docPropagationField != null) {
            return true;
        }
        return this._map.containsKey("docPropagation");
    }

    public void removeDocPropagation() {
        this._map.remove("docPropagation");
    }

    @Nullable
    public DocPropagationFeatureSettings getDocPropagation(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getDocPropagation();
            }
            case NULL: {
                if (this._docPropagationField != null) {
                    return this._docPropagationField;
                }
                Object __rawValue = this._map.get("docPropagation");
                this._docPropagationField = __rawValue == null ? null : new DocPropagationFeatureSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._docPropagationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public DocPropagationFeatureSettings getDocPropagation() {
        if (this._docPropagationField != null) {
            return this._docPropagationField;
        }
        Object __rawValue = this._map.get("docPropagation");
        if (__rawValue == null) {
            return DEFAULT_DocPropagation;
        }
        this._docPropagationField = __rawValue == null ? null : new DocPropagationFeatureSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._docPropagationField;
    }

    public GlobalSettingsInfo setDocPropagation(@Nullable DocPropagationFeatureSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDocPropagation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDocPropagation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "docPropagation", value.data());
                this._docPropagationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "docPropagation", value.data());
                this._docPropagationField = value;
            }
        }
        return this;
    }

    public GlobalSettingsInfo setDocPropagation(@Nonnull DocPropagationFeatureSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field docPropagation of com.linkedin.settings.global.GlobalSettingsInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "docPropagation", value.data());
        this._docPropagationField = value;
        return this;
    }

    @Override
    public GlobalSettingsInfo clone() throws CloneNotSupportedException {
        GlobalSettingsInfo __clone = (GlobalSettingsInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GlobalSettingsInfo copy() throws CloneNotSupportedException {
        GlobalSettingsInfo __copy = (GlobalSettingsInfo)super.copy();
        __copy._docPropagationField = null;
        __copy._ssoField = null;
        __copy._viewsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GlobalSettingsInfo __objectRef;

        private ChangeListener(GlobalSettingsInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "docPropagation": {
                    this.__objectRef._docPropagationField = null;
                    break;
                }
                case "sso": {
                    this.__objectRef._ssoField = null;
                    break;
                }
                case "views": {
                    this.__objectRef._viewsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public SsoSettings.Fields sso() {
            return new SsoSettings.Fields(this.getPathComponents(), "sso");
        }

        public GlobalViewsSettings.Fields views() {
            return new GlobalViewsSettings.Fields(this.getPathComponents(), "views");
        }

        public DocPropagationFeatureSettings.Fields docPropagation() {
            return new DocPropagationFeatureSettings.Fields(this.getPathComponents(), "docPropagation");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SsoSettings.ProjectionMask _ssoMask;
        private GlobalViewsSettings.ProjectionMask _viewsMask;
        private DocPropagationFeatureSettings.ProjectionMask _docPropagationMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withSso(Function<SsoSettings.ProjectionMask, SsoSettings.ProjectionMask> nestedMask) {
            this._ssoMask = nestedMask.apply(this._ssoMask == null ? SsoSettings.createMask() : this._ssoMask);
            this.getDataMap().put("sso", this._ssoMask.getDataMap());
            return this;
        }

        public ProjectionMask withSso() {
            this._ssoMask = null;
            this.getDataMap().put("sso", 1);
            return this;
        }

        public ProjectionMask withViews(Function<GlobalViewsSettings.ProjectionMask, GlobalViewsSettings.ProjectionMask> nestedMask) {
            this._viewsMask = nestedMask.apply(this._viewsMask == null ? GlobalViewsSettings.createMask() : this._viewsMask);
            this.getDataMap().put("views", this._viewsMask.getDataMap());
            return this;
        }

        public ProjectionMask withViews() {
            this._viewsMask = null;
            this.getDataMap().put("views", 1);
            return this;
        }

        public ProjectionMask withDocPropagation(Function<DocPropagationFeatureSettings.ProjectionMask, DocPropagationFeatureSettings.ProjectionMask> nestedMask) {
            this._docPropagationMask = nestedMask.apply(this._docPropagationMask == null ? DocPropagationFeatureSettings.createMask() : this._docPropagationMask);
            this.getDataMap().put("docPropagation", this._docPropagationMask.getDataMap());
            return this;
        }

        public ProjectionMask withDocPropagation() {
            this._docPropagationMask = null;
            this.getDataMap().put("docPropagation", 1);
            return this;
        }
    }
}

