/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.query.QuerySubject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class QuerySubjectArray
extends WrappingArrayTemplate<QuerySubject> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.query/**A single subject of a particular query.\nIn the future, we may evolve this model to include richer details\nabout the Query Subject in relation to the query.*/record QuerySubject{/**An entity which is the subject of a query.*/@Relationship={\"entityTypes\":[\"dataset\",\"schemaField\"],\"name\":\"IsAssociatedWith\"}@Searchable={\"fieldName\":\"entities\",\"fieldType\":\"URN\"}entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}}]", SchemaFormatType.PDL);

    public QuerySubjectArray() {
        this(new DataList());
    }

    public QuerySubjectArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public QuerySubjectArray(Collection<QuerySubject> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public QuerySubjectArray(DataList data) {
        super(data, SCHEMA, QuerySubject.class);
    }

    public QuerySubjectArray(QuerySubject first, QuerySubject ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public QuerySubjectArray clone() throws CloneNotSupportedException {
        QuerySubjectArray __clone = (QuerySubjectArray)super.clone();
        return __clone;
    }

    @Override
    public QuerySubjectArray copy() throws CloneNotSupportedException {
        QuerySubjectArray __copy = (QuerySubjectArray)super.copy();
        return __copy;
    }

    @Override
    protected QuerySubject coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new QuerySubject(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private QuerySubject.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<QuerySubject.ProjectionMask, QuerySubject.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? QuerySubject.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public QuerySubject.Fields items() {
            return new QuerySubject.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

