/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.jmx.JmxReporter;

public class MetricUtils {
    public static final String DROPWIZARD_METRIC = "dwizMetric";
    public static final String DROPWIZARD_NAME = "dwizName";
    public static final String CACHE_HIT_ATTR = "cache.hit";
    public static final String BATCH_SIZE_ATTR = "batch.size";
    public static final String QUEUE_ENQUEUED_AT_ATTR = "queue.enqueued_at";
    public static final String QUEUE_DURATION_MS_ATTR = "queue.duration_ms";
    public static final String MESSAGING_SYSTEM = "messaging.system";
    public static final String MESSAGING_DESTINATION = "messaging.destination";
    public static final String MESSAGING_DESTINATION_KIND = "messaging.destination_kind";
    public static final String MESSAGING_OPERATION = "messaging.operation";
    public static final String ERROR_TYPE = "error.type";
    public static final String CHANGE_TYPE = "aspect.change_type";
    public static final String ENTITY_TYPE = "aspect.entity_type";
    public static final String ASPECT_NAME = "aspect.name";
    public static final String DELIMITER = "_";
    public static final String NAME = "default";
    private static final MetricRegistry REGISTRY = SharedMetricRegistries.getOrCreate((String)"default");

    private MetricUtils() {
    }

    public static MetricRegistry get() {
        return REGISTRY;
    }

    public static Counter counter(Class<?> klass, String metricName) {
        return REGISTRY.counter(MetricRegistry.name(klass, (String[])new String[]{metricName}));
    }

    public static void exceptionCounter(Class<?> klass, String metricName, Throwable t2) {
        String[] splitClassName = t2.getClass().getName().split("[.]");
        String snakeCase = splitClassName[splitClassName.length - 1].replaceAll("([A-Z][a-z])", "_$1");
        MetricUtils.counter(klass, metricName).inc();
        MetricUtils.counter(klass, metricName + DELIMITER + snakeCase).inc();
    }

    public static Counter counter(String metricName) {
        return REGISTRY.counter(MetricRegistry.name((String)metricName, (String[])new String[0]));
    }

    public static String name(String name, String ... names) {
        return MetricRegistry.name((String)name, (String[])names);
    }

    public static String name(Class<?> clazz, String ... names) {
        return MetricRegistry.name((String)clazz.getName(), (String[])names);
    }

    public static <T extends Gauge<?>> T gauge(Class<?> clazz, String metricName, MetricRegistry.MetricSupplier<T> supplier) {
        return (T)REGISTRY.gauge(MetricRegistry.name(clazz, (String[])new String[]{metricName}), supplier);
    }

    static {
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)REGISTRY).build();
        reporter.start();
    }
}

