/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.elasticsearch;

import com.google.common.collect.ImmutableList;
import com.linkedin.data.template.StringArray;
import com.linkedin.metadata.query.filter.Condition;
import com.linkedin.metadata.query.filter.ConjunctiveCriterion;
import com.linkedin.metadata.query.filter.ConjunctiveCriterionArray;
import com.linkedin.metadata.query.filter.Criterion;
import com.linkedin.metadata.query.filter.CriterionArray;
import com.linkedin.metadata.query.filter.Filter;
import com.linkedin.metadata.utils.CriterionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilterUtils {
    @Nonnull
    public static Filter combineFilters(@Nullable Filter baseFilter, @Nonnull Filter viewFilter) {
        Filter finalBaseFilter = baseFilter == null ? new Filter().setOr(new ConjunctiveCriterionArray(Collections.emptyList())) : baseFilter;
        return FilterUtils.combineFiltersInConjunction(finalBaseFilter, viewFilter);
    }

    @Nonnull
    private static Filter combineFiltersInConjunction(@Nonnull Filter filter1, @Nonnull Filter filter2) {
        Filter finalFilter1 = FilterUtils.convertToV2Filter(filter1);
        Filter finalFilter2 = FilterUtils.convertToV2Filter(filter2);
        if (!finalFilter1.hasOr() || finalFilter1.getOr().size() == 0) {
            return finalFilter2;
        }
        if (!finalFilter2.hasOr() || finalFilter2.getOr().size() == 0) {
            return finalFilter1;
        }
        Filter result = new Filter();
        ArrayList<ConjunctiveCriterion> newDisjunction = new ArrayList<ConjunctiveCriterion>();
        for (ConjunctiveCriterion conjunction1 : finalFilter1.getOr()) {
            for (ConjunctiveCriterion conjunction2 : finalFilter2.getOr()) {
                ArrayList<Criterion> joinedCriterion = new ArrayList<Criterion>(conjunction1.getAnd());
                joinedCriterion.addAll(conjunction2.getAnd());
                ConjunctiveCriterion newConjunction = new ConjunctiveCriterion().setAnd(new CriterionArray(joinedCriterion));
                newDisjunction.add(newConjunction);
            }
        }
        result.setOr(new ConjunctiveCriterionArray(newDisjunction));
        return result;
    }

    @Nonnull
    private static Filter convertToV2Filter(@Nonnull Filter filter) {
        if (filter.hasOr()) {
            return filter;
        }
        if (filter.hasCriteria()) {
            return new Filter().setOr(new ConjunctiveCriterionArray(ImmutableList.of(new ConjunctiveCriterion().setAnd(filter.getCriteria()))));
        }
        throw new IllegalArgumentException(String.format("Illegal filter provided! Neither 'or' nor 'criteria' fields were populated for filter %s", filter));
    }

    @Nonnull
    public static Filter createValuesFilter(@Nonnull String fieldName, @Nonnull List<String> values) {
        Filter filter = new Filter();
        CriterionArray criterionArray = new CriterionArray();
        StringArray valuesArray = new StringArray();
        valuesArray.addAll(values);
        Criterion criterion = CriterionUtils.buildCriterion(fieldName, Condition.EQUAL, valuesArray);
        criterionArray.add(criterion);
        filter.setOr(new ConjunctiveCriterionArray(ImmutableList.of(new ConjunctiveCriterion().setAnd(criterionArray))));
        return filter;
    }
}

