/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.snapshot;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.aspect.MLFeatureTableAspectArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLFeatureTableSnapshot
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.snapshot@Entity={\"keyAspect\":\"mlFeatureTableKey\",\"name\":\"mlFeatureTable\"}record MLFeatureTableSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The list of metadata aspects associated with the MLFeatureTable. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a MLFeatureTable*/typeref MLFeatureTableAspect=union[{namespace com.linkedin.metadata.key/**Key for an MLFeatureTable*/@Aspect.name=\"mlFeatureTableKey\"record MLFeatureTableKey{/**Data platform urn associated with the feature table*/@Relationship={\"entityTypes\":[\"dataPlatform\"],\"name\":\"SourcePlatform\"}platform:com.linkedin.common.Urn/**Name of the feature table*/@Searchable={\"boostScore\":8.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.ml.metadata/**Properties associated with a MLFeatureTable*/@Aspect.name=\"mlFeatureTableProperties\"record MLFeatureTableProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Documentation of the MLFeatureTable*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**List of features contained in the feature table*/@Relationship.`/*`={\"entityTypes\":[\"mlFeature\"],\"name\":\"Contains\"}@Searchable.`/*`={\"fieldName\":\"features\",\"fieldType\":\"URN\"}mlFeatures:optional array[com.linkedin.common.Urn]/**List of primary keys in the feature table (if multiple, assumed to act as a composite key)*/@Relationship.`/*`={\"entityTypes\":[\"mlPrimaryKey\"],\"name\":\"KeyedBy\"}@Searchable.`/*`={\"fieldName\":\"primaryKeys\",\"fieldType\":\"URN\"}mlPrimaryKeys:optional array[com.linkedin.common.Urn]}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:Urn/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.common/**Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity.*/@Aspect.name=\"institutionalMemory\"record InstitutionalMemory{/**List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record.*/elements:array[/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:AuditStamp}]}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}{namespace com.linkedin.common/**Deprecation status of an entity*/@Aspect.name=\"deprecation\"record Deprecation{/**Whether the entity is deprecated.*/@Searchable={\"addToFilters\":true,\"fieldType\":\"BOOLEAN\",\"filterNameOverride\":\"Deprecated\",\"weightsPerFieldValue\":{\"true\":0.5}}deprecated:boolean/**The time user plan to decommission this entity.*/decommissionTime:optional Time/**Additional information about the entity deprecation plan, such as the wiki, doc, RB.*/note:string/**The user URN which will be credited for modifying this deprecation content.*/actor:Urn,replacement:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing Browse Paths to be indexed for an entity.*/@Aspect.name=\"browsePaths\"record BrowsePaths{/**A list of valid browse paths for the entity.\n\nBrowse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'*/@Searchable.`/*`={\"fieldName\":\"browsePaths\",\"fieldType\":\"BROWSE_PATH\"}paths:array[string]}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}{namespace com.linkedin.common/**The specific instance of the data platform that this entity belongs to*/@Aspect.name=\"dataPlatformInstance\"record DataPlatformInstance{/**Data Platform*/@Searchable={\"addToFilters\":true,\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform\"}platform:Urn/**Instance of the data platform (e.g. db instance)*/@Searchable={\"addToFilters\":true,\"fieldName\":\"platformInstance\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform Instance\"}instance:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing a Browse Path to be indexed for an entity.*/@Aspect.name=\"browsePathsV2\"record BrowsePathsV2{/**A valid browse path for the entity. This field is provided by DataHub by default.\nThis aspect is a newer version of browsePaths where we can encode more information in the path.\nThis path is also based on containers for a given entity if it has containers.\n\nThis is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.\nThese paths should not include high level info captured elsewhere ie. Platform and Environment.*/@Searchable.`/*/id`={\"fieldName\":\"browsePathV2\",\"fieldType\":\"BROWSE_PATH_V2\"}path:array[/**Represents a single level in an entity's browsePathV2*/record BrowsePathEntry{/**The ID of the browse path entry. This is what gets stored in the index.\nIf there's an urn associated with this entry, id and urn will be the same*/id:string/**Optional urn pointing to some entity in DataHub*/urn:optional Urn}]}}]}]}", SchemaFormatType.PDL);
    private Urn _urnField = null;
    private MLFeatureTableAspectArray _aspectsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_Aspects = SCHEMA.getField("aspects");

    public MLFeatureTableSnapshot() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public MLFeatureTableSnapshot(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public Urn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._urnField;
    }

    public MLFeatureTableSnapshot setUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.metadata.snapshot.MLFeatureTableSnapshot");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public MLFeatureTableSnapshot setUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.metadata.snapshot.MLFeatureTableSnapshot to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasAspects() {
        if (this._aspectsField != null) {
            return true;
        }
        return this._map.containsKey("aspects");
    }

    public void removeAspects() {
        this._map.remove("aspects");
    }

    @Nullable
    public MLFeatureTableAspectArray getAspects(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAspects();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aspectsField != null) {
                    return this._aspectsField;
                }
                Object __rawValue = this._map.get("aspects");
                this._aspectsField = __rawValue == null ? null : new MLFeatureTableAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._aspectsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public MLFeatureTableAspectArray getAspects() {
        if (this._aspectsField != null) {
            return this._aspectsField;
        }
        Object __rawValue = this._map.get("aspects");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aspects");
        }
        this._aspectsField = __rawValue == null ? null : new MLFeatureTableAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._aspectsField;
    }

    public MLFeatureTableSnapshot setAspects(@Nullable MLFeatureTableAspectArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aspects of com.linkedin.metadata.snapshot.MLFeatureTableSnapshot");
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
            }
        }
        return this;
    }

    public MLFeatureTableSnapshot setAspects(@Nonnull MLFeatureTableAspectArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspects of com.linkedin.metadata.snapshot.MLFeatureTableSnapshot to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
        this._aspectsField = value;
        return this;
    }

    @Override
    public MLFeatureTableSnapshot clone() throws CloneNotSupportedException {
        MLFeatureTableSnapshot __clone = (MLFeatureTableSnapshot)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLFeatureTableSnapshot copy() throws CloneNotSupportedException {
        MLFeatureTableSnapshot __copy = (MLFeatureTableSnapshot)super.copy();
        __copy._urnField = null;
        __copy._aspectsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLFeatureTableSnapshot __objectRef;

        private ChangeListener(MLFeatureTableSnapshot reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "aspects": {
                    this.__objectRef._aspectsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public MLFeatureTableAspectArray.Fields aspects() {
            return new MLFeatureTableAspectArray.Fields(this.getPathComponents(), "aspects");
        }

        public PathSpec aspects(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "aspects");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MLFeatureTableAspectArray.ProjectionMask _aspectsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withAspects(Function<MLFeatureTableAspectArray.ProjectionMask, MLFeatureTableAspectArray.ProjectionMask> nestedMask) {
            this._aspectsMask = nestedMask.apply(this._aspectsMask == null ? MLFeatureTableAspectArray.createMask() : this._aspectsMask);
            this.getDataMap().put("aspects", this._aspectsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspects() {
            this._aspectsMask = null;
            this.getDataMap().put("aspects", 1);
            return this;
        }

        public ProjectionMask withAspects(Function<MLFeatureTableAspectArray.ProjectionMask, MLFeatureTableAspectArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._aspectsMask = nestedMask.apply(this._aspectsMask == null ? MLFeatureTableAspectArray.createMask() : this._aspectsMask);
            this.getDataMap().put("aspects", this._aspectsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("aspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aspects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAspects(Integer start, Integer count) {
            this._aspectsMask = null;
            this.getDataMap().put("aspects", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("aspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aspects").put("$count", count);
            }
            return this;
        }
    }
}

