/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query.filter;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.query.filter.ConjunctiveCriterionArray;
import com.linkedin.metadata.query.filter.CriterionArray;
import com.linkedin.metadata.query.filter.RelationshipDirection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RelationshipFilter
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query.filter/**The relationship filter to apply in a graph query*/record RelationshipFilter includes/**The filter for finding a record or a collection of records*/record Filter{/**A list of disjunctive criterion for the filter. (or operation to combine filters)*/or:optional array[/**A list of criterion and'd together.*/record ConjunctiveCriterion{/**A list of and criteria the filter applies to the query*/and:array[/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}]}]/**Deprecated! A list of conjunctive criterion for the filter. If \"or\" field is provided, then this field is ignored.*/criteria:optional array[Criterion]}{/**The relationship direction between two nodes in a graph query*/direction:/**The relationship direction in a relationship filter*/enum RelationshipDirection{/**The incoming edge to a source node in the graph*/INCOMING/**The outgoing edge to a source node in the graph*/OUTGOING/**This is used for a query where the direction of the edge does not matter*/UNDIRECTED}=\"UNDIRECTED\"}", SchemaFormatType.PDL);
    private ConjunctiveCriterionArray _orField = null;
    private CriterionArray _criteriaField = null;
    private RelationshipDirection _directionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Or = SCHEMA.getField("or");
    private static final RecordDataSchema.Field FIELD_Criteria = SCHEMA.getField("criteria");
    private static final RecordDataSchema.Field FIELD_Direction = SCHEMA.getField("direction");
    private static final RelationshipDirection DEFAULT_Direction = DataTemplateUtil.coerceEnumOutput(FIELD_Direction.getDefault(), RelationshipDirection.class, RelationshipDirection.$UNKNOWN);

    public RelationshipFilter() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public RelationshipFilter(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasOr() {
        if (this._orField != null) {
            return true;
        }
        return this._map.containsKey("or");
    }

    public void removeOr() {
        this._map.remove("or");
    }

    @Nullable
    public ConjunctiveCriterionArray getOr(GetMode mode) {
        return this.getOr();
    }

    @Nullable
    public ConjunctiveCriterionArray getOr() {
        if (this._orField != null) {
            return this._orField;
        }
        Object __rawValue = this._map.get("or");
        this._orField = __rawValue == null ? null : new ConjunctiveCriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._orField;
    }

    public RelationshipFilter setOr(@Nullable ConjunctiveCriterionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOr(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOr();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "or", value.data());
                this._orField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "or", value.data());
                this._orField = value;
            }
        }
        return this;
    }

    public RelationshipFilter setOr(@Nonnull ConjunctiveCriterionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field or of com.linkedin.metadata.query.filter.RelationshipFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "or", value.data());
        this._orField = value;
        return this;
    }

    public boolean hasCriteria() {
        if (this._criteriaField != null) {
            return true;
        }
        return this._map.containsKey("criteria");
    }

    public void removeCriteria() {
        this._map.remove("criteria");
    }

    @Nullable
    public CriterionArray getCriteria(GetMode mode) {
        return this.getCriteria();
    }

    @Nullable
    public CriterionArray getCriteria() {
        if (this._criteriaField != null) {
            return this._criteriaField;
        }
        Object __rawValue = this._map.get("criteria");
        this._criteriaField = __rawValue == null ? null : new CriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._criteriaField;
    }

    public RelationshipFilter setCriteria(@Nullable CriterionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCriteria(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCriteria();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "criteria", value.data());
                this._criteriaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "criteria", value.data());
                this._criteriaField = value;
            }
        }
        return this;
    }

    public RelationshipFilter setCriteria(@Nonnull CriterionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field criteria of com.linkedin.metadata.query.filter.RelationshipFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "criteria", value.data());
        this._criteriaField = value;
        return this;
    }

    public boolean hasDirection() {
        if (this._directionField != null) {
            return true;
        }
        return this._map.containsKey("direction");
    }

    public void removeDirection() {
        this._map.remove("direction");
    }

    @Nullable
    public RelationshipDirection getDirection(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getDirection();
            }
            case NULL: {
                if (this._directionField != null) {
                    return this._directionField;
                }
                Object __rawValue = this._map.get("direction");
                this._directionField = DataTemplateUtil.coerceEnumOutput(__rawValue, RelationshipDirection.class, RelationshipDirection.$UNKNOWN);
                return this._directionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public RelationshipDirection getDirection() {
        if (this._directionField != null) {
            return this._directionField;
        }
        Object __rawValue = this._map.get("direction");
        if (__rawValue == null) {
            return DEFAULT_Direction;
        }
        this._directionField = DataTemplateUtil.coerceEnumOutput(__rawValue, RelationshipDirection.class, RelationshipDirection.$UNKNOWN);
        return this._directionField;
    }

    public RelationshipFilter setDirection(@Nullable RelationshipDirection value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDirection(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field direction of com.linkedin.metadata.query.filter.RelationshipFilter");
                }
                CheckedUtil.putWithoutChecking(this._map, "direction", value.name());
                this._directionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDirection();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "direction", value.name());
                this._directionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "direction", value.name());
                this._directionField = value;
            }
        }
        return this;
    }

    public RelationshipFilter setDirection(@Nonnull RelationshipDirection value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field direction of com.linkedin.metadata.query.filter.RelationshipFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "direction", value.name());
        this._directionField = value;
        return this;
    }

    @Override
    public RelationshipFilter clone() throws CloneNotSupportedException {
        RelationshipFilter __clone = (RelationshipFilter)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public RelationshipFilter copy() throws CloneNotSupportedException {
        RelationshipFilter __copy = (RelationshipFilter)super.copy();
        __copy._orField = null;
        __copy._criteriaField = null;
        __copy._directionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final RelationshipFilter __objectRef;

        private ChangeListener(RelationshipFilter reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "or": {
                    this.__objectRef._orField = null;
                    break;
                }
                case "criteria": {
                    this.__objectRef._criteriaField = null;
                    break;
                }
                case "direction": {
                    this.__objectRef._directionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ConjunctiveCriterionArray.Fields or() {
            return new ConjunctiveCriterionArray.Fields(this.getPathComponents(), "or");
        }

        public PathSpec or(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "or");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public CriterionArray.Fields criteria() {
            return new CriterionArray.Fields(this.getPathComponents(), "criteria");
        }

        public PathSpec criteria(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "criteria");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec direction() {
            return new PathSpec(this.getPathComponents(), "direction");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ConjunctiveCriterionArray.ProjectionMask _orMask;
        private CriterionArray.ProjectionMask _criteriaMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withOr(Function<ConjunctiveCriterionArray.ProjectionMask, ConjunctiveCriterionArray.ProjectionMask> nestedMask) {
            this._orMask = nestedMask.apply(this._orMask == null ? ConjunctiveCriterionArray.createMask() : this._orMask);
            this.getDataMap().put("or", this._orMask.getDataMap());
            return this;
        }

        public ProjectionMask withOr() {
            this._orMask = null;
            this.getDataMap().put("or", 1);
            return this;
        }

        public ProjectionMask withOr(Function<ConjunctiveCriterionArray.ProjectionMask, ConjunctiveCriterionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._orMask = nestedMask.apply(this._orMask == null ? ConjunctiveCriterionArray.createMask() : this._orMask);
            this.getDataMap().put("or", this._orMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("or").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("or").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOr(Integer start, Integer count) {
            this._orMask = null;
            this.getDataMap().put("or", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("or").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("or").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCriteria(Function<CriterionArray.ProjectionMask, CriterionArray.ProjectionMask> nestedMask) {
            this._criteriaMask = nestedMask.apply(this._criteriaMask == null ? CriterionArray.createMask() : this._criteriaMask);
            this.getDataMap().put("criteria", this._criteriaMask.getDataMap());
            return this;
        }

        public ProjectionMask withCriteria() {
            this._criteriaMask = null;
            this.getDataMap().put("criteria", 1);
            return this;
        }

        public ProjectionMask withCriteria(Function<CriterionArray.ProjectionMask, CriterionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._criteriaMask = nestedMask.apply(this._criteriaMask == null ? CriterionArray.createMask() : this._criteriaMask);
            this.getDataMap().put("criteria", this._criteriaMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("criteria").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("criteria").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCriteria(Integer start, Integer count) {
            this._criteriaMask = null;
            this.getDataMap().put("criteria", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("criteria").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("criteria").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDirection() {
            this.getDataMap().put("direction", 1);
            return this;
        }
    }
}

