/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.metadata.query.GroupingSpec;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchFlags
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**Set of flags to control search behavior*/record SearchFlags{/**Whether to skip cache*/skipCache:boolean=false/**The maximum number of values in a facet aggregation*/maxAggValues:int=20/**Structured or unstructured fulltext query*/fulltext:optional boolean/**Whether to skip highlighting*/skipHighlighting:optional boolean=false/**Whether to skip aggregates/facets*/skipAggregates:optional boolean=false/**Whether to request for search suggestions on the _entityName virtualized field*/getSuggestions:optional boolean=false/**Instructions for grouping results before returning*/groupingSpec:optional/**A set of directives to control how results are grouped.\nThe underlying generic groupings are nested to allow for further evolution of the grouping spec.*/record GroupingSpec{/**A list of generic directives to group results by.\n*/groupingCriteria:array[record GroupingCriterion{/**The type of the entity to be grouped.\ne.g. schemaField\nOmitting this field will result in all base entities being grouped.*/baseEntityType:optional string/**The type of the entity to be grouped into.\ne.g. dataset, domain, etc.*/groupingEntityType:string}]=[]}/**include soft deleted entities in results*/includeSoftDeleted:optional boolean=false/**include restricted entities in results (default is to filter)*/includeRestricted:optional boolean=false/**Include mentioned fields inside elastic highlighting query*/customHighlightingFields:optional array[string]/**invoke query rewrite chain for filters based on configured rewriters*/rewriteQuery:optional boolean=true/**Include default facets when getting facets to aggregate on in search requests.\nBy default we include these, but custom aggregation requests don't need them.*/includeDefaultFacets:optional boolean=true/**Include only latest versions in version sets, default true*/filterNonLatestVersions:optional boolean=true}", SchemaFormatType.PDL);
    private Boolean _skipCacheField = null;
    private Integer _maxAggValuesField = null;
    private Boolean _fulltextField = null;
    private Boolean _skipHighlightingField = null;
    private Boolean _skipAggregatesField = null;
    private Boolean _getSuggestionsField = null;
    private GroupingSpec _groupingSpecField = null;
    private Boolean _includeSoftDeletedField = null;
    private Boolean _includeRestrictedField = null;
    private StringArray _customHighlightingFieldsField = null;
    private Boolean _rewriteQueryField = null;
    private Boolean _includeDefaultFacetsField = null;
    private Boolean _filterNonLatestVersionsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SkipCache = SCHEMA.getField("skipCache");
    private static final Boolean DEFAULT_SkipCache;
    private static final RecordDataSchema.Field FIELD_MaxAggValues;
    private static final Integer DEFAULT_MaxAggValues;
    private static final RecordDataSchema.Field FIELD_Fulltext;
    private static final RecordDataSchema.Field FIELD_SkipHighlighting;
    private static final Boolean DEFAULT_SkipHighlighting;
    private static final RecordDataSchema.Field FIELD_SkipAggregates;
    private static final Boolean DEFAULT_SkipAggregates;
    private static final RecordDataSchema.Field FIELD_GetSuggestions;
    private static final Boolean DEFAULT_GetSuggestions;
    private static final RecordDataSchema.Field FIELD_GroupingSpec;
    private static final RecordDataSchema.Field FIELD_IncludeSoftDeleted;
    private static final Boolean DEFAULT_IncludeSoftDeleted;
    private static final RecordDataSchema.Field FIELD_IncludeRestricted;
    private static final Boolean DEFAULT_IncludeRestricted;
    private static final RecordDataSchema.Field FIELD_CustomHighlightingFields;
    private static final RecordDataSchema.Field FIELD_RewriteQuery;
    private static final Boolean DEFAULT_RewriteQuery;
    private static final RecordDataSchema.Field FIELD_IncludeDefaultFacets;
    private static final Boolean DEFAULT_IncludeDefaultFacets;
    private static final RecordDataSchema.Field FIELD_FilterNonLatestVersions;
    private static final Boolean DEFAULT_FilterNonLatestVersions;

    public SearchFlags() {
        super(new DataMap(), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public SearchFlags(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSkipCache() {
        if (this._skipCacheField != null) {
            return true;
        }
        return this._map.containsKey("skipCache");
    }

    public void removeSkipCache() {
        this._map.remove("skipCache");
    }

    @Nullable
    public Boolean isSkipCache(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isSkipCache();
            }
            case NULL: {
                if (this._skipCacheField != null) {
                    return this._skipCacheField;
                }
                Object __rawValue = this._map.get("skipCache");
                this._skipCacheField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._skipCacheField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isSkipCache() {
        if (this._skipCacheField != null) {
            return this._skipCacheField;
        }
        Object __rawValue = this._map.get("skipCache");
        if (__rawValue == null) {
            return DEFAULT_SkipCache;
        }
        this._skipCacheField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._skipCacheField;
    }

    public SearchFlags setSkipCache(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSkipCache(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field skipCache of com.linkedin.metadata.query.SearchFlags");
                }
                CheckedUtil.putWithoutChecking(this._map, "skipCache", value);
                this._skipCacheField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSkipCache();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "skipCache", value);
                this._skipCacheField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "skipCache", value);
                this._skipCacheField = value;
            }
        }
        return this;
    }

    public SearchFlags setSkipCache(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field skipCache of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "skipCache", value);
        this._skipCacheField = value;
        return this;
    }

    public SearchFlags setSkipCache(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "skipCache", value);
        this._skipCacheField = value;
        return this;
    }

    public boolean hasMaxAggValues() {
        if (this._maxAggValuesField != null) {
            return true;
        }
        return this._map.containsKey("maxAggValues");
    }

    public void removeMaxAggValues() {
        this._map.remove("maxAggValues");
    }

    @Nullable
    public Integer getMaxAggValues(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getMaxAggValues();
            }
            case NULL: {
                if (this._maxAggValuesField != null) {
                    return this._maxAggValuesField;
                }
                Object __rawValue = this._map.get("maxAggValues");
                this._maxAggValuesField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._maxAggValuesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getMaxAggValues() {
        if (this._maxAggValuesField != null) {
            return this._maxAggValuesField;
        }
        Object __rawValue = this._map.get("maxAggValues");
        if (__rawValue == null) {
            return DEFAULT_MaxAggValues;
        }
        this._maxAggValuesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._maxAggValuesField;
    }

    public SearchFlags setMaxAggValues(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMaxAggValues(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field maxAggValues of com.linkedin.metadata.query.SearchFlags");
                }
                CheckedUtil.putWithoutChecking(this._map, "maxAggValues", DataTemplateUtil.coerceIntInput(value));
                this._maxAggValuesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMaxAggValues();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "maxAggValues", DataTemplateUtil.coerceIntInput(value));
                this._maxAggValuesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "maxAggValues", DataTemplateUtil.coerceIntInput(value));
                this._maxAggValuesField = value;
            }
        }
        return this;
    }

    public SearchFlags setMaxAggValues(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field maxAggValues of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "maxAggValues", DataTemplateUtil.coerceIntInput(value));
        this._maxAggValuesField = value;
        return this;
    }

    public SearchFlags setMaxAggValues(int value) {
        CheckedUtil.putWithoutChecking(this._map, "maxAggValues", DataTemplateUtil.coerceIntInput(value));
        this._maxAggValuesField = value;
        return this;
    }

    public boolean hasFulltext() {
        if (this._fulltextField != null) {
            return true;
        }
        return this._map.containsKey("fulltext");
    }

    public void removeFulltext() {
        this._map.remove("fulltext");
    }

    @Nullable
    public Boolean isFulltext(GetMode mode) {
        return this.isFulltext();
    }

    @Nullable
    public Boolean isFulltext() {
        if (this._fulltextField != null) {
            return this._fulltextField;
        }
        Object __rawValue = this._map.get("fulltext");
        this._fulltextField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._fulltextField;
    }

    public SearchFlags setFulltext(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFulltext(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFulltext();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fulltext", value);
                this._fulltextField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fulltext", value);
                this._fulltextField = value;
            }
        }
        return this;
    }

    public SearchFlags setFulltext(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fulltext of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fulltext", value);
        this._fulltextField = value;
        return this;
    }

    public SearchFlags setFulltext(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "fulltext", value);
        this._fulltextField = value;
        return this;
    }

    public boolean hasSkipHighlighting() {
        if (this._skipHighlightingField != null) {
            return true;
        }
        return this._map.containsKey("skipHighlighting");
    }

    public void removeSkipHighlighting() {
        this._map.remove("skipHighlighting");
    }

    @Nullable
    public Boolean isSkipHighlighting(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isSkipHighlighting();
            }
            case NULL: {
                if (this._skipHighlightingField != null) {
                    return this._skipHighlightingField;
                }
                Object __rawValue = this._map.get("skipHighlighting");
                this._skipHighlightingField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._skipHighlightingField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isSkipHighlighting() {
        if (this._skipHighlightingField != null) {
            return this._skipHighlightingField;
        }
        Object __rawValue = this._map.get("skipHighlighting");
        if (__rawValue == null) {
            return DEFAULT_SkipHighlighting;
        }
        this._skipHighlightingField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._skipHighlightingField;
    }

    public SearchFlags setSkipHighlighting(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSkipHighlighting(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSkipHighlighting();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "skipHighlighting", value);
                this._skipHighlightingField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "skipHighlighting", value);
                this._skipHighlightingField = value;
            }
        }
        return this;
    }

    public SearchFlags setSkipHighlighting(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field skipHighlighting of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "skipHighlighting", value);
        this._skipHighlightingField = value;
        return this;
    }

    public SearchFlags setSkipHighlighting(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "skipHighlighting", value);
        this._skipHighlightingField = value;
        return this;
    }

    public boolean hasSkipAggregates() {
        if (this._skipAggregatesField != null) {
            return true;
        }
        return this._map.containsKey("skipAggregates");
    }

    public void removeSkipAggregates() {
        this._map.remove("skipAggregates");
    }

    @Nullable
    public Boolean isSkipAggregates(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isSkipAggregates();
            }
            case NULL: {
                if (this._skipAggregatesField != null) {
                    return this._skipAggregatesField;
                }
                Object __rawValue = this._map.get("skipAggregates");
                this._skipAggregatesField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._skipAggregatesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isSkipAggregates() {
        if (this._skipAggregatesField != null) {
            return this._skipAggregatesField;
        }
        Object __rawValue = this._map.get("skipAggregates");
        if (__rawValue == null) {
            return DEFAULT_SkipAggregates;
        }
        this._skipAggregatesField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._skipAggregatesField;
    }

    public SearchFlags setSkipAggregates(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSkipAggregates(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSkipAggregates();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "skipAggregates", value);
                this._skipAggregatesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "skipAggregates", value);
                this._skipAggregatesField = value;
            }
        }
        return this;
    }

    public SearchFlags setSkipAggregates(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field skipAggregates of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "skipAggregates", value);
        this._skipAggregatesField = value;
        return this;
    }

    public SearchFlags setSkipAggregates(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "skipAggregates", value);
        this._skipAggregatesField = value;
        return this;
    }

    public boolean hasGetSuggestions() {
        if (this._getSuggestionsField != null) {
            return true;
        }
        return this._map.containsKey("getSuggestions");
    }

    public void removeGetSuggestions() {
        this._map.remove("getSuggestions");
    }

    @Nullable
    public Boolean isGetSuggestions(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isGetSuggestions();
            }
            case NULL: {
                if (this._getSuggestionsField != null) {
                    return this._getSuggestionsField;
                }
                Object __rawValue = this._map.get("getSuggestions");
                this._getSuggestionsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._getSuggestionsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isGetSuggestions() {
        if (this._getSuggestionsField != null) {
            return this._getSuggestionsField;
        }
        Object __rawValue = this._map.get("getSuggestions");
        if (__rawValue == null) {
            return DEFAULT_GetSuggestions;
        }
        this._getSuggestionsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._getSuggestionsField;
    }

    public SearchFlags setGetSuggestions(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGetSuggestions(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGetSuggestions();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "getSuggestions", value);
                this._getSuggestionsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "getSuggestions", value);
                this._getSuggestionsField = value;
            }
        }
        return this;
    }

    public SearchFlags setGetSuggestions(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field getSuggestions of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "getSuggestions", value);
        this._getSuggestionsField = value;
        return this;
    }

    public SearchFlags setGetSuggestions(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "getSuggestions", value);
        this._getSuggestionsField = value;
        return this;
    }

    public boolean hasGroupingSpec() {
        if (this._groupingSpecField != null) {
            return true;
        }
        return this._map.containsKey("groupingSpec");
    }

    public void removeGroupingSpec() {
        this._map.remove("groupingSpec");
    }

    @Nullable
    public GroupingSpec getGroupingSpec(GetMode mode) {
        return this.getGroupingSpec();
    }

    @Nullable
    public GroupingSpec getGroupingSpec() {
        if (this._groupingSpecField != null) {
            return this._groupingSpecField;
        }
        Object __rawValue = this._map.get("groupingSpec");
        this._groupingSpecField = __rawValue == null ? null : new GroupingSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._groupingSpecField;
    }

    public SearchFlags setGroupingSpec(@Nullable GroupingSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroupingSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroupingSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groupingSpec", value.data());
                this._groupingSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groupingSpec", value.data());
                this._groupingSpecField = value;
            }
        }
        return this;
    }

    public SearchFlags setGroupingSpec(@Nonnull GroupingSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groupingSpec of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groupingSpec", value.data());
        this._groupingSpecField = value;
        return this;
    }

    public boolean hasIncludeSoftDeleted() {
        if (this._includeSoftDeletedField != null) {
            return true;
        }
        return this._map.containsKey("includeSoftDeleted");
    }

    public void removeIncludeSoftDeleted() {
        this._map.remove("includeSoftDeleted");
    }

    @Nullable
    public Boolean isIncludeSoftDeleted(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isIncludeSoftDeleted();
            }
            case NULL: {
                if (this._includeSoftDeletedField != null) {
                    return this._includeSoftDeletedField;
                }
                Object __rawValue = this._map.get("includeSoftDeleted");
                this._includeSoftDeletedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._includeSoftDeletedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isIncludeSoftDeleted() {
        if (this._includeSoftDeletedField != null) {
            return this._includeSoftDeletedField;
        }
        Object __rawValue = this._map.get("includeSoftDeleted");
        if (__rawValue == null) {
            return DEFAULT_IncludeSoftDeleted;
        }
        this._includeSoftDeletedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._includeSoftDeletedField;
    }

    public SearchFlags setIncludeSoftDeleted(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncludeSoftDeleted(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncludeSoftDeleted();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "includeSoftDeleted", value);
                this._includeSoftDeletedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "includeSoftDeleted", value);
                this._includeSoftDeletedField = value;
            }
        }
        return this;
    }

    public SearchFlags setIncludeSoftDeleted(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field includeSoftDeleted of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "includeSoftDeleted", value);
        this._includeSoftDeletedField = value;
        return this;
    }

    public SearchFlags setIncludeSoftDeleted(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "includeSoftDeleted", value);
        this._includeSoftDeletedField = value;
        return this;
    }

    public boolean hasIncludeRestricted() {
        if (this._includeRestrictedField != null) {
            return true;
        }
        return this._map.containsKey("includeRestricted");
    }

    public void removeIncludeRestricted() {
        this._map.remove("includeRestricted");
    }

    @Nullable
    public Boolean isIncludeRestricted(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isIncludeRestricted();
            }
            case NULL: {
                if (this._includeRestrictedField != null) {
                    return this._includeRestrictedField;
                }
                Object __rawValue = this._map.get("includeRestricted");
                this._includeRestrictedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._includeRestrictedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isIncludeRestricted() {
        if (this._includeRestrictedField != null) {
            return this._includeRestrictedField;
        }
        Object __rawValue = this._map.get("includeRestricted");
        if (__rawValue == null) {
            return DEFAULT_IncludeRestricted;
        }
        this._includeRestrictedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._includeRestrictedField;
    }

    public SearchFlags setIncludeRestricted(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncludeRestricted(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncludeRestricted();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "includeRestricted", value);
                this._includeRestrictedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "includeRestricted", value);
                this._includeRestrictedField = value;
            }
        }
        return this;
    }

    public SearchFlags setIncludeRestricted(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field includeRestricted of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "includeRestricted", value);
        this._includeRestrictedField = value;
        return this;
    }

    public SearchFlags setIncludeRestricted(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "includeRestricted", value);
        this._includeRestrictedField = value;
        return this;
    }

    public boolean hasCustomHighlightingFields() {
        if (this._customHighlightingFieldsField != null) {
            return true;
        }
        return this._map.containsKey("customHighlightingFields");
    }

    public void removeCustomHighlightingFields() {
        this._map.remove("customHighlightingFields");
    }

    @Nullable
    public StringArray getCustomHighlightingFields(GetMode mode) {
        return this.getCustomHighlightingFields();
    }

    @Nullable
    public StringArray getCustomHighlightingFields() {
        if (this._customHighlightingFieldsField != null) {
            return this._customHighlightingFieldsField;
        }
        Object __rawValue = this._map.get("customHighlightingFields");
        this._customHighlightingFieldsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._customHighlightingFieldsField;
    }

    public SearchFlags setCustomHighlightingFields(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomHighlightingFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomHighlightingFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customHighlightingFields", value.data());
                this._customHighlightingFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customHighlightingFields", value.data());
                this._customHighlightingFieldsField = value;
            }
        }
        return this;
    }

    public SearchFlags setCustomHighlightingFields(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customHighlightingFields of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customHighlightingFields", value.data());
        this._customHighlightingFieldsField = value;
        return this;
    }

    public boolean hasRewriteQuery() {
        if (this._rewriteQueryField != null) {
            return true;
        }
        return this._map.containsKey("rewriteQuery");
    }

    public void removeRewriteQuery() {
        this._map.remove("rewriteQuery");
    }

    @Nullable
    public Boolean isRewriteQuery(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isRewriteQuery();
            }
            case NULL: {
                if (this._rewriteQueryField != null) {
                    return this._rewriteQueryField;
                }
                Object __rawValue = this._map.get("rewriteQuery");
                this._rewriteQueryField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._rewriteQueryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isRewriteQuery() {
        if (this._rewriteQueryField != null) {
            return this._rewriteQueryField;
        }
        Object __rawValue = this._map.get("rewriteQuery");
        if (__rawValue == null) {
            return DEFAULT_RewriteQuery;
        }
        this._rewriteQueryField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._rewriteQueryField;
    }

    public SearchFlags setRewriteQuery(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRewriteQuery(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRewriteQuery();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rewriteQuery", value);
                this._rewriteQueryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rewriteQuery", value);
                this._rewriteQueryField = value;
            }
        }
        return this;
    }

    public SearchFlags setRewriteQuery(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rewriteQuery of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rewriteQuery", value);
        this._rewriteQueryField = value;
        return this;
    }

    public SearchFlags setRewriteQuery(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "rewriteQuery", value);
        this._rewriteQueryField = value;
        return this;
    }

    public boolean hasIncludeDefaultFacets() {
        if (this._includeDefaultFacetsField != null) {
            return true;
        }
        return this._map.containsKey("includeDefaultFacets");
    }

    public void removeIncludeDefaultFacets() {
        this._map.remove("includeDefaultFacets");
    }

    @Nullable
    public Boolean isIncludeDefaultFacets(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isIncludeDefaultFacets();
            }
            case NULL: {
                if (this._includeDefaultFacetsField != null) {
                    return this._includeDefaultFacetsField;
                }
                Object __rawValue = this._map.get("includeDefaultFacets");
                this._includeDefaultFacetsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._includeDefaultFacetsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isIncludeDefaultFacets() {
        if (this._includeDefaultFacetsField != null) {
            return this._includeDefaultFacetsField;
        }
        Object __rawValue = this._map.get("includeDefaultFacets");
        if (__rawValue == null) {
            return DEFAULT_IncludeDefaultFacets;
        }
        this._includeDefaultFacetsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._includeDefaultFacetsField;
    }

    public SearchFlags setIncludeDefaultFacets(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncludeDefaultFacets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncludeDefaultFacets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "includeDefaultFacets", value);
                this._includeDefaultFacetsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "includeDefaultFacets", value);
                this._includeDefaultFacetsField = value;
            }
        }
        return this;
    }

    public SearchFlags setIncludeDefaultFacets(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field includeDefaultFacets of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "includeDefaultFacets", value);
        this._includeDefaultFacetsField = value;
        return this;
    }

    public SearchFlags setIncludeDefaultFacets(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "includeDefaultFacets", value);
        this._includeDefaultFacetsField = value;
        return this;
    }

    public boolean hasFilterNonLatestVersions() {
        if (this._filterNonLatestVersionsField != null) {
            return true;
        }
        return this._map.containsKey("filterNonLatestVersions");
    }

    public void removeFilterNonLatestVersions() {
        this._map.remove("filterNonLatestVersions");
    }

    @Nullable
    public Boolean isFilterNonLatestVersions(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isFilterNonLatestVersions();
            }
            case NULL: {
                if (this._filterNonLatestVersionsField != null) {
                    return this._filterNonLatestVersionsField;
                }
                Object __rawValue = this._map.get("filterNonLatestVersions");
                this._filterNonLatestVersionsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._filterNonLatestVersionsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Boolean isFilterNonLatestVersions() {
        if (this._filterNonLatestVersionsField != null) {
            return this._filterNonLatestVersionsField;
        }
        Object __rawValue = this._map.get("filterNonLatestVersions");
        if (__rawValue == null) {
            return DEFAULT_FilterNonLatestVersions;
        }
        this._filterNonLatestVersionsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._filterNonLatestVersionsField;
    }

    public SearchFlags setFilterNonLatestVersions(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilterNonLatestVersions(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilterNonLatestVersions();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filterNonLatestVersions", value);
                this._filterNonLatestVersionsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filterNonLatestVersions", value);
                this._filterNonLatestVersionsField = value;
            }
        }
        return this;
    }

    public SearchFlags setFilterNonLatestVersions(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filterNonLatestVersions of com.linkedin.metadata.query.SearchFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filterNonLatestVersions", value);
        this._filterNonLatestVersionsField = value;
        return this;
    }

    public SearchFlags setFilterNonLatestVersions(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "filterNonLatestVersions", value);
        this._filterNonLatestVersionsField = value;
        return this;
    }

    @Override
    public SearchFlags clone() throws CloneNotSupportedException {
        SearchFlags __clone = (SearchFlags)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SearchFlags copy() throws CloneNotSupportedException {
        SearchFlags __copy = (SearchFlags)super.copy();
        __copy._maxAggValuesField = null;
        __copy._skipAggregatesField = null;
        __copy._skipCacheField = null;
        __copy._customHighlightingFieldsField = null;
        __copy._includeDefaultFacetsField = null;
        __copy._includeRestrictedField = null;
        __copy._filterNonLatestVersionsField = null;
        __copy._skipHighlightingField = null;
        __copy._getSuggestionsField = null;
        __copy._groupingSpecField = null;
        __copy._fulltextField = null;
        __copy._includeSoftDeletedField = null;
        __copy._rewriteQueryField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MaxAggValues = SCHEMA.getField("maxAggValues");
        FIELD_Fulltext = SCHEMA.getField("fulltext");
        FIELD_SkipHighlighting = SCHEMA.getField("skipHighlighting");
        FIELD_SkipAggregates = SCHEMA.getField("skipAggregates");
        FIELD_GetSuggestions = SCHEMA.getField("getSuggestions");
        FIELD_GroupingSpec = SCHEMA.getField("groupingSpec");
        FIELD_IncludeSoftDeleted = SCHEMA.getField("includeSoftDeleted");
        FIELD_IncludeRestricted = SCHEMA.getField("includeRestricted");
        FIELD_CustomHighlightingFields = SCHEMA.getField("customHighlightingFields");
        FIELD_RewriteQuery = SCHEMA.getField("rewriteQuery");
        FIELD_IncludeDefaultFacets = SCHEMA.getField("includeDefaultFacets");
        FIELD_FilterNonLatestVersions = SCHEMA.getField("filterNonLatestVersions");
        DEFAULT_SkipCache = DataTemplateUtil.coerceBooleanOutput(FIELD_SkipCache.getDefault());
        DEFAULT_MaxAggValues = DataTemplateUtil.coerceIntOutput(FIELD_MaxAggValues.getDefault());
        DEFAULT_SkipHighlighting = DataTemplateUtil.coerceBooleanOutput(FIELD_SkipHighlighting.getDefault());
        DEFAULT_SkipAggregates = DataTemplateUtil.coerceBooleanOutput(FIELD_SkipAggregates.getDefault());
        DEFAULT_GetSuggestions = DataTemplateUtil.coerceBooleanOutput(FIELD_GetSuggestions.getDefault());
        DEFAULT_IncludeSoftDeleted = DataTemplateUtil.coerceBooleanOutput(FIELD_IncludeSoftDeleted.getDefault());
        DEFAULT_IncludeRestricted = DataTemplateUtil.coerceBooleanOutput(FIELD_IncludeRestricted.getDefault());
        DEFAULT_RewriteQuery = DataTemplateUtil.coerceBooleanOutput(FIELD_RewriteQuery.getDefault());
        DEFAULT_IncludeDefaultFacets = DataTemplateUtil.coerceBooleanOutput(FIELD_IncludeDefaultFacets.getDefault());
        DEFAULT_FilterNonLatestVersions = DataTemplateUtil.coerceBooleanOutput(FIELD_FilterNonLatestVersions.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SearchFlags __objectRef;

        private ChangeListener(SearchFlags reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "maxAggValues": {
                    this.__objectRef._maxAggValuesField = null;
                    break;
                }
                case "skipAggregates": {
                    this.__objectRef._skipAggregatesField = null;
                    break;
                }
                case "skipCache": {
                    this.__objectRef._skipCacheField = null;
                    break;
                }
                case "customHighlightingFields": {
                    this.__objectRef._customHighlightingFieldsField = null;
                    break;
                }
                case "includeDefaultFacets": {
                    this.__objectRef._includeDefaultFacetsField = null;
                    break;
                }
                case "includeRestricted": {
                    this.__objectRef._includeRestrictedField = null;
                    break;
                }
                case "filterNonLatestVersions": {
                    this.__objectRef._filterNonLatestVersionsField = null;
                    break;
                }
                case "skipHighlighting": {
                    this.__objectRef._skipHighlightingField = null;
                    break;
                }
                case "getSuggestions": {
                    this.__objectRef._getSuggestionsField = null;
                    break;
                }
                case "groupingSpec": {
                    this.__objectRef._groupingSpecField = null;
                    break;
                }
                case "fulltext": {
                    this.__objectRef._fulltextField = null;
                    break;
                }
                case "includeSoftDeleted": {
                    this.__objectRef._includeSoftDeletedField = null;
                    break;
                }
                case "rewriteQuery": {
                    this.__objectRef._rewriteQueryField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec skipCache() {
            return new PathSpec(this.getPathComponents(), "skipCache");
        }

        public PathSpec maxAggValues() {
            return new PathSpec(this.getPathComponents(), "maxAggValues");
        }

        public PathSpec fulltext() {
            return new PathSpec(this.getPathComponents(), "fulltext");
        }

        public PathSpec skipHighlighting() {
            return new PathSpec(this.getPathComponents(), "skipHighlighting");
        }

        public PathSpec skipAggregates() {
            return new PathSpec(this.getPathComponents(), "skipAggregates");
        }

        public PathSpec getSuggestions() {
            return new PathSpec(this.getPathComponents(), "getSuggestions");
        }

        public GroupingSpec.Fields groupingSpec() {
            return new GroupingSpec.Fields(this.getPathComponents(), "groupingSpec");
        }

        public PathSpec includeSoftDeleted() {
            return new PathSpec(this.getPathComponents(), "includeSoftDeleted");
        }

        public PathSpec includeRestricted() {
            return new PathSpec(this.getPathComponents(), "includeRestricted");
        }

        public PathSpec customHighlightingFields() {
            return new PathSpec(this.getPathComponents(), "customHighlightingFields");
        }

        public PathSpec customHighlightingFields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "customHighlightingFields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec rewriteQuery() {
            return new PathSpec(this.getPathComponents(), "rewriteQuery");
        }

        public PathSpec includeDefaultFacets() {
            return new PathSpec(this.getPathComponents(), "includeDefaultFacets");
        }

        public PathSpec filterNonLatestVersions() {
            return new PathSpec(this.getPathComponents(), "filterNonLatestVersions");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private GroupingSpec.ProjectionMask _groupingSpecMask;

        ProjectionMask() {
        }

        public ProjectionMask withSkipCache() {
            this.getDataMap().put("skipCache", 1);
            return this;
        }

        public ProjectionMask withMaxAggValues() {
            this.getDataMap().put("maxAggValues", 1);
            return this;
        }

        public ProjectionMask withFulltext() {
            this.getDataMap().put("fulltext", 1);
            return this;
        }

        public ProjectionMask withSkipHighlighting() {
            this.getDataMap().put("skipHighlighting", 1);
            return this;
        }

        public ProjectionMask withSkipAggregates() {
            this.getDataMap().put("skipAggregates", 1);
            return this;
        }

        public ProjectionMask withGetSuggestions() {
            this.getDataMap().put("getSuggestions", 1);
            return this;
        }

        public ProjectionMask withGroupingSpec(Function<GroupingSpec.ProjectionMask, GroupingSpec.ProjectionMask> nestedMask) {
            this._groupingSpecMask = nestedMask.apply(this._groupingSpecMask == null ? GroupingSpec.createMask() : this._groupingSpecMask);
            this.getDataMap().put("groupingSpec", this._groupingSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withGroupingSpec() {
            this._groupingSpecMask = null;
            this.getDataMap().put("groupingSpec", 1);
            return this;
        }

        public ProjectionMask withIncludeSoftDeleted() {
            this.getDataMap().put("includeSoftDeleted", 1);
            return this;
        }

        public ProjectionMask withIncludeRestricted() {
            this.getDataMap().put("includeRestricted", 1);
            return this;
        }

        public ProjectionMask withCustomHighlightingFields() {
            this.getDataMap().put("customHighlightingFields", 1);
            return this;
        }

        public ProjectionMask withCustomHighlightingFields(Integer start, Integer count) {
            this.getDataMap().put("customHighlightingFields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("customHighlightingFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("customHighlightingFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRewriteQuery() {
            this.getDataMap().put("rewriteQuery", 1);
            return this;
        }

        public ProjectionMask withIncludeDefaultFacets() {
            this.getDataMap().put("includeDefaultFacets", 1);
            return this;
        }

        public ProjectionMask withFilterNonLatestVersions() {
            this.getDataMap().put("filterNonLatestVersions", 1);
            return this;
        }
    }
}

