/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtraInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**Extra information associated to a metadata aspect.*/record ExtraInfo{/**The urn for the entity that owns the metadata aspect*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The version number of the metadata aspect.*/version:long/**The audit trail associated with the version*/audit:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private Urn _urnField = null;
    private Long _versionField = null;
    private AuditStamp _auditField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");
    private static final RecordDataSchema.Field FIELD_Audit = SCHEMA.getField("audit");

    public ExtraInfo() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public ExtraInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public Urn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._urnField;
    }

    public ExtraInfo setUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.metadata.query.ExtraInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public ExtraInfo setUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.metadata.query.ExtraInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public Long getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._versionField;
    }

    public ExtraInfo setVersion(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.metadata.query.ExtraInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
            }
        }
        return this;
    }

    public ExtraInfo setVersion(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.metadata.query.ExtraInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public ExtraInfo setVersion(long value) {
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public boolean hasAudit() {
        if (this._auditField != null) {
            return true;
        }
        return this._map.containsKey("audit");
    }

    public void removeAudit() {
        this._map.remove("audit");
    }

    @Nullable
    public AuditStamp getAudit(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAudit();
            }
            case DEFAULT: 
            case NULL: {
                if (this._auditField != null) {
                    return this._auditField;
                }
                Object __rawValue = this._map.get("audit");
                this._auditField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._auditField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getAudit() {
        if (this._auditField != null) {
            return this._auditField;
        }
        Object __rawValue = this._map.get("audit");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("audit");
        }
        this._auditField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditField;
    }

    public ExtraInfo setAudit(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAudit(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field audit of com.linkedin.metadata.query.ExtraInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "audit", value.data());
                this._auditField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAudit();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "audit", value.data());
                this._auditField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "audit", value.data());
                this._auditField = value;
            }
        }
        return this;
    }

    public ExtraInfo setAudit(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field audit of com.linkedin.metadata.query.ExtraInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "audit", value.data());
        this._auditField = value;
        return this;
    }

    @Override
    public ExtraInfo clone() throws CloneNotSupportedException {
        ExtraInfo __clone = (ExtraInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ExtraInfo copy() throws CloneNotSupportedException {
        ExtraInfo __copy = (ExtraInfo)super.copy();
        __copy._urnField = null;
        __copy._auditField = null;
        __copy._versionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ExtraInfo __objectRef;

        private ChangeListener(ExtraInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "audit": {
                    this.__objectRef._auditField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }

        public AuditStamp.Fields audit() {
            return new AuditStamp.Fields(this.getPathComponents(), "audit");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _auditMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withAudit(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._auditMask = nestedMask.apply(this._auditMask == null ? AuditStamp.createMask() : this._auditMask);
            this.getDataMap().put("audit", this._auditMask.getDataMap());
            return this;
        }

        public ProjectionMask withAudit(MaskMap nestedMask) {
            this.getDataMap().put("audit", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAudit() {
            this._auditMask = null;
            this.getDataMap().put("audit", 1);
            return this;
        }
    }
}

