/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.metadata.query.AutoCompleteEntityArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AutoCompleteResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**The model for the auto complete result*/record AutoCompleteResult{/**The original chars typed by user*/query:string/**A list of typeahead suggestions -- Just the text*/suggestions:array[string]/**Specific entities to recommend*/entities:array[/**Data model for an entity returned as an autocomplete suggestion*/record AutoCompleteEntity{/**Urn of the entity*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}]}", SchemaFormatType.PDL);
    private String _queryField = null;
    private StringArray _suggestionsField = null;
    private AutoCompleteEntityArray _entitiesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Query = SCHEMA.getField("query");
    private static final RecordDataSchema.Field FIELD_Suggestions = SCHEMA.getField("suggestions");
    private static final RecordDataSchema.Field FIELD_Entities = SCHEMA.getField("entities");

    public AutoCompleteResult() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public AutoCompleteResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasQuery() {
        if (this._queryField != null) {
            return true;
        }
        return this._map.containsKey("query");
    }

    public void removeQuery() {
        this._map.remove("query");
    }

    @Nullable
    public String getQuery(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getQuery();
            }
            case DEFAULT: 
            case NULL: {
                if (this._queryField != null) {
                    return this._queryField;
                }
                Object __rawValue = this._map.get("query");
                this._queryField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._queryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getQuery() {
        if (this._queryField != null) {
            return this._queryField;
        }
        Object __rawValue = this._map.get("query");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("query");
        }
        this._queryField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._queryField;
    }

    public AutoCompleteResult setQuery(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQuery(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field query of com.linkedin.metadata.query.AutoCompleteResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQuery();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
            }
        }
        return this;
    }

    public AutoCompleteResult setQuery(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field query of com.linkedin.metadata.query.AutoCompleteResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "query", value);
        this._queryField = value;
        return this;
    }

    public boolean hasSuggestions() {
        if (this._suggestionsField != null) {
            return true;
        }
        return this._map.containsKey("suggestions");
    }

    public void removeSuggestions() {
        this._map.remove("suggestions");
    }

    @Nullable
    public StringArray getSuggestions(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSuggestions();
            }
            case DEFAULT: 
            case NULL: {
                if (this._suggestionsField != null) {
                    return this._suggestionsField;
                }
                Object __rawValue = this._map.get("suggestions");
                this._suggestionsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._suggestionsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getSuggestions() {
        if (this._suggestionsField != null) {
            return this._suggestionsField;
        }
        Object __rawValue = this._map.get("suggestions");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("suggestions");
        }
        this._suggestionsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._suggestionsField;
    }

    public AutoCompleteResult setSuggestions(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSuggestions(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field suggestions of com.linkedin.metadata.query.AutoCompleteResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
                this._suggestionsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSuggestions();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
                this._suggestionsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
                this._suggestionsField = value;
            }
        }
        return this;
    }

    public AutoCompleteResult setSuggestions(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field suggestions of com.linkedin.metadata.query.AutoCompleteResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
        this._suggestionsField = value;
        return this;
    }

    public boolean hasEntities() {
        if (this._entitiesField != null) {
            return true;
        }
        return this._map.containsKey("entities");
    }

    public void removeEntities() {
        this._map.remove("entities");
    }

    @Nullable
    public AutoCompleteEntityArray getEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entitiesField != null) {
                    return this._entitiesField;
                }
                Object __rawValue = this._map.get("entities");
                this._entitiesField = __rawValue == null ? null : new AutoCompleteEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._entitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AutoCompleteEntityArray getEntities() {
        if (this._entitiesField != null) {
            return this._entitiesField;
        }
        Object __rawValue = this._map.get("entities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entities");
        }
        this._entitiesField = __rawValue == null ? null : new AutoCompleteEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._entitiesField;
    }

    public AutoCompleteResult setEntities(@Nullable AutoCompleteEntityArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entities of com.linkedin.metadata.query.AutoCompleteResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
            }
        }
        return this;
    }

    public AutoCompleteResult setEntities(@Nonnull AutoCompleteEntityArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entities of com.linkedin.metadata.query.AutoCompleteResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
        this._entitiesField = value;
        return this;
    }

    @Override
    public AutoCompleteResult clone() throws CloneNotSupportedException {
        AutoCompleteResult __clone = (AutoCompleteResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AutoCompleteResult copy() throws CloneNotSupportedException {
        AutoCompleteResult __copy = (AutoCompleteResult)super.copy();
        __copy._entitiesField = null;
        __copy._queryField = null;
        __copy._suggestionsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AutoCompleteResult __objectRef;

        private ChangeListener(AutoCompleteResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "entities": {
                    this.__objectRef._entitiesField = null;
                    break;
                }
                case "query": {
                    this.__objectRef._queryField = null;
                    break;
                }
                case "suggestions": {
                    this.__objectRef._suggestionsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec query() {
            return new PathSpec(this.getPathComponents(), "query");
        }

        public PathSpec suggestions() {
            return new PathSpec(this.getPathComponents(), "suggestions");
        }

        public PathSpec suggestions(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "suggestions");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public AutoCompleteEntityArray.Fields entities() {
            return new AutoCompleteEntityArray.Fields(this.getPathComponents(), "entities");
        }

        public PathSpec entities(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "entities");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AutoCompleteEntityArray.ProjectionMask _entitiesMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withQuery() {
            this.getDataMap().put("query", 1);
            return this;
        }

        public ProjectionMask withSuggestions() {
            this.getDataMap().put("suggestions", 1);
            return this;
        }

        public ProjectionMask withSuggestions(Integer start, Integer count) {
            this.getDataMap().put("suggestions", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("suggestions").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("suggestions").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEntities(Function<AutoCompleteEntityArray.ProjectionMask, AutoCompleteEntityArray.ProjectionMask> nestedMask) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? AutoCompleteEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withEntities() {
            this._entitiesMask = null;
            this.getDataMap().put("entities", 1);
            return this;
        }

        public ProjectionMask withEntities(Function<AutoCompleteEntityArray.ProjectionMask, AutoCompleteEntityArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? AutoCompleteEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEntities(Integer start, Integer count) {
            this._entitiesMask = null;
            this.getDataMap().put("entities", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }
    }
}

