/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.extractor;

import com.datahub.util.RecordUtils;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.FieldSpec;
import com.linkedin.metadata.models.extractor.AspectExtractor;
import com.linkedin.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class FieldExtractor {
    private static final String ARRAY_WILDCARD = "*";
    private static final int MAX_VALUE_LENGTH = 200;

    private FieldExtractor() {
    }

    private static long getNumArrayWildcards(PathSpec pathSpec) {
        return pathSpec.getPathComponents().stream().filter(ARRAY_WILDCARD::equals).count();
    }

    public static <T extends FieldSpec> Map<T, List<Object>> extractFields(@Nullable RecordTemplate record, List<T> fieldSpecs) {
        return FieldExtractor.extractFields(record, fieldSpecs, false);
    }

    public static <T extends FieldSpec> Map<T, List<Object>> extractFields(@Nullable RecordTemplate record, List<T> fieldSpecs, boolean requiredFieldExtract) {
        return FieldExtractor.extractFields(record, fieldSpecs, 200, requiredFieldExtract);
    }

    public static <T extends FieldSpec> Map<T, List<Object>> extractFields(@Nullable RecordTemplate record, List<T> fieldSpecs, int maxValueLength) {
        return FieldExtractor.extractFields(record, fieldSpecs, maxValueLength, false);
    }

    public static <T extends FieldSpec> Map<T, List<Object>> extractFields(@Nullable RecordTemplate record, List<T> fieldSpecs, int maxValueLength, boolean requiredFieldExtract) {
        HashMap<FieldSpec, List<Object>> extractedFields = new HashMap<FieldSpec, List<Object>>();
        for (FieldSpec fieldSpec : fieldSpecs) {
            if (requiredFieldExtract && record == null) {
                throw new IllegalArgumentException("Field extraction is required and the RecordTemplate is null");
            }
            Optional value = Optional.ofNullable(record).flatMap(maybeRecord -> RecordUtils.getFieldValue(maybeRecord, fieldSpec.getPath()));
            if (!value.isPresent()) {
                extractedFields.put(fieldSpec, Collections.emptyList());
                continue;
            }
            long numArrayWildcards = FieldExtractor.getNumArrayWildcards(fieldSpec.getPath());
            if (numArrayWildcards == 0L) {
                if (value.get() instanceof Map) {
                    extractedFields.put(fieldSpec, ((Map)value.get()).entrySet().stream().map(entry -> new Pair<String, String>(entry.getKey().toString(), entry.getValue().toString())).filter(entry -> ((String)entry.getValue()).length() < maxValueLength).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList()));
                    continue;
                }
                extractedFields.put(fieldSpec, Collections.singletonList(value.get()));
                continue;
            }
            List valueList = (List)value.get();
            for (long i = 0L; i < numArrayWildcards - 1L; ++i) {
                valueList = valueList.stream().flatMap(v -> ((List)v).stream()).collect(Collectors.toList());
            }
            extractedFields.put(fieldSpec, valueList);
        }
        return extractedFields;
    }

    public static <T extends FieldSpec> Map<T, List<Object>> extractFieldsFromSnapshot(RecordTemplate snapshot, EntitySpec entitySpec, Function<AspectSpec, List<T>> getFieldSpecsFunc, int maxValueLength) {
        Map<String, RecordTemplate> aspects = AspectExtractor.extractAspectRecords(snapshot);
        HashMap extractedFields = new HashMap();
        aspects.keySet().stream().map(aspectName -> FieldExtractor.extractFields((RecordTemplate)aspects.get(aspectName), (List)getFieldSpecsFunc.apply(entitySpec.getAspectSpec((String)aspectName)), maxValueLength)).forEach(extractedFields::putAll);
        return extractedFields;
    }
}

