/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity.ebean.batch;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.MCPItem;
import com.linkedin.metadata.entity.validation.ValidationApiUtils;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.GenericRecordUtils;
import com.linkedin.metadata.utils.SystemMetadataUtils;
import com.linkedin.mxe.MetadataChangeProposal;
import com.linkedin.mxe.SystemMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposedItem
implements MCPItem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProposedItem.class);
    @Nonnull
    private final Urn urn;
    @Nonnull
    private final MetadataChangeProposal metadataChangeProposal;
    @Nonnull
    private final AuditStamp auditStamp;
    @Nonnull
    private EntitySpec entitySpec;
    @Nullable
    private AspectSpec aspectSpec;

    @Override
    @Nonnull
    public String getAspectName() {
        if (this.metadataChangeProposal.getAspectName() != null) {
            return this.metadataChangeProposal.getAspectName();
        }
        return MCPItem.super.getAspectName();
    }

    @Override
    @Nullable
    public AspectSpec getAspectSpec() {
        if (this.aspectSpec != null) {
            return this.aspectSpec;
        }
        if (this.entitySpec.getAspectSpecMap().containsKey(this.getAspectName())) {
            return this.entitySpec.getAspectSpecMap().get(this.getAspectName());
        }
        return null;
    }

    @Override
    @Nullable
    public RecordTemplate getRecordTemplate() {
        if (this.getAspectSpec() != null) {
            return GenericRecordUtils.deserializeAspect(this.getMetadataChangeProposal().getAspect().getValue(), this.getMetadataChangeProposal().getAspect().getContentType(), this.getAspectSpec());
        }
        return null;
    }

    @Override
    @Nonnull
    public SystemMetadata getSystemMetadata() {
        if (this.metadataChangeProposal.getSystemMetadata() == null) {
            this.metadataChangeProposal.setSystemMetadata(SystemMetadataUtils.createDefaultSystemMetadata());
        }
        return this.metadataChangeProposal.getSystemMetadata();
    }

    @Override
    @Nonnull
    public ChangeType getChangeType() {
        return this.metadataChangeProposal.getChangeType();
    }

    @Override
    public boolean isDatabaseDuplicateOf(BatchItem other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProposedItem that = (ProposedItem)o;
        return this.metadataChangeProposal.equals(that.metadataChangeProposal) && this.auditStamp.equals(that.auditStamp);
    }

    public int hashCode() {
        int result = this.metadataChangeProposal.hashCode();
        result = 31 * result + this.auditStamp.hashCode();
        return result;
    }

    @Generated
    ProposedItem(@Nonnull Urn urn, @Nonnull MetadataChangeProposal metadataChangeProposal, @Nonnull AuditStamp auditStamp, @Nonnull EntitySpec entitySpec, @Nullable AspectSpec aspectSpec) {
        if (urn == null) {
            throw new NullPointerException("urn is marked non-null but is null");
        }
        if (metadataChangeProposal == null) {
            throw new NullPointerException("metadataChangeProposal is marked non-null but is null");
        }
        if (auditStamp == null) {
            throw new NullPointerException("auditStamp is marked non-null but is null");
        }
        if (entitySpec == null) {
            throw new NullPointerException("entitySpec is marked non-null but is null");
        }
        this.urn = urn;
        this.metadataChangeProposal = metadataChangeProposal;
        this.auditStamp = auditStamp;
        this.entitySpec = entitySpec;
        this.aspectSpec = aspectSpec;
    }

    @Generated
    public static ProposedItemBuilder builder() {
        return new ProposedItemBuilder();
    }

    @Generated
    public ProposedItemBuilder toBuilder() {
        return new ProposedItemBuilder().urn(this.urn).metadataChangeProposal(this.metadataChangeProposal).auditStamp(this.auditStamp).entitySpec(this.entitySpec).aspectSpec(this.aspectSpec);
    }

    @Override
    @Nonnull
    @Generated
    public Urn getUrn() {
        return this.urn;
    }

    @Override
    @Nonnull
    @Generated
    public MetadataChangeProposal getMetadataChangeProposal() {
        return this.metadataChangeProposal;
    }

    @Override
    @Nonnull
    @Generated
    public AuditStamp getAuditStamp() {
        return this.auditStamp;
    }

    @Override
    @Nonnull
    @Generated
    public EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    public static class ProposedItemBuilder {
        @Generated
        private Urn urn;
        @Generated
        private MetadataChangeProposal metadataChangeProposal;
        @Generated
        private AuditStamp auditStamp;
        @Generated
        private EntitySpec entitySpec;
        @Generated
        private AspectSpec aspectSpec;

        private ProposedItem build() {
            return null;
        }

        public ProposedItem build(@Nonnull MetadataChangeProposal metadataChangeProposal, AuditStamp auditStamp, @Nonnull EntityRegistry entityRegistry) {
            this.metadataChangeProposal = ValidationApiUtils.validateMCP(entityRegistry, metadataChangeProposal);
            this.auditStamp = auditStamp;
            this.metadataChangeProposal.setSystemMetadata(SystemMetadataUtils.generateSystemMetadataIfEmpty(this.metadataChangeProposal.getSystemMetadata()));
            this.urn = metadataChangeProposal.getEntityUrn();
            log.debug("entity type = {}", (Object)this.urn.getEntityType());
            this.entitySpec(entityRegistry.getEntitySpec(this.urn.getEntityType()));
            log.debug("entity spec = {}", (Object)this.entitySpec);
            this.aspectSpec(this.entitySpec.getAspectSpec(this.metadataChangeProposal.getAspectName()));
            log.debug("aspect spec = {}", (Object)this.aspectSpec);
            return new ProposedItem(this.urn, this.metadataChangeProposal, this.auditStamp, this.entitySpec, this.aspectSpec);
        }

        @Generated
        ProposedItemBuilder() {
        }

        @Generated
        public ProposedItemBuilder urn(@Nonnull Urn urn) {
            if (urn == null) {
                throw new NullPointerException("urn is marked non-null but is null");
            }
            this.urn = urn;
            return this;
        }

        @Generated
        public ProposedItemBuilder metadataChangeProposal(@Nonnull MetadataChangeProposal metadataChangeProposal) {
            if (metadataChangeProposal == null) {
                throw new NullPointerException("metadataChangeProposal is marked non-null but is null");
            }
            this.metadataChangeProposal = metadataChangeProposal;
            return this;
        }

        @Generated
        public ProposedItemBuilder auditStamp(@Nonnull AuditStamp auditStamp) {
            if (auditStamp == null) {
                throw new NullPointerException("auditStamp is marked non-null but is null");
            }
            this.auditStamp = auditStamp;
            return this;
        }

        @Generated
        public ProposedItemBuilder entitySpec(@Nonnull EntitySpec entitySpec) {
            if (entitySpec == null) {
                throw new NullPointerException("entitySpec is marked non-null but is null");
            }
            this.entitySpec = entitySpec;
            return this;
        }

        @Generated
        public ProposedItemBuilder aspectSpec(@Nullable AspectSpec aspectSpec) {
            this.aspectSpec = aspectSpec;
            return this;
        }

        @Generated
        public String toString() {
            return "ProposedItem.ProposedItemBuilder(urn=" + String.valueOf(this.urn) + ", metadataChangeProposal=" + String.valueOf(this.metadataChangeProposal) + ", auditStamp=" + String.valueOf(this.auditStamp) + ", entitySpec=" + String.valueOf(this.entitySpec) + ", aspectSpec=" + String.valueOf(this.aspectSpec) + ")";
        }
    }
}

