/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.GlossaryTermAssociationArray;
import com.linkedin.common.GlossaryTerms;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.ArrayMergingTemplate;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.Collections;
import javax.annotation.Nonnull;

public class GlossaryTermsTemplate
implements ArrayMergingTemplate<GlossaryTerms> {
    private static final String TERMS_FIELD_NAME = "terms";
    private static final String URN_FIELD_NAME = "urn";
    private static final String AUDIT_STAMP_FIELD = "auditStamp";
    private static final String TIME_FIELD = "time";
    private static final String ACTOR_FIELD = "actor";

    @Override
    public GlossaryTerms getSubtype(RecordTemplate recordTemplate) throws ClassCastException {
        if (recordTemplate instanceof GlossaryTerms) {
            return (GlossaryTerms)recordTemplate;
        }
        throw new ClassCastException("Unable to cast RecordTemplate to GlossaryTerms");
    }

    @Override
    public Class<GlossaryTerms> getTemplateType() {
        return GlossaryTerms.class;
    }

    @Override
    @Nonnull
    public GlossaryTerms getDefault() {
        GlossaryTerms glossaryTerms = new GlossaryTerms();
        glossaryTerms.setTerms(new GlossaryTermAssociationArray()).setAuditStamp(new AuditStamp().setActor(UrnUtils.getUrn("urn:li:corpuser:__datahub_system")).setTime(System.currentTimeMillis()));
        return glossaryTerms;
    }

    @Override
    @Nonnull
    public JsonNode transformFields(JsonNode baseNode) {
        if (baseNode.get(AUDIT_STAMP_FIELD) == null) {
            ObjectNode auditStampNode = JsonNodeFactory.instance.objectNode();
            auditStampNode.put(ACTOR_FIELD, "urn:li:corpuser:__datahub_system").put(TIME_FIELD, System.currentTimeMillis());
            ((ObjectNode)baseNode).set(AUDIT_STAMP_FIELD, auditStampNode);
        }
        return this.arrayFieldToMap(baseNode, TERMS_FIELD_NAME, Collections.singletonList(URN_FIELD_NAME));
    }

    @Override
    @Nonnull
    public JsonNode rebaseFields(JsonNode patched) {
        if (patched.get(AUDIT_STAMP_FIELD) == null) {
            ObjectNode auditStampNode = JsonNodeFactory.instance.objectNode();
            auditStampNode.put(ACTOR_FIELD, "urn:li:corpuser:__datahub_system").put(TIME_FIELD, System.currentTimeMillis());
            ((ObjectNode)patched).set(AUDIT_STAMP_FIELD, auditStampNode);
        }
        return this.transformedMapToArray(patched, TERMS_FIELD_NAME, Collections.singletonList(URN_FIELD_NAME));
    }
}

