/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.OwnershipType;
import com.linkedin.common.urn.Urn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class OwnershipPatchBuilder
extends AbstractMultiFieldPatchBuilder<OwnershipPatchBuilder> {
    private static final String BASE_PATH = "/owners/";
    private static final String OWNER_KEY = "owner";
    private static final String TYPE_KEY = "type";

    public OwnershipPatchBuilder addOwner(@Nonnull Urn owner, @Nonnull OwnershipType type) {
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        value.put(OWNER_KEY, owner.toString());
        value.put(TYPE_KEY, type.toString());
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), BASE_PATH + OwnershipPatchBuilder.encodeValueUrn(owner) + "/" + OwnershipPatchBuilder.encodeValue(type.toString()), value));
        return this;
    }

    public OwnershipPatchBuilder removeOwner(@Nonnull Urn owner) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), BASE_PATH + OwnershipPatchBuilder.encodeValueUrn(owner), null));
        return this;
    }

    public OwnershipPatchBuilder removeOwnershipType(@Nonnull Urn owner, @Nonnull OwnershipType type) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), BASE_PATH + OwnershipPatchBuilder.encodeValueUrn(owner) + "/" + OwnershipPatchBuilder.encodeValue(type.toString()), null));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "ownership";
    }

    @Override
    protected String getEntityType() {
        if (this.targetEntityUrn == null) {
            throw new IllegalStateException("Target Entity Urn must be set to determine entity type before building Patch.");
        }
        return this.targetEntityUrn.getEntityType();
    }
}

