/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.hooks;

import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.ReadItem;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.hooks.MutationHook;
import com.linkedin.schema.EditableSchemaFieldInfo;
import com.linkedin.schema.EditableSchemaFieldInfoArray;
import com.linkedin.schema.EditableSchemaMetadata;
import com.linkedin.schema.SchemaField;
import com.linkedin.schema.SchemaFieldArray;
import com.linkedin.schema.SchemaMetadata;
import com.linkedin.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldPathMutator
extends MutationHook {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldPathMutator.class);
    @Nonnull
    private AspectPluginConfig config;

    @Override
    protected Stream<Pair<ChangeMCP, Boolean>> writeMutation(@Nonnull Collection<ChangeMCP> changeMCPS, @Nonnull RetrieverContext retrieverContext) {
        LinkedList<Pair<ChangeMCP, Boolean>> results = new LinkedList<Pair<ChangeMCP, Boolean>>();
        for (ChangeMCP item : changeMCPS) {
            if (FieldPathMutator.changeTypeFilter(item) && FieldPathMutator.aspectFilter(item)) {
                if (item.getAspectName().equals("schemaMetadata")) {
                    results.add(Pair.of(item, FieldPathMutator.processSchemaMetadataAspect(item)));
                    continue;
                }
                results.add(Pair.of(item, FieldPathMutator.processEditableSchemaMetadataAspect(item)));
                continue;
            }
            results.add(Pair.of(item, false));
        }
        return results.stream();
    }

    @Override
    protected Stream<Pair<ReadItem, Boolean>> readMutation(@Nonnull Collection<ReadItem> items, @Nonnull RetrieverContext retrieverContext) {
        LinkedList<Pair<ReadItem, Boolean>> results = new LinkedList<Pair<ReadItem, Boolean>>();
        for (ReadItem item : items) {
            if (FieldPathMutator.aspectFilter(item)) {
                if (item.getAspectName().equals("schemaMetadata")) {
                    results.add(Pair.of(item, FieldPathMutator.processSchemaMetadataAspect(item)));
                    continue;
                }
                results.add(Pair.of(item, FieldPathMutator.processEditableSchemaMetadataAspect(item)));
                continue;
            }
            results.add(Pair.of(item, false));
        }
        return results.stream();
    }

    private static boolean changeTypeFilter(BatchItem item) {
        return !ChangeType.DELETE.equals((Object)item.getChangeType()) && !ChangeType.PATCH.equals((Object)item.getChangeType());
    }

    private static boolean aspectFilter(ReadItem item) {
        return item.getAspectName().equals("schemaMetadata") || item.getAspectName().equals("editableSchemaMetadata");
    }

    private static boolean processEditableSchemaMetadataAspect(ReadItem item) {
        boolean mutated = false;
        EditableSchemaMetadata schemaMetadata = item.getAspect(EditableSchemaMetadata.class);
        EditableSchemaFieldInfoArray fields = schemaMetadata.getEditableSchemaFieldInfo();
        List<EditableSchemaFieldInfo> replaceFields = FieldPathMutator.deduplicateFieldPaths(fields, EditableSchemaFieldInfo::getFieldPath);
        if (!replaceFields.isEmpty()) {
            schemaMetadata.setEditableSchemaFieldInfo(new EditableSchemaFieldInfoArray(replaceFields));
            mutated = true;
        }
        return mutated;
    }

    private static boolean processSchemaMetadataAspect(ReadItem item) {
        boolean mutated = false;
        SchemaMetadata schemaMetadata = item.getAspect(SchemaMetadata.class);
        SchemaFieldArray fields = schemaMetadata.getFields();
        List<SchemaField> replaceFields = FieldPathMutator.deduplicateFieldPaths(fields, SchemaField::getFieldPath);
        if (!replaceFields.isEmpty()) {
            schemaMetadata.setFields(new SchemaFieldArray(replaceFields));
            mutated = true;
        }
        return mutated;
    }

    private static <T> List<T> deduplicateFieldPaths(Collection<T> fields, Function<T, String> fieldPathExtractor) {
        LinkedHashMap grouped = fields.stream().collect(Collectors.groupingBy(fieldPathExtractor, LinkedHashMap::new, Collectors.toList()));
        if (grouped.values().stream().anyMatch(v -> v.size() > 1)) {
            log.warn("Duplicate field path(s) detected. Dropping duplicates: {}", (Object)grouped.values().stream().filter(v -> v.size() > 1).collect(Collectors.toList()));
            return grouped.values().stream().map(l -> l.get(0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    @Generated
    public FieldPathMutator setConfig(@Nonnull AspectPluginConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        return this;
    }

    @Override
    @Nonnull
    @Generated
    public AspectPluginConfig getConfig() {
        return this.config;
    }
}

