/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.mxe.GenericAspect;
import com.linkedin.mxe.SystemMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnvelopedAspect
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**Enveloped record for an aspect.\n*/record EnvelopedAspect{aspect:{namespace com.linkedin.mxe/**Generic record structure for serializing an Aspect\n*/record GenericAspect{/**The value of the aspect, serialized as bytes.*/value:bytes/**The content type, which represents the fashion in which the aspect was serialized.\nThe only type currently supported is application/json.*/contentType:string}}systemMetadata:{namespace com.linkedin.mxe/**Metadata associated with each metadata change that is processed by the system*/@Aspect.name=\"systemMetadata\"record SystemMetadata{/**The timestamp the metadata was observed at*/lastObserved:optional long=0/**The original run id that produced the metadata. Populated in case of batch-ingestion.*/runId:optional string=\"no-run-id-provided\"/**The last run id that produced the metadata. Populated in case of batch-ingestion.*/lastRunId:optional string=\"no-run-id-provided\"/**The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion.*/pipelineName:optional string/**The model registry name that was used to process this event*/registryName:optional string/**The model registry version that was used to process this event*/registryVersion:optional string/**Additional properties*/properties:optional map[string,string]/**Aspect version\n   Initial implementation will use the aspect version's number, however stored as\n   a string in the case where a different aspect versioning scheme is later adopted.*/version:optional string}}}", SchemaFormatType.PDL);
    private GenericAspect _aspectField = null;
    private SystemMetadata _systemMetadataField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Aspect = SCHEMA.getField("aspect");
    private static final RecordDataSchema.Field FIELD_SystemMetadata = SCHEMA.getField("systemMetadata");

    public EnvelopedAspect() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public EnvelopedAspect(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAspect() {
        if (this._aspectField != null) {
            return true;
        }
        return this._map.containsKey("aspect");
    }

    public void removeAspect() {
        this._map.remove("aspect");
    }

    @Nullable
    public GenericAspect getAspect(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAspect();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aspectField != null) {
                    return this._aspectField;
                }
                Object __rawValue = this._map.get("aspect");
                this._aspectField = __rawValue == null ? null : new GenericAspect(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._aspectField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public GenericAspect getAspect() {
        if (this._aspectField != null) {
            return this._aspectField;
        }
        Object __rawValue = this._map.get("aspect");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aspect");
        }
        this._aspectField = __rawValue == null ? null : new GenericAspect(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aspectField;
    }

    public EnvelopedAspect setAspect(@Nullable GenericAspect value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspect(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aspect of com.linkedin.metadata.aspect.EnvelopedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "aspect", value.data());
                this._aspectField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspect();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspect", value.data());
                this._aspectField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspect", value.data());
                this._aspectField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setAspect(@Nonnull GenericAspect value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspect of com.linkedin.metadata.aspect.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspect", value.data());
        this._aspectField = value;
        return this;
    }

    public boolean hasSystemMetadata() {
        if (this._systemMetadataField != null) {
            return true;
        }
        return this._map.containsKey("systemMetadata");
    }

    public void removeSystemMetadata() {
        this._map.remove("systemMetadata");
    }

    @Nullable
    public SystemMetadata getSystemMetadata(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSystemMetadata();
            }
            case DEFAULT: 
            case NULL: {
                if (this._systemMetadataField != null) {
                    return this._systemMetadataField;
                }
                Object __rawValue = this._map.get("systemMetadata");
                this._systemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._systemMetadataField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SystemMetadata getSystemMetadata() {
        if (this._systemMetadataField != null) {
            return this._systemMetadataField;
        }
        Object __rawValue = this._map.get("systemMetadata");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("systemMetadata");
        }
        this._systemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._systemMetadataField;
    }

    public EnvelopedAspect setSystemMetadata(@Nullable SystemMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSystemMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field systemMetadata of com.linkedin.metadata.aspect.EnvelopedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSystemMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setSystemMetadata(@Nonnull SystemMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field systemMetadata of com.linkedin.metadata.aspect.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
        this._systemMetadataField = value;
        return this;
    }

    @Override
    public EnvelopedAspect clone() throws CloneNotSupportedException {
        EnvelopedAspect __clone = (EnvelopedAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EnvelopedAspect copy() throws CloneNotSupportedException {
        EnvelopedAspect __copy = (EnvelopedAspect)super.copy();
        __copy._aspectField = null;
        __copy._systemMetadataField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EnvelopedAspect __objectRef;

        private ChangeListener(EnvelopedAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "aspect": {
                    this.__objectRef._aspectField = null;
                    break;
                }
                case "systemMetadata": {
                    this.__objectRef._systemMetadataField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public GenericAspect.Fields aspect() {
            return new GenericAspect.Fields(this.getPathComponents(), "aspect");
        }

        public SystemMetadata.Fields systemMetadata() {
            return new SystemMetadata.Fields(this.getPathComponents(), "systemMetadata");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private GenericAspect.ProjectionMask _aspectMask;
        private SystemMetadata.ProjectionMask _systemMetadataMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withAspect(Function<GenericAspect.ProjectionMask, GenericAspect.ProjectionMask> nestedMask) {
            this._aspectMask = nestedMask.apply(this._aspectMask == null ? GenericAspect.createMask() : this._aspectMask);
            this.getDataMap().put("aspect", this._aspectMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspect() {
            this._aspectMask = null;
            this.getDataMap().put("aspect", 1);
            return this;
        }

        public ProjectionMask withSystemMetadata(Function<SystemMetadata.ProjectionMask, SystemMetadata.ProjectionMask> nestedMask) {
            this._systemMetadataMask = nestedMask.apply(this._systemMetadataMask == null ? SystemMetadata.createMask() : this._systemMetadataMask);
            this.getDataMap().put("systemMetadata", this._systemMetadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withSystemMetadata() {
            this._systemMetadataMask = null;
            this.getDataMap().put("systemMetadata", 1);
            return this;
        }
    }
}

