/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.common.Ownership;
import com.linkedin.common.Status;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.dataprocess.DataProcessInfo;
import com.linkedin.metadata.key.DataProcessKey;
import java.util.List;
import java.util.function.Function;

public class DataProcessAspect
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.metadata.key/**Key for a Data Process*/@Aspect.name=\"dataProcessKey\"record DataProcessKey{/**Process name i.e. an ETL job name*/@Searchable={\"boostScore\":4.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}name:string/**Standardized Orchestrator where data process is defined.\nTODO: Migrate towards something that can be validated like DataPlatform urn*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"TEXT_PARTIAL\"}orchestrator:string/**Fabric type where dataset belongs to or where it was generated.*/@Searchable={\"fieldType\":\"TEXT_PARTIAL\",\"queryByDefault\":false}origin:{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.dataprocess/**The inputs and outputs of this data process*/@Aspect.name=\"dataProcessInfo\"record DataProcessInfo{/**the inputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}inputs:optional array[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]/**the outputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"outputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}outputs:optional array[com.linkedin.common.DatasetUrn]}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}]", SchemaFormatType.PDL);
    private DataProcessKey _dataProcessKeyMember = null;
    private Ownership _ownershipMember = null;
    private DataProcessInfo _dataProcessInfoMember = null;
    private Status _statusMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_DataProcessKey = SCHEMA.getTypeByMemberKey("com.linkedin.metadata.key.DataProcessKey");
    public static final String MEMBERKEY_DataProcessKey = "com.linkedin.metadata.key.DataProcessKey";
    private static final DataSchema MEMBER_Ownership = SCHEMA.getTypeByMemberKey("com.linkedin.common.Ownership");
    public static final String MEMBERKEY_Ownership = "com.linkedin.common.Ownership";
    private static final DataSchema MEMBER_DataProcessInfo = SCHEMA.getTypeByMemberKey("com.linkedin.dataprocess.DataProcessInfo");
    public static final String MEMBERKEY_DataProcessInfo = "com.linkedin.dataprocess.DataProcessInfo";
    private static final DataSchema MEMBER_Status = SCHEMA.getTypeByMemberKey("com.linkedin.common.Status");
    public static final String MEMBERKEY_Status = "com.linkedin.common.Status";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public DataProcessAspect() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataProcessAspect(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static DataProcessAspect create(DataProcessKey value) {
        DataProcessAspect newUnion = new DataProcessAspect();
        newUnion.setDataProcessKey(value);
        return newUnion;
    }

    public boolean isDataProcessKey() {
        return this.memberIs(MEMBERKEY_DataProcessKey);
    }

    public DataProcessKey getDataProcessKey() {
        this.checkNotNull();
        if (this._dataProcessKeyMember != null) {
            return this._dataProcessKeyMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataProcessKey);
        this._dataProcessKeyMember = __rawValue == null ? null : new DataProcessKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataProcessKeyMember;
    }

    public void setDataProcessKey(DataProcessKey value) {
        this.checkNotNull();
        this._map.clear();
        this._dataProcessKeyMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataProcessKey, value.data());
    }

    public static DataProcessAspect create(Ownership value) {
        DataProcessAspect newUnion = new DataProcessAspect();
        newUnion.setOwnership(value);
        return newUnion;
    }

    public boolean isOwnership() {
        return this.memberIs(MEMBERKEY_Ownership);
    }

    public Ownership getOwnership() {
        this.checkNotNull();
        if (this._ownershipMember != null) {
            return this._ownershipMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Ownership);
        this._ownershipMember = __rawValue == null ? null : new Ownership(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._ownershipMember;
    }

    public void setOwnership(Ownership value) {
        this.checkNotNull();
        this._map.clear();
        this._ownershipMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Ownership, value.data());
    }

    public static DataProcessAspect create(DataProcessInfo value) {
        DataProcessAspect newUnion = new DataProcessAspect();
        newUnion.setDataProcessInfo(value);
        return newUnion;
    }

    public boolean isDataProcessInfo() {
        return this.memberIs(MEMBERKEY_DataProcessInfo);
    }

    public DataProcessInfo getDataProcessInfo() {
        this.checkNotNull();
        if (this._dataProcessInfoMember != null) {
            return this._dataProcessInfoMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataProcessInfo);
        this._dataProcessInfoMember = __rawValue == null ? null : new DataProcessInfo(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataProcessInfoMember;
    }

    public void setDataProcessInfo(DataProcessInfo value) {
        this.checkNotNull();
        this._map.clear();
        this._dataProcessInfoMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataProcessInfo, value.data());
    }

    public static DataProcessAspect create(Status value) {
        DataProcessAspect newUnion = new DataProcessAspect();
        newUnion.setStatus(value);
        return newUnion;
    }

    public boolean isStatus() {
        return this.memberIs(MEMBERKEY_Status);
    }

    public Status getStatus() {
        this.checkNotNull();
        if (this._statusMember != null) {
            return this._statusMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Status);
        this._statusMember = __rawValue == null ? null : new Status(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._statusMember;
    }

    public void setStatus(Status value) {
        this.checkNotNull();
        this._map.clear();
        this._statusMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Status, value.data());
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DataProcessAspect clone() throws CloneNotSupportedException {
        DataProcessAspect __clone = (DataProcessAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataProcessAspect copy() throws CloneNotSupportedException {
        DataProcessAspect __copy = (DataProcessAspect)super.copy();
        __copy._ownershipMember = null;
        __copy._dataProcessKeyMember = null;
        __copy._dataProcessInfoMember = null;
        __copy._statusMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataProcessAspect __objectRef;

        private ChangeListener(DataProcessAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "com.linkedin.common.Ownership": {
                    this.__objectRef._ownershipMember = null;
                    break;
                }
                case "com.linkedin.metadata.key.DataProcessKey": {
                    this.__objectRef._dataProcessKeyMember = null;
                    break;
                }
                case "com.linkedin.dataprocess.DataProcessInfo": {
                    this.__objectRef._dataProcessInfoMember = null;
                    break;
                }
                case "com.linkedin.common.Status": {
                    this.__objectRef._statusMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataProcessKey.ProjectionMask _DataProcessKeyMask;
        private Ownership.ProjectionMask _OwnershipMask;
        private DataProcessInfo.ProjectionMask _DataProcessInfoMask;
        private Status.ProjectionMask _StatusMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withDataProcessKey(Function<DataProcessKey.ProjectionMask, DataProcessKey.ProjectionMask> nestedMask) {
            this._DataProcessKeyMask = nestedMask.apply(this._DataProcessKeyMask == null ? DataProcessKey.createMask() : this._DataProcessKeyMask);
            this.getDataMap().put(DataProcessAspect.MEMBERKEY_DataProcessKey, this._DataProcessKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withOwnership(Function<Ownership.ProjectionMask, Ownership.ProjectionMask> nestedMask) {
            this._OwnershipMask = nestedMask.apply(this._OwnershipMask == null ? Ownership.createMask() : this._OwnershipMask);
            this.getDataMap().put(DataProcessAspect.MEMBERKEY_Ownership, this._OwnershipMask.getDataMap());
            return this;
        }

        public ProjectionMask withDataProcessInfo(Function<DataProcessInfo.ProjectionMask, DataProcessInfo.ProjectionMask> nestedMask) {
            this._DataProcessInfoMask = nestedMask.apply(this._DataProcessInfoMask == null ? DataProcessInfo.createMask() : this._DataProcessInfoMask);
            this.getDataMap().put(DataProcessAspect.MEMBERKEY_DataProcessInfo, this._DataProcessInfoMask.getDataMap());
            return this;
        }

        public ProjectionMask withStatus(Function<Status.ProjectionMask, Status.ProjectionMask> nestedMask) {
            this._StatusMask = nestedMask.apply(this._StatusMask == null ? Status.createMask() : this._StatusMask);
            this.getDataMap().put(DataProcessAspect.MEMBERKEY_Status, this._StatusMask.getDataMap());
            return this;
        }
    }

    @Deprecated
    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a data process*/@deprecated=\"Use DataJob instead.\"typeref DataProcessAspect=union[{namespace com.linkedin.metadata.key/**Key for a Data Process*/@Aspect.name=\"dataProcessKey\"record DataProcessKey{/**Process name i.e. an ETL job name*/@Searchable={\"boostScore\":4.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}name:string/**Standardized Orchestrator where data process is defined.\nTODO: Migrate towards something that can be validated like DataPlatform urn*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"TEXT_PARTIAL\"}orchestrator:string/**Fabric type where dataset belongs to or where it was generated.*/@Searchable={\"fieldType\":\"TEXT_PARTIAL\",\"queryByDefault\":false}origin:{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.dataprocess/**The inputs and outputs of this data process*/@Aspect.name=\"dataProcessInfo\"record DataProcessInfo{/**the inputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}inputs:optional array[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]/**the outputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"outputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}outputs:optional array[com.linkedin.common.DatasetUrn]}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DataProcessKey.Fields DataProcessKey() {
            return new DataProcessKey.Fields(this.getPathComponents(), DataProcessAspect.MEMBERKEY_DataProcessKey);
        }

        public Ownership.Fields Ownership() {
            return new Ownership.Fields(this.getPathComponents(), DataProcessAspect.MEMBERKEY_Ownership);
        }

        public DataProcessInfo.Fields DataProcessInfo() {
            return new DataProcessInfo.Fields(this.getPathComponents(), DataProcessAspect.MEMBERKEY_DataProcessInfo);
        }

        public Status.Fields Status() {
            return new Status.Fields(this.getPathComponents(), DataProcessAspect.MEMBERKEY_Status);
        }
    }
}

