/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.chart.ChartInfo;
import com.linkedin.chart.ChartQuery;
import com.linkedin.chart.EditableChartProperties;
import com.linkedin.common.BrowsePaths;
import com.linkedin.common.BrowsePathsV2;
import com.linkedin.common.DataPlatformInstance;
import com.linkedin.common.GlobalTags;
import com.linkedin.common.GlossaryTerms;
import com.linkedin.common.InstitutionalMemory;
import com.linkedin.common.Ownership;
import com.linkedin.common.Status;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.metadata.key.ChartKey;
import java.util.List;
import java.util.function.Function;

public class ChartAspect
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.metadata.key/**Key for a Chart*/@Aspect.name=\"chartKey\"record ChartKey{/**The name of the dashboard tool such as looker, redash etc.*/@Searchable={\"boostScore\":4.0,\"fieldName\":\"tool\",\"fieldType\":\"TEXT_PARTIAL\"}dashboardTool:string/**Unique id for the chart. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, chart URL could be used here for Looker such as 'looker.linkedin.com/looks/1234'*/chartId:string}}{namespace com.linkedin.chart/**Information about a chart*/@Aspect.name=\"chartInfo\"record ChartInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Title of the chart*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}title:string/**Detailed description about the chart*/@Searchable={}description:string/**Captures information about who created/last modified/deleted this chart and when*/lastModified:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}/**URL for the chart. This could be used as an external link on DataHub to allow users access/view the chart*/@Searchable.fieldType=\"KEYWORD\"chartUrl:optional com.linkedin.common.Url/**Data sources for the chart\nDeprecated! Use inputEdges instead.*/@Relationship.`/*/string`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@deprecated,inputs:optional array[/**Input source type for a chart such as dataset or metric*/typeref ChartDataSourceType=union[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]]/**Data sources for the chart*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputEdges/*/created/actor\",\"createdOn\":\"inputEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"inputEdges/*/properties\",\"updatedActor\":\"inputEdges/*/lastModified/actor\",\"updatedOn\":\"inputEdges/*/lastModified/time\"}inputEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional Urn/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional AuditStamp/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]/**Type of the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Chart Type\"}type:optional/**The various types of charts*/enum ChartType{/**Chart showing a Bar chart*/BAR/**Chart showing a Pie chart*/PIE/**Chart showing a Scatter plot*/SCATTER/**Chart showing a table*/TABLE/**Chart showing Markdown formatted text*/TEXT,LINE,AREA,HISTOGRAM,BOX_PLOT,WORD_CLOUD,COHORT}/**Access level for the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Access Level\"}access:optional{namespace com.linkedin.common/**The various access levels*/enum AccessLevel{/**Publicly available access level*/PUBLIC/**Private availability to certain set of users*/PRIVATE}}/**The time when this chart last refreshed*/lastRefreshed:optional com.linkedin.common.Time}}{namespace com.linkedin.chart/**Information for chart query which is used for getting data of the chart*/@Aspect.name=\"chartQuery\"record ChartQuery{/**Raw query to build a chart from input datasets*/rawQuery:string/**Chart query type*/@Searchable={\"addToFilters\":true,\"fieldName\":\"queryType\",\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Query Type\"}type:enum ChartQueryType{/**LookML queries*/LOOKML/**SQL type queries*/SQL}}}{namespace com.linkedin.chart/**Stores editable changes made to properties. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines*/@Aspect.name=\"editableChartProperties\"record EditableChartProperties includes com.linkedin.common.ChangeAuditStamps{/**Edited documentation of the chart */@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:Urn/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}{namespace com.linkedin.common/**Shared aspect containing Browse Paths to be indexed for an entity.*/@Aspect.name=\"browsePaths\"record BrowsePaths{/**A list of valid browse paths for the entity.\n\nBrowse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'*/@Searchable.`/*`={\"fieldName\":\"browsePaths\",\"fieldType\":\"BROWSE_PATH\"}paths:array[string]}}{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:AuditStamp}}{namespace com.linkedin.common/**Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity.*/@Aspect.name=\"institutionalMemory\"record InstitutionalMemory{/**List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record.*/elements:array[/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:Url/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:AuditStamp}]}}{namespace com.linkedin.common/**The specific instance of the data platform that this entity belongs to*/@Aspect.name=\"dataPlatformInstance\"record DataPlatformInstance{/**Data Platform*/@Searchable={\"addToFilters\":true,\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform\"}platform:Urn/**Instance of the data platform (e.g. db instance)*/@Searchable={\"addToFilters\":true,\"fieldName\":\"platformInstance\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform Instance\"}instance:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing a Browse Path to be indexed for an entity.*/@Aspect.name=\"browsePathsV2\"record BrowsePathsV2{/**A valid browse path for the entity. This field is provided by DataHub by default.\nThis aspect is a newer version of browsePaths where we can encode more information in the path.\nThis path is also based on containers for a given entity if it has containers.\n\nThis is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.\nThese paths should not include high level info captured elsewhere ie. Platform and Environment.*/@Searchable.`/*/id`={\"fieldName\":\"browsePathV2\",\"fieldType\":\"BROWSE_PATH_V2\"}path:array[/**Represents a single level in an entity's browsePathV2*/record BrowsePathEntry{/**The ID of the browse path entry. This is what gets stored in the index.\nIf there's an urn associated with this entry, id and urn will be the same*/id:string/**Optional urn pointing to some entity in DataHub*/urn:optional Urn}]}}]", SchemaFormatType.PDL);
    private ChartKey _chartKeyMember = null;
    private ChartInfo _chartInfoMember = null;
    private ChartQuery _chartQueryMember = null;
    private EditableChartProperties _editableChartPropertiesMember = null;
    private Ownership _ownershipMember = null;
    private Status _statusMember = null;
    private GlobalTags _globalTagsMember = null;
    private BrowsePaths _browsePathsMember = null;
    private GlossaryTerms _glossaryTermsMember = null;
    private InstitutionalMemory _institutionalMemoryMember = null;
    private DataPlatformInstance _dataPlatformInstanceMember = null;
    private BrowsePathsV2 _browsePathsV2Member = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_ChartKey = SCHEMA.getTypeByMemberKey("com.linkedin.metadata.key.ChartKey");
    public static final String MEMBERKEY_ChartKey = "com.linkedin.metadata.key.ChartKey";
    private static final DataSchema MEMBER_ChartInfo = SCHEMA.getTypeByMemberKey("com.linkedin.chart.ChartInfo");
    public static final String MEMBERKEY_ChartInfo = "com.linkedin.chart.ChartInfo";
    private static final DataSchema MEMBER_ChartQuery = SCHEMA.getTypeByMemberKey("com.linkedin.chart.ChartQuery");
    public static final String MEMBERKEY_ChartQuery = "com.linkedin.chart.ChartQuery";
    private static final DataSchema MEMBER_EditableChartProperties = SCHEMA.getTypeByMemberKey("com.linkedin.chart.EditableChartProperties");
    public static final String MEMBERKEY_EditableChartProperties = "com.linkedin.chart.EditableChartProperties";
    private static final DataSchema MEMBER_Ownership = SCHEMA.getTypeByMemberKey("com.linkedin.common.Ownership");
    public static final String MEMBERKEY_Ownership = "com.linkedin.common.Ownership";
    private static final DataSchema MEMBER_Status = SCHEMA.getTypeByMemberKey("com.linkedin.common.Status");
    public static final String MEMBERKEY_Status = "com.linkedin.common.Status";
    private static final DataSchema MEMBER_GlobalTags = SCHEMA.getTypeByMemberKey("com.linkedin.common.GlobalTags");
    public static final String MEMBERKEY_GlobalTags = "com.linkedin.common.GlobalTags";
    private static final DataSchema MEMBER_BrowsePaths = SCHEMA.getTypeByMemberKey("com.linkedin.common.BrowsePaths");
    public static final String MEMBERKEY_BrowsePaths = "com.linkedin.common.BrowsePaths";
    private static final DataSchema MEMBER_GlossaryTerms = SCHEMA.getTypeByMemberKey("com.linkedin.common.GlossaryTerms");
    public static final String MEMBERKEY_GlossaryTerms = "com.linkedin.common.GlossaryTerms";
    private static final DataSchema MEMBER_InstitutionalMemory = SCHEMA.getTypeByMemberKey("com.linkedin.common.InstitutionalMemory");
    public static final String MEMBERKEY_InstitutionalMemory = "com.linkedin.common.InstitutionalMemory";
    private static final DataSchema MEMBER_DataPlatformInstance = SCHEMA.getTypeByMemberKey("com.linkedin.common.DataPlatformInstance");
    public static final String MEMBERKEY_DataPlatformInstance = "com.linkedin.common.DataPlatformInstance";
    private static final DataSchema MEMBER_BrowsePathsV2 = SCHEMA.getTypeByMemberKey("com.linkedin.common.BrowsePathsV2");
    public static final String MEMBERKEY_BrowsePathsV2 = "com.linkedin.common.BrowsePathsV2";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public ChartAspect() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public ChartAspect(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ChartAspect create(ChartKey value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setChartKey(value);
        return newUnion;
    }

    public boolean isChartKey() {
        return this.memberIs(MEMBERKEY_ChartKey);
    }

    public ChartKey getChartKey() {
        this.checkNotNull();
        if (this._chartKeyMember != null) {
            return this._chartKeyMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_ChartKey);
        this._chartKeyMember = __rawValue == null ? null : new ChartKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._chartKeyMember;
    }

    public void setChartKey(ChartKey value) {
        this.checkNotNull();
        this._map.clear();
        this._chartKeyMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_ChartKey, value.data());
    }

    public static ChartAspect create(ChartInfo value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setChartInfo(value);
        return newUnion;
    }

    public boolean isChartInfo() {
        return this.memberIs(MEMBERKEY_ChartInfo);
    }

    public ChartInfo getChartInfo() {
        this.checkNotNull();
        if (this._chartInfoMember != null) {
            return this._chartInfoMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_ChartInfo);
        this._chartInfoMember = __rawValue == null ? null : new ChartInfo(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._chartInfoMember;
    }

    public void setChartInfo(ChartInfo value) {
        this.checkNotNull();
        this._map.clear();
        this._chartInfoMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_ChartInfo, value.data());
    }

    public static ChartAspect create(ChartQuery value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setChartQuery(value);
        return newUnion;
    }

    public boolean isChartQuery() {
        return this.memberIs(MEMBERKEY_ChartQuery);
    }

    public ChartQuery getChartQuery() {
        this.checkNotNull();
        if (this._chartQueryMember != null) {
            return this._chartQueryMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_ChartQuery);
        this._chartQueryMember = __rawValue == null ? null : new ChartQuery(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._chartQueryMember;
    }

    public void setChartQuery(ChartQuery value) {
        this.checkNotNull();
        this._map.clear();
        this._chartQueryMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_ChartQuery, value.data());
    }

    public static ChartAspect create(EditableChartProperties value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setEditableChartProperties(value);
        return newUnion;
    }

    public boolean isEditableChartProperties() {
        return this.memberIs(MEMBERKEY_EditableChartProperties);
    }

    public EditableChartProperties getEditableChartProperties() {
        this.checkNotNull();
        if (this._editableChartPropertiesMember != null) {
            return this._editableChartPropertiesMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_EditableChartProperties);
        this._editableChartPropertiesMember = __rawValue == null ? null : new EditableChartProperties(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._editableChartPropertiesMember;
    }

    public void setEditableChartProperties(EditableChartProperties value) {
        this.checkNotNull();
        this._map.clear();
        this._editableChartPropertiesMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_EditableChartProperties, value.data());
    }

    public static ChartAspect create(Ownership value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setOwnership(value);
        return newUnion;
    }

    public boolean isOwnership() {
        return this.memberIs(MEMBERKEY_Ownership);
    }

    public Ownership getOwnership() {
        this.checkNotNull();
        if (this._ownershipMember != null) {
            return this._ownershipMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Ownership);
        this._ownershipMember = __rawValue == null ? null : new Ownership(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._ownershipMember;
    }

    public void setOwnership(Ownership value) {
        this.checkNotNull();
        this._map.clear();
        this._ownershipMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Ownership, value.data());
    }

    public static ChartAspect create(Status value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setStatus(value);
        return newUnion;
    }

    public boolean isStatus() {
        return this.memberIs(MEMBERKEY_Status);
    }

    public Status getStatus() {
        this.checkNotNull();
        if (this._statusMember != null) {
            return this._statusMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Status);
        this._statusMember = __rawValue == null ? null : new Status(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._statusMember;
    }

    public void setStatus(Status value) {
        this.checkNotNull();
        this._map.clear();
        this._statusMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Status, value.data());
    }

    public static ChartAspect create(GlobalTags value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setGlobalTags(value);
        return newUnion;
    }

    public boolean isGlobalTags() {
        return this.memberIs(MEMBERKEY_GlobalTags);
    }

    public GlobalTags getGlobalTags() {
        this.checkNotNull();
        if (this._globalTagsMember != null) {
            return this._globalTagsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_GlobalTags);
        this._globalTagsMember = __rawValue == null ? null : new GlobalTags(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._globalTagsMember;
    }

    public void setGlobalTags(GlobalTags value) {
        this.checkNotNull();
        this._map.clear();
        this._globalTagsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_GlobalTags, value.data());
    }

    public static ChartAspect create(BrowsePaths value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setBrowsePaths(value);
        return newUnion;
    }

    public boolean isBrowsePaths() {
        return this.memberIs(MEMBERKEY_BrowsePaths);
    }

    public BrowsePaths getBrowsePaths() {
        this.checkNotNull();
        if (this._browsePathsMember != null) {
            return this._browsePathsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_BrowsePaths);
        this._browsePathsMember = __rawValue == null ? null : new BrowsePaths(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._browsePathsMember;
    }

    public void setBrowsePaths(BrowsePaths value) {
        this.checkNotNull();
        this._map.clear();
        this._browsePathsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_BrowsePaths, value.data());
    }

    public static ChartAspect create(GlossaryTerms value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setGlossaryTerms(value);
        return newUnion;
    }

    public boolean isGlossaryTerms() {
        return this.memberIs(MEMBERKEY_GlossaryTerms);
    }

    public GlossaryTerms getGlossaryTerms() {
        this.checkNotNull();
        if (this._glossaryTermsMember != null) {
            return this._glossaryTermsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_GlossaryTerms);
        this._glossaryTermsMember = __rawValue == null ? null : new GlossaryTerms(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._glossaryTermsMember;
    }

    public void setGlossaryTerms(GlossaryTerms value) {
        this.checkNotNull();
        this._map.clear();
        this._glossaryTermsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_GlossaryTerms, value.data());
    }

    public static ChartAspect create(InstitutionalMemory value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setInstitutionalMemory(value);
        return newUnion;
    }

    public boolean isInstitutionalMemory() {
        return this.memberIs(MEMBERKEY_InstitutionalMemory);
    }

    public InstitutionalMemory getInstitutionalMemory() {
        this.checkNotNull();
        if (this._institutionalMemoryMember != null) {
            return this._institutionalMemoryMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_InstitutionalMemory);
        this._institutionalMemoryMember = __rawValue == null ? null : new InstitutionalMemory(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._institutionalMemoryMember;
    }

    public void setInstitutionalMemory(InstitutionalMemory value) {
        this.checkNotNull();
        this._map.clear();
        this._institutionalMemoryMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_InstitutionalMemory, value.data());
    }

    public static ChartAspect create(DataPlatformInstance value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setDataPlatformInstance(value);
        return newUnion;
    }

    public boolean isDataPlatformInstance() {
        return this.memberIs(MEMBERKEY_DataPlatformInstance);
    }

    public DataPlatformInstance getDataPlatformInstance() {
        this.checkNotNull();
        if (this._dataPlatformInstanceMember != null) {
            return this._dataPlatformInstanceMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataPlatformInstance);
        this._dataPlatformInstanceMember = __rawValue == null ? null : new DataPlatformInstance(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataPlatformInstanceMember;
    }

    public void setDataPlatformInstance(DataPlatformInstance value) {
        this.checkNotNull();
        this._map.clear();
        this._dataPlatformInstanceMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataPlatformInstance, value.data());
    }

    public static ChartAspect create(BrowsePathsV2 value) {
        ChartAspect newUnion = new ChartAspect();
        newUnion.setBrowsePathsV2(value);
        return newUnion;
    }

    public boolean isBrowsePathsV2() {
        return this.memberIs(MEMBERKEY_BrowsePathsV2);
    }

    public BrowsePathsV2 getBrowsePathsV2() {
        this.checkNotNull();
        if (this._browsePathsV2Member != null) {
            return this._browsePathsV2Member;
        }
        Object __rawValue = this._map.get(MEMBERKEY_BrowsePathsV2);
        this._browsePathsV2Member = __rawValue == null ? null : new BrowsePathsV2(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._browsePathsV2Member;
    }

    public void setBrowsePathsV2(BrowsePathsV2 value) {
        this.checkNotNull();
        this._map.clear();
        this._browsePathsV2Member = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_BrowsePathsV2, value.data());
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public ChartAspect clone() throws CloneNotSupportedException {
        ChartAspect __clone = (ChartAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ChartAspect copy() throws CloneNotSupportedException {
        ChartAspect __copy = (ChartAspect)super.copy();
        __copy._chartQueryMember = null;
        __copy._globalTagsMember = null;
        __copy._browsePathsMember = null;
        __copy._dataPlatformInstanceMember = null;
        __copy._browsePathsV2Member = null;
        __copy._chartInfoMember = null;
        __copy._ownershipMember = null;
        __copy._chartKeyMember = null;
        __copy._glossaryTermsMember = null;
        __copy._institutionalMemoryMember = null;
        __copy._editableChartPropertiesMember = null;
        __copy._statusMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ChartAspect __objectRef;

        private ChangeListener(ChartAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "com.linkedin.chart.ChartQuery": {
                    this.__objectRef._chartQueryMember = null;
                    break;
                }
                case "com.linkedin.common.GlobalTags": {
                    this.__objectRef._globalTagsMember = null;
                    break;
                }
                case "com.linkedin.common.BrowsePaths": {
                    this.__objectRef._browsePathsMember = null;
                    break;
                }
                case "com.linkedin.common.DataPlatformInstance": {
                    this.__objectRef._dataPlatformInstanceMember = null;
                    break;
                }
                case "com.linkedin.common.BrowsePathsV2": {
                    this.__objectRef._browsePathsV2Member = null;
                    break;
                }
                case "com.linkedin.chart.ChartInfo": {
                    this.__objectRef._chartInfoMember = null;
                    break;
                }
                case "com.linkedin.common.Ownership": {
                    this.__objectRef._ownershipMember = null;
                    break;
                }
                case "com.linkedin.metadata.key.ChartKey": {
                    this.__objectRef._chartKeyMember = null;
                    break;
                }
                case "com.linkedin.common.GlossaryTerms": {
                    this.__objectRef._glossaryTermsMember = null;
                    break;
                }
                case "com.linkedin.common.InstitutionalMemory": {
                    this.__objectRef._institutionalMemoryMember = null;
                    break;
                }
                case "com.linkedin.chart.EditableChartProperties": {
                    this.__objectRef._editableChartPropertiesMember = null;
                    break;
                }
                case "com.linkedin.common.Status": {
                    this.__objectRef._statusMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ChartKey.ProjectionMask _ChartKeyMask;
        private ChartInfo.ProjectionMask _ChartInfoMask;
        private ChartQuery.ProjectionMask _ChartQueryMask;
        private EditableChartProperties.ProjectionMask _EditableChartPropertiesMask;
        private Ownership.ProjectionMask _OwnershipMask;
        private Status.ProjectionMask _StatusMask;
        private GlobalTags.ProjectionMask _GlobalTagsMask;
        private BrowsePaths.ProjectionMask _BrowsePathsMask;
        private GlossaryTerms.ProjectionMask _GlossaryTermsMask;
        private InstitutionalMemory.ProjectionMask _InstitutionalMemoryMask;
        private DataPlatformInstance.ProjectionMask _DataPlatformInstanceMask;
        private BrowsePathsV2.ProjectionMask _BrowsePathsV2Mask;

        ProjectionMask() {
        }

        public ProjectionMask withChartKey(Function<ChartKey.ProjectionMask, ChartKey.ProjectionMask> nestedMask) {
            this._ChartKeyMask = nestedMask.apply(this._ChartKeyMask == null ? ChartKey.createMask() : this._ChartKeyMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_ChartKey, this._ChartKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withChartInfo(Function<ChartInfo.ProjectionMask, ChartInfo.ProjectionMask> nestedMask) {
            this._ChartInfoMask = nestedMask.apply(this._ChartInfoMask == null ? ChartInfo.createMask() : this._ChartInfoMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_ChartInfo, this._ChartInfoMask.getDataMap());
            return this;
        }

        public ProjectionMask withChartQuery(Function<ChartQuery.ProjectionMask, ChartQuery.ProjectionMask> nestedMask) {
            this._ChartQueryMask = nestedMask.apply(this._ChartQueryMask == null ? ChartQuery.createMask() : this._ChartQueryMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_ChartQuery, this._ChartQueryMask.getDataMap());
            return this;
        }

        public ProjectionMask withEditableChartProperties(Function<EditableChartProperties.ProjectionMask, EditableChartProperties.ProjectionMask> nestedMask) {
            this._EditableChartPropertiesMask = nestedMask.apply(this._EditableChartPropertiesMask == null ? EditableChartProperties.createMask() : this._EditableChartPropertiesMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_EditableChartProperties, this._EditableChartPropertiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withOwnership(Function<Ownership.ProjectionMask, Ownership.ProjectionMask> nestedMask) {
            this._OwnershipMask = nestedMask.apply(this._OwnershipMask == null ? Ownership.createMask() : this._OwnershipMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_Ownership, this._OwnershipMask.getDataMap());
            return this;
        }

        public ProjectionMask withStatus(Function<Status.ProjectionMask, Status.ProjectionMask> nestedMask) {
            this._StatusMask = nestedMask.apply(this._StatusMask == null ? Status.createMask() : this._StatusMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_Status, this._StatusMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlobalTags(Function<GlobalTags.ProjectionMask, GlobalTags.ProjectionMask> nestedMask) {
            this._GlobalTagsMask = nestedMask.apply(this._GlobalTagsMask == null ? GlobalTags.createMask() : this._GlobalTagsMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_GlobalTags, this._GlobalTagsMask.getDataMap());
            return this;
        }

        public ProjectionMask withBrowsePaths(Function<BrowsePaths.ProjectionMask, BrowsePaths.ProjectionMask> nestedMask) {
            this._BrowsePathsMask = nestedMask.apply(this._BrowsePathsMask == null ? BrowsePaths.createMask() : this._BrowsePathsMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_BrowsePaths, this._BrowsePathsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlossaryTerms(Function<GlossaryTerms.ProjectionMask, GlossaryTerms.ProjectionMask> nestedMask) {
            this._GlossaryTermsMask = nestedMask.apply(this._GlossaryTermsMask == null ? GlossaryTerms.createMask() : this._GlossaryTermsMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_GlossaryTerms, this._GlossaryTermsMask.getDataMap());
            return this;
        }

        public ProjectionMask withInstitutionalMemory(Function<InstitutionalMemory.ProjectionMask, InstitutionalMemory.ProjectionMask> nestedMask) {
            this._InstitutionalMemoryMask = nestedMask.apply(this._InstitutionalMemoryMask == null ? InstitutionalMemory.createMask() : this._InstitutionalMemoryMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_InstitutionalMemory, this._InstitutionalMemoryMask.getDataMap());
            return this;
        }

        public ProjectionMask withDataPlatformInstance(Function<DataPlatformInstance.ProjectionMask, DataPlatformInstance.ProjectionMask> nestedMask) {
            this._DataPlatformInstanceMask = nestedMask.apply(this._DataPlatformInstanceMask == null ? DataPlatformInstance.createMask() : this._DataPlatformInstanceMask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_DataPlatformInstance, this._DataPlatformInstanceMask.getDataMap());
            return this;
        }

        public ProjectionMask withBrowsePathsV2(Function<BrowsePathsV2.ProjectionMask, BrowsePathsV2.ProjectionMask> nestedMask) {
            this._BrowsePathsV2Mask = nestedMask.apply(this._BrowsePathsV2Mask == null ? BrowsePathsV2.createMask() : this._BrowsePathsV2Mask);
            this.getDataMap().put(ChartAspect.MEMBERKEY_BrowsePathsV2, this._BrowsePathsV2Mask.getDataMap());
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Chart*/typeref ChartAspect=union[{namespace com.linkedin.metadata.key/**Key for a Chart*/@Aspect.name=\"chartKey\"record ChartKey{/**The name of the dashboard tool such as looker, redash etc.*/@Searchable={\"boostScore\":4.0,\"fieldName\":\"tool\",\"fieldType\":\"TEXT_PARTIAL\"}dashboardTool:string/**Unique id for the chart. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, chart URL could be used here for Looker such as 'looker.linkedin.com/looks/1234'*/chartId:string}}{namespace com.linkedin.chart/**Information about a chart*/@Aspect.name=\"chartInfo\"record ChartInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Title of the chart*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}title:string/**Detailed description about the chart*/@Searchable={}description:string/**Captures information about who created/last modified/deleted this chart and when*/lastModified:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}/**URL for the chart. This could be used as an external link on DataHub to allow users access/view the chart*/@Searchable.fieldType=\"KEYWORD\"chartUrl:optional com.linkedin.common.Url/**Data sources for the chart\nDeprecated! Use inputEdges instead.*/@Relationship.`/*/string`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@deprecated,inputs:optional array[/**Input source type for a chart such as dataset or metric*/typeref ChartDataSourceType=union[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]]/**Data sources for the chart*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputEdges/*/created/actor\",\"createdOn\":\"inputEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"inputEdges/*/properties\",\"updatedActor\":\"inputEdges/*/lastModified/actor\",\"updatedOn\":\"inputEdges/*/lastModified/time\"}inputEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional Urn/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional AuditStamp/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]/**Type of the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Chart Type\"}type:optional/**The various types of charts*/enum ChartType{/**Chart showing a Bar chart*/BAR/**Chart showing a Pie chart*/PIE/**Chart showing a Scatter plot*/SCATTER/**Chart showing a table*/TABLE/**Chart showing Markdown formatted text*/TEXT,LINE,AREA,HISTOGRAM,BOX_PLOT,WORD_CLOUD,COHORT}/**Access level for the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Access Level\"}access:optional{namespace com.linkedin.common/**The various access levels*/enum AccessLevel{/**Publicly available access level*/PUBLIC/**Private availability to certain set of users*/PRIVATE}}/**The time when this chart last refreshed*/lastRefreshed:optional com.linkedin.common.Time}}{namespace com.linkedin.chart/**Information for chart query which is used for getting data of the chart*/@Aspect.name=\"chartQuery\"record ChartQuery{/**Raw query to build a chart from input datasets*/rawQuery:string/**Chart query type*/@Searchable={\"addToFilters\":true,\"fieldName\":\"queryType\",\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Query Type\"}type:enum ChartQueryType{/**LookML queries*/LOOKML/**SQL type queries*/SQL}}}{namespace com.linkedin.chart/**Stores editable changes made to properties. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines*/@Aspect.name=\"editableChartProperties\"record EditableChartProperties includes com.linkedin.common.ChangeAuditStamps{/**Edited documentation of the chart */@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:Urn/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}{namespace com.linkedin.common/**Shared aspect containing Browse Paths to be indexed for an entity.*/@Aspect.name=\"browsePaths\"record BrowsePaths{/**A list of valid browse paths for the entity.\n\nBrowse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'*/@Searchable.`/*`={\"fieldName\":\"browsePaths\",\"fieldType\":\"BROWSE_PATH\"}paths:array[string]}}{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:AuditStamp}}{namespace com.linkedin.common/**Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity.*/@Aspect.name=\"institutionalMemory\"record InstitutionalMemory{/**List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record.*/elements:array[/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:Url/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:AuditStamp}]}}{namespace com.linkedin.common/**The specific instance of the data platform that this entity belongs to*/@Aspect.name=\"dataPlatformInstance\"record DataPlatformInstance{/**Data Platform*/@Searchable={\"addToFilters\":true,\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform\"}platform:Urn/**Instance of the data platform (e.g. db instance)*/@Searchable={\"addToFilters\":true,\"fieldName\":\"platformInstance\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform Instance\"}instance:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing a Browse Path to be indexed for an entity.*/@Aspect.name=\"browsePathsV2\"record BrowsePathsV2{/**A valid browse path for the entity. This field is provided by DataHub by default.\nThis aspect is a newer version of browsePaths where we can encode more information in the path.\nThis path is also based on containers for a given entity if it has containers.\n\nThis is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.\nThese paths should not include high level info captured elsewhere ie. Platform and Environment.*/@Searchable.`/*/id`={\"fieldName\":\"browsePathV2\",\"fieldType\":\"BROWSE_PATH_V2\"}path:array[/**Represents a single level in an entity's browsePathV2*/record BrowsePathEntry{/**The ID of the browse path entry. This is what gets stored in the index.\nIf there's an urn associated with this entry, id and urn will be the same*/id:string/**Optional urn pointing to some entity in DataHub*/urn:optional Urn}]}}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ChartKey.Fields ChartKey() {
            return new ChartKey.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_ChartKey);
        }

        public ChartInfo.Fields ChartInfo() {
            return new ChartInfo.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_ChartInfo);
        }

        public ChartQuery.Fields ChartQuery() {
            return new ChartQuery.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_ChartQuery);
        }

        public EditableChartProperties.Fields EditableChartProperties() {
            return new EditableChartProperties.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_EditableChartProperties);
        }

        public Ownership.Fields Ownership() {
            return new Ownership.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_Ownership);
        }

        public Status.Fields Status() {
            return new Status.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_Status);
        }

        public GlobalTags.Fields GlobalTags() {
            return new GlobalTags.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_GlobalTags);
        }

        public BrowsePaths.Fields BrowsePaths() {
            return new BrowsePaths.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_BrowsePaths);
        }

        public GlossaryTerms.Fields GlossaryTerms() {
            return new GlossaryTerms.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_GlossaryTerms);
        }

        public InstitutionalMemory.Fields InstitutionalMemory() {
            return new InstitutionalMemory.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_InstitutionalMemory);
        }

        public DataPlatformInstance.Fields DataPlatformInstance() {
            return new DataPlatformInstance.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_DataPlatformInstance);
        }

        public BrowsePathsV2.Fields BrowsePathsV2() {
            return new BrowsePathsV2.Fields(this.getPathComponents(), ChartAspect.MEMBERKEY_BrowsePathsV2);
        }
    }
}

