/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpUserAppearanceSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Settings for a user around the appearance of their DataHub UI*/record CorpUserAppearanceSettings{/**Flag whether the user should see a homepage with only datasets, charts and dashboards. Intended for users\nwho have less operational use cases for the datahub tool.*/showSimplifiedHomepage:optional boolean/**Flag controlling whether the V2 UI for DataHub is shown.*/showThemeV2:optional boolean}", SchemaFormatType.PDL);
    private Boolean _showSimplifiedHomepageField = null;
    private Boolean _showThemeV2Field = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ShowSimplifiedHomepage = SCHEMA.getField("showSimplifiedHomepage");
    private static final RecordDataSchema.Field FIELD_ShowThemeV2 = SCHEMA.getField("showThemeV2");

    public CorpUserAppearanceSettings() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserAppearanceSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasShowSimplifiedHomepage() {
        if (this._showSimplifiedHomepageField != null) {
            return true;
        }
        return this._map.containsKey("showSimplifiedHomepage");
    }

    public void removeShowSimplifiedHomepage() {
        this._map.remove("showSimplifiedHomepage");
    }

    @Nullable
    public Boolean isShowSimplifiedHomepage(GetMode mode) {
        return this.isShowSimplifiedHomepage();
    }

    @Nullable
    public Boolean isShowSimplifiedHomepage() {
        if (this._showSimplifiedHomepageField != null) {
            return this._showSimplifiedHomepageField;
        }
        Object __rawValue = this._map.get("showSimplifiedHomepage");
        this._showSimplifiedHomepageField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._showSimplifiedHomepageField;
    }

    public CorpUserAppearanceSettings setShowSimplifiedHomepage(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setShowSimplifiedHomepage(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeShowSimplifiedHomepage();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "showSimplifiedHomepage", value);
                this._showSimplifiedHomepageField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "showSimplifiedHomepage", value);
                this._showSimplifiedHomepageField = value;
            }
        }
        return this;
    }

    public CorpUserAppearanceSettings setShowSimplifiedHomepage(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field showSimplifiedHomepage of com.linkedin.identity.CorpUserAppearanceSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "showSimplifiedHomepage", value);
        this._showSimplifiedHomepageField = value;
        return this;
    }

    public CorpUserAppearanceSettings setShowSimplifiedHomepage(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "showSimplifiedHomepage", value);
        this._showSimplifiedHomepageField = value;
        return this;
    }

    public boolean hasShowThemeV2() {
        if (this._showThemeV2Field != null) {
            return true;
        }
        return this._map.containsKey("showThemeV2");
    }

    public void removeShowThemeV2() {
        this._map.remove("showThemeV2");
    }

    @Nullable
    public Boolean isShowThemeV2(GetMode mode) {
        return this.isShowThemeV2();
    }

    @Nullable
    public Boolean isShowThemeV2() {
        if (this._showThemeV2Field != null) {
            return this._showThemeV2Field;
        }
        Object __rawValue = this._map.get("showThemeV2");
        this._showThemeV2Field = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._showThemeV2Field;
    }

    public CorpUserAppearanceSettings setShowThemeV2(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setShowThemeV2(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeShowThemeV2();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "showThemeV2", value);
                this._showThemeV2Field = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "showThemeV2", value);
                this._showThemeV2Field = value;
            }
        }
        return this;
    }

    public CorpUserAppearanceSettings setShowThemeV2(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field showThemeV2 of com.linkedin.identity.CorpUserAppearanceSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "showThemeV2", value);
        this._showThemeV2Field = value;
        return this;
    }

    public CorpUserAppearanceSettings setShowThemeV2(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "showThemeV2", value);
        this._showThemeV2Field = value;
        return this;
    }

    @Override
    public CorpUserAppearanceSettings clone() throws CloneNotSupportedException {
        CorpUserAppearanceSettings __clone = (CorpUserAppearanceSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserAppearanceSettings copy() throws CloneNotSupportedException {
        CorpUserAppearanceSettings __copy = (CorpUserAppearanceSettings)super.copy();
        __copy._showThemeV2Field = null;
        __copy._showSimplifiedHomepageField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserAppearanceSettings __objectRef;

        private ChangeListener(CorpUserAppearanceSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "showThemeV2": {
                    this.__objectRef._showThemeV2Field = null;
                    break;
                }
                case "showSimplifiedHomepage": {
                    this.__objectRef._showSimplifiedHomepageField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec showSimplifiedHomepage() {
            return new PathSpec(this.getPathComponents(), "showSimplifiedHomepage");
        }

        public PathSpec showThemeV2() {
            return new PathSpec(this.getPathComponents(), "showThemeV2");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withShowSimplifiedHomepage() {
            this.getDataMap().put("showSimplifiedHomepage", 1);
            return this;
        }

        public ProjectionMask withShowThemeV2() {
            this.getDataMap().put("showThemeV2", 1);
            return this;
        }
    }
}

