/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.entity;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.entity.EnvelopedAspectMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityResponse
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.entity/**A DataHub 'entity', which is comprised of a set of latest aspects present for the aspect.\n*/record EntityResponse{/**The entity name\n*/entityName:string/**The entity urn\n*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**A map of aspect name to aspect\n*/aspects:map[string/**An aspect, along with the metadata about it.\nCurrently, an aspect can be either of type 'timestamp' or 'versioned'.\n*/record EnvelopedAspect{/**The name of the aspect\n*/name:string/**The type of the aspect, either timeseries or versioned\n*/type:/**The type of a DataHub aspect*/enum AspectType{/**Designates an aspect that has a monotonically increasing version number*/VERSIONED/**Designates an aspect that represents a point-in-time data point*/TIMESERIES}/**The version of the aspect, only populated if type is 'VERSIONED'\n*/version:optional long/**The timestamp of the aspect, only populated if type is 'TIMESTAMP'\n*/timestamp:optional long/**The raw value of the aspect\n*/value:/**Placeholder PDL record to store the aspect in the response. By using this place-holder, metadata-service can return\nany type of aspect without having to define a single union class*/record Aspect{}/**The audit stamp detailing who the aspect was created by and when\n*/created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**The system metadata for this aspect\n*/systemMetadata:optional{namespace com.linkedin.mxe/**Metadata associated with each metadata change that is processed by the system*/@Aspect.name=\"systemMetadata\"record SystemMetadata{/**The timestamp the metadata was observed at*/lastObserved:optional long=0/**The original run id that produced the metadata. Populated in case of batch-ingestion.*/runId:optional string=\"no-run-id-provided\"/**The last run id that produced the metadata. Populated in case of batch-ingestion.*/lastRunId:optional string=\"no-run-id-provided\"/**The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion.*/pipelineName:optional string/**The model registry name that was used to process this event*/registryName:optional string/**The model registry version that was used to process this event*/registryVersion:optional string/**Additional properties*/properties:optional map[string,string]/**Aspect version\n   Initial implementation will use the aspect version's number, however stored as\n   a string in the case where a different aspect versioning scheme is later adopted.*/version:optional string}}}]}", SchemaFormatType.PDL);
    private String _entityNameField = null;
    private Urn _urnField = null;
    private EnvelopedAspectMap _aspectsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_EntityName = SCHEMA.getField("entityName");
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_Aspects = SCHEMA.getField("aspects");

    public EntityResponse() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public EntityResponse(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntityName() {
        if (this._entityNameField != null) {
            return true;
        }
        return this._map.containsKey("entityName");
    }

    public void removeEntityName() {
        this._map.remove("entityName");
    }

    @Nullable
    public String getEntityName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntityName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityNameField != null) {
                    return this._entityNameField;
                }
                Object __rawValue = this._map.get("entityName");
                this._entityNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._entityNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getEntityName() {
        if (this._entityNameField != null) {
            return this._entityNameField;
        }
        Object __rawValue = this._map.get("entityName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entityName");
        }
        this._entityNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._entityNameField;
    }

    public EntityResponse setEntityName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entityName of com.linkedin.entity.EntityResponse");
                }
                CheckedUtil.putWithoutChecking(this._map, "entityName", value);
                this._entityNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityName", value);
                this._entityNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityName", value);
                this._entityNameField = value;
            }
        }
        return this;
    }

    public EntityResponse setEntityName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityName of com.linkedin.entity.EntityResponse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityName", value);
        this._entityNameField = value;
        return this;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public Urn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._urnField;
    }

    public EntityResponse setUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.entity.EntityResponse");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public EntityResponse setUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.entity.EntityResponse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasAspects() {
        if (this._aspectsField != null) {
            return true;
        }
        return this._map.containsKey("aspects");
    }

    public void removeAspects() {
        this._map.remove("aspects");
    }

    @Nullable
    public EnvelopedAspectMap getAspects(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAspects();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aspectsField != null) {
                    return this._aspectsField;
                }
                Object __rawValue = this._map.get("aspects");
                this._aspectsField = __rawValue == null ? null : new EnvelopedAspectMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._aspectsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public EnvelopedAspectMap getAspects() {
        if (this._aspectsField != null) {
            return this._aspectsField;
        }
        Object __rawValue = this._map.get("aspects");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aspects");
        }
        this._aspectsField = __rawValue == null ? null : new EnvelopedAspectMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aspectsField;
    }

    public EntityResponse setAspects(@Nullable EnvelopedAspectMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aspects of com.linkedin.entity.EntityResponse");
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
            }
        }
        return this;
    }

    public EntityResponse setAspects(@Nonnull EnvelopedAspectMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspects of com.linkedin.entity.EntityResponse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
        this._aspectsField = value;
        return this;
    }

    @Override
    public EntityResponse clone() throws CloneNotSupportedException {
        EntityResponse __clone = (EntityResponse)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EntityResponse copy() throws CloneNotSupportedException {
        EntityResponse __copy = (EntityResponse)super.copy();
        __copy._urnField = null;
        __copy._entityNameField = null;
        __copy._aspectsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EntityResponse __objectRef;

        private ChangeListener(EntityResponse reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "entityName": {
                    this.__objectRef._entityNameField = null;
                    break;
                }
                case "aspects": {
                    this.__objectRef._aspectsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entityName() {
            return new PathSpec(this.getPathComponents(), "entityName");
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public EnvelopedAspectMap.Fields aspects() {
            return new EnvelopedAspectMap.Fields(this.getPathComponents(), "aspects");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private EnvelopedAspectMap.ProjectionMask _aspectsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withEntityName() {
            this.getDataMap().put("entityName", 1);
            return this;
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withAspects(Function<EnvelopedAspectMap.ProjectionMask, EnvelopedAspectMap.ProjectionMask> nestedMask) {
            this._aspectsMask = nestedMask.apply(this._aspectsMask == null ? EnvelopedAspectMap.createMask() : this._aspectsMask);
            this.getDataMap().put("aspects", this._aspectsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspects() {
            this._aspectsMask = null;
            this.getDataMap().put("aspects", 1);
            return this;
        }
    }
}

