/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.FineGrainedLineageDownstreamType;
import com.linkedin.dataset.FineGrainedLineageUpstreamType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FineGrainedLineage
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**A fine-grained lineage from upstream fields/datasets to downstream field(s)*/record FineGrainedLineage{/**The type of upstream entity*/upstreamType:/**The type of upstream entity in a fine-grained lineage*/enum FineGrainedLineageUpstreamType{/** Indicates that this lineage is originating from upstream field(s)*/FIELD_SET/** Indicates that this lineage is originating from upstream dataset(s)*/DATASET/** Indicates that there is no upstream lineage i.e. the downstream field is not a derived field*/NONE}/**Upstream entities in the lineage*/upstreams:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**The type of downstream field(s)*/downstreamType:/**The type of downstream field(s) in a fine-grained lineage*/enum FineGrainedLineageDownstreamType{/** Indicates that the lineage is for a single, specific, downstream field*/FIELD/** Indicates that the lineage is for a set of downstream fields*/FIELD_SET}/**Downstream fields in the lineage*/downstreams:optional array[com.linkedin.common.Urn]/**The transform operation applied to the upstream entities to produce the downstream field(s)*/transformOperation:optional string/**The confidence in this lineage between 0 (low confidence) and 1 (high confidence)*/confidenceScore:float=1.0/**The query that was used to generate this lineage. \nPresent only if the lineage was generated from a detected query.*/query:optional com.linkedin.common.Urn}", SchemaFormatType.PDL);
    private FineGrainedLineageUpstreamType _upstreamTypeField = null;
    private UrnArray _upstreamsField = null;
    private FineGrainedLineageDownstreamType _downstreamTypeField = null;
    private UrnArray _downstreamsField = null;
    private String _transformOperationField = null;
    private Float _confidenceScoreField = null;
    private Urn _queryField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_UpstreamType = SCHEMA.getField("upstreamType");
    private static final RecordDataSchema.Field FIELD_Upstreams = SCHEMA.getField("upstreams");
    private static final RecordDataSchema.Field FIELD_DownstreamType = SCHEMA.getField("downstreamType");
    private static final RecordDataSchema.Field FIELD_Downstreams = SCHEMA.getField("downstreams");
    private static final RecordDataSchema.Field FIELD_TransformOperation = SCHEMA.getField("transformOperation");
    private static final RecordDataSchema.Field FIELD_ConfidenceScore = SCHEMA.getField("confidenceScore");
    private static final Float DEFAULT_ConfidenceScore;
    private static final RecordDataSchema.Field FIELD_Query;

    public FineGrainedLineage() {
        super(new DataMap(10, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FineGrainedLineage(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUpstreamType() {
        if (this._upstreamTypeField != null) {
            return true;
        }
        return this._map.containsKey("upstreamType");
    }

    public void removeUpstreamType() {
        this._map.remove("upstreamType");
    }

    @Nullable
    public FineGrainedLineageUpstreamType getUpstreamType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUpstreamType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._upstreamTypeField != null) {
                    return this._upstreamTypeField;
                }
                Object __rawValue = this._map.get("upstreamType");
                this._upstreamTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FineGrainedLineageUpstreamType.class, FineGrainedLineageUpstreamType.$UNKNOWN);
                return this._upstreamTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FineGrainedLineageUpstreamType getUpstreamType() {
        if (this._upstreamTypeField != null) {
            return this._upstreamTypeField;
        }
        Object __rawValue = this._map.get("upstreamType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("upstreamType");
        }
        this._upstreamTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FineGrainedLineageUpstreamType.class, FineGrainedLineageUpstreamType.$UNKNOWN);
        return this._upstreamTypeField;
    }

    public FineGrainedLineage setUpstreamType(@Nullable FineGrainedLineageUpstreamType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUpstreamType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field upstreamType of com.linkedin.dataset.FineGrainedLineage");
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreamType", value.name());
                this._upstreamTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUpstreamType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreamType", value.name());
                this._upstreamTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "upstreamType", value.name());
                this._upstreamTypeField = value;
            }
        }
        return this;
    }

    public FineGrainedLineage setUpstreamType(@Nonnull FineGrainedLineageUpstreamType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field upstreamType of com.linkedin.dataset.FineGrainedLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "upstreamType", value.name());
        this._upstreamTypeField = value;
        return this;
    }

    public boolean hasUpstreams() {
        if (this._upstreamsField != null) {
            return true;
        }
        return this._map.containsKey("upstreams");
    }

    public void removeUpstreams() {
        this._map.remove("upstreams");
    }

    @Nullable
    public UrnArray getUpstreams(GetMode mode) {
        return this.getUpstreams();
    }

    @Nullable
    public UrnArray getUpstreams() {
        if (this._upstreamsField != null) {
            return this._upstreamsField;
        }
        Object __rawValue = this._map.get("upstreams");
        this._upstreamsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._upstreamsField;
    }

    public FineGrainedLineage setUpstreams(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUpstreams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUpstreams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreams", value.data());
                this._upstreamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "upstreams", value.data());
                this._upstreamsField = value;
            }
        }
        return this;
    }

    public FineGrainedLineage setUpstreams(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field upstreams of com.linkedin.dataset.FineGrainedLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "upstreams", value.data());
        this._upstreamsField = value;
        return this;
    }

    public boolean hasDownstreamType() {
        if (this._downstreamTypeField != null) {
            return true;
        }
        return this._map.containsKey("downstreamType");
    }

    public void removeDownstreamType() {
        this._map.remove("downstreamType");
    }

    @Nullable
    public FineGrainedLineageDownstreamType getDownstreamType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDownstreamType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._downstreamTypeField != null) {
                    return this._downstreamTypeField;
                }
                Object __rawValue = this._map.get("downstreamType");
                this._downstreamTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FineGrainedLineageDownstreamType.class, FineGrainedLineageDownstreamType.$UNKNOWN);
                return this._downstreamTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FineGrainedLineageDownstreamType getDownstreamType() {
        if (this._downstreamTypeField != null) {
            return this._downstreamTypeField;
        }
        Object __rawValue = this._map.get("downstreamType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("downstreamType");
        }
        this._downstreamTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FineGrainedLineageDownstreamType.class, FineGrainedLineageDownstreamType.$UNKNOWN);
        return this._downstreamTypeField;
    }

    public FineGrainedLineage setDownstreamType(@Nullable FineGrainedLineageDownstreamType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDownstreamType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field downstreamType of com.linkedin.dataset.FineGrainedLineage");
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreamType", value.name());
                this._downstreamTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDownstreamType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreamType", value.name());
                this._downstreamTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "downstreamType", value.name());
                this._downstreamTypeField = value;
            }
        }
        return this;
    }

    public FineGrainedLineage setDownstreamType(@Nonnull FineGrainedLineageDownstreamType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field downstreamType of com.linkedin.dataset.FineGrainedLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "downstreamType", value.name());
        this._downstreamTypeField = value;
        return this;
    }

    public boolean hasDownstreams() {
        if (this._downstreamsField != null) {
            return true;
        }
        return this._map.containsKey("downstreams");
    }

    public void removeDownstreams() {
        this._map.remove("downstreams");
    }

    @Nullable
    public UrnArray getDownstreams(GetMode mode) {
        return this.getDownstreams();
    }

    @Nullable
    public UrnArray getDownstreams() {
        if (this._downstreamsField != null) {
            return this._downstreamsField;
        }
        Object __rawValue = this._map.get("downstreams");
        this._downstreamsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._downstreamsField;
    }

    public FineGrainedLineage setDownstreams(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDownstreams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDownstreams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreams", value.data());
                this._downstreamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "downstreams", value.data());
                this._downstreamsField = value;
            }
        }
        return this;
    }

    public FineGrainedLineage setDownstreams(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field downstreams of com.linkedin.dataset.FineGrainedLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "downstreams", value.data());
        this._downstreamsField = value;
        return this;
    }

    public boolean hasTransformOperation() {
        if (this._transformOperationField != null) {
            return true;
        }
        return this._map.containsKey("transformOperation");
    }

    public void removeTransformOperation() {
        this._map.remove("transformOperation");
    }

    @Nullable
    public String getTransformOperation(GetMode mode) {
        return this.getTransformOperation();
    }

    @Nullable
    public String getTransformOperation() {
        if (this._transformOperationField != null) {
            return this._transformOperationField;
        }
        Object __rawValue = this._map.get("transformOperation");
        this._transformOperationField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._transformOperationField;
    }

    public FineGrainedLineage setTransformOperation(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTransformOperation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTransformOperation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "transformOperation", value);
                this._transformOperationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "transformOperation", value);
                this._transformOperationField = value;
            }
        }
        return this;
    }

    public FineGrainedLineage setTransformOperation(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field transformOperation of com.linkedin.dataset.FineGrainedLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "transformOperation", value);
        this._transformOperationField = value;
        return this;
    }

    public boolean hasConfidenceScore() {
        if (this._confidenceScoreField != null) {
            return true;
        }
        return this._map.containsKey("confidenceScore");
    }

    public void removeConfidenceScore() {
        this._map.remove("confidenceScore");
    }

    @Nullable
    public Float getConfidenceScore(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getConfidenceScore();
            }
            case NULL: {
                if (this._confidenceScoreField != null) {
                    return this._confidenceScoreField;
                }
                Object __rawValue = this._map.get("confidenceScore");
                this._confidenceScoreField = DataTemplateUtil.coerceFloatOutput(__rawValue);
                return this._confidenceScoreField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Float getConfidenceScore() {
        if (this._confidenceScoreField != null) {
            return this._confidenceScoreField;
        }
        Object __rawValue = this._map.get("confidenceScore");
        if (__rawValue == null) {
            return DEFAULT_ConfidenceScore;
        }
        this._confidenceScoreField = DataTemplateUtil.coerceFloatOutput(__rawValue);
        return this._confidenceScoreField;
    }

    public FineGrainedLineage setConfidenceScore(@Nullable Float value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setConfidenceScore(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field confidenceScore of com.linkedin.dataset.FineGrainedLineage");
                }
                CheckedUtil.putWithoutChecking(this._map, "confidenceScore", DataTemplateUtil.coerceFloatInput(value));
                this._confidenceScoreField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeConfidenceScore();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "confidenceScore", DataTemplateUtil.coerceFloatInput(value));
                this._confidenceScoreField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "confidenceScore", DataTemplateUtil.coerceFloatInput(value));
                this._confidenceScoreField = value;
            }
        }
        return this;
    }

    public FineGrainedLineage setConfidenceScore(@Nonnull Float value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field confidenceScore of com.linkedin.dataset.FineGrainedLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "confidenceScore", DataTemplateUtil.coerceFloatInput(value));
        this._confidenceScoreField = value;
        return this;
    }

    public FineGrainedLineage setConfidenceScore(float value) {
        CheckedUtil.putWithoutChecking(this._map, "confidenceScore", DataTemplateUtil.coerceFloatInput(Float.valueOf(value)));
        this._confidenceScoreField = Float.valueOf(value);
        return this;
    }

    public boolean hasQuery() {
        if (this._queryField != null) {
            return true;
        }
        return this._map.containsKey("query");
    }

    public void removeQuery() {
        this._map.remove("query");
    }

    @Nullable
    public Urn getQuery(GetMode mode) {
        return this.getQuery();
    }

    @Nullable
    public Urn getQuery() {
        if (this._queryField != null) {
            return this._queryField;
        }
        Object __rawValue = this._map.get("query");
        this._queryField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._queryField;
    }

    public FineGrainedLineage setQuery(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQuery(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQuery();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "query", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._queryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "query", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._queryField = value;
            }
        }
        return this;
    }

    public FineGrainedLineage setQuery(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field query of com.linkedin.dataset.FineGrainedLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "query", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._queryField = value;
        return this;
    }

    @Override
    public FineGrainedLineage clone() throws CloneNotSupportedException {
        FineGrainedLineage __clone = (FineGrainedLineage)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FineGrainedLineage copy() throws CloneNotSupportedException {
        FineGrainedLineage __copy = (FineGrainedLineage)super.copy();
        __copy._downstreamsField = null;
        __copy._confidenceScoreField = null;
        __copy._upstreamsField = null;
        __copy._queryField = null;
        __copy._downstreamTypeField = null;
        __copy._transformOperationField = null;
        __copy._upstreamTypeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Query = SCHEMA.getField("query");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_ConfidenceScore = DataTemplateUtil.coerceFloatOutput(FIELD_ConfidenceScore.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FineGrainedLineage __objectRef;

        private ChangeListener(FineGrainedLineage reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "downstreams": {
                    this.__objectRef._downstreamsField = null;
                    break;
                }
                case "confidenceScore": {
                    this.__objectRef._confidenceScoreField = null;
                    break;
                }
                case "upstreams": {
                    this.__objectRef._upstreamsField = null;
                    break;
                }
                case "query": {
                    this.__objectRef._queryField = null;
                    break;
                }
                case "downstreamType": {
                    this.__objectRef._downstreamTypeField = null;
                    break;
                }
                case "transformOperation": {
                    this.__objectRef._transformOperationField = null;
                    break;
                }
                case "upstreamType": {
                    this.__objectRef._upstreamTypeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec upstreamType() {
            return new PathSpec(this.getPathComponents(), "upstreamType");
        }

        public PathSpec upstreams() {
            return new PathSpec(this.getPathComponents(), "upstreams");
        }

        public PathSpec upstreams(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "upstreams");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec downstreamType() {
            return new PathSpec(this.getPathComponents(), "downstreamType");
        }

        public PathSpec downstreams() {
            return new PathSpec(this.getPathComponents(), "downstreams");
        }

        public PathSpec downstreams(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "downstreams");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec transformOperation() {
            return new PathSpec(this.getPathComponents(), "transformOperation");
        }

        public PathSpec confidenceScore() {
            return new PathSpec(this.getPathComponents(), "confidenceScore");
        }

        public PathSpec query() {
            return new PathSpec(this.getPathComponents(), "query");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withUpstreamType() {
            this.getDataMap().put("upstreamType", 1);
            return this;
        }

        public ProjectionMask withUpstreams() {
            this.getDataMap().put("upstreams", 1);
            return this;
        }

        public ProjectionMask withUpstreams(Integer start, Integer count) {
            this.getDataMap().put("upstreams", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("upstreams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("upstreams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDownstreamType() {
            this.getDataMap().put("downstreamType", 1);
            return this;
        }

        public ProjectionMask withDownstreams() {
            this.getDataMap().put("downstreams", 1);
            return this;
        }

        public ProjectionMask withDownstreams(Integer start, Integer count) {
            this.getDataMap().put("downstreams", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("downstreams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("downstreams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTransformOperation() {
            this.getDataMap().put("transformOperation", 1);
            return this;
        }

        public ProjectionMask withConfidenceScore() {
            this.getDataMap().put("confidenceScore", 1);
            return this;
        }

        public ProjectionMask withQuery() {
            this.getDataMap().put("query", 1);
            return this;
        }
    }
}

