/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.dataset.DatasetUserUsageCounts;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class DatasetUserUsageCountsArray
extends WrappingArrayTemplate<DatasetUserUsageCounts> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.dataset/**Records a single user's usage counts for a given resource*/record DatasetUserUsageCounts{/**The unique id of the user.*/user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Number of times the dataset has been used by the user.*/@TimeseriesField={}count:int/**If user_email is set, we attempt to resolve the user's urn upon ingest*/@TimeseriesField={}userEmail:optional string}}]", SchemaFormatType.PDL);

    public DatasetUserUsageCountsArray() {
        this(new DataList());
    }

    public DatasetUserUsageCountsArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public DatasetUserUsageCountsArray(Collection<DatasetUserUsageCounts> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public DatasetUserUsageCountsArray(DataList data) {
        super(data, SCHEMA, DatasetUserUsageCounts.class);
    }

    public DatasetUserUsageCountsArray(DatasetUserUsageCounts first, DatasetUserUsageCounts ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DatasetUserUsageCountsArray clone() throws CloneNotSupportedException {
        DatasetUserUsageCountsArray __clone = (DatasetUserUsageCountsArray)super.clone();
        return __clone;
    }

    @Override
    public DatasetUserUsageCountsArray copy() throws CloneNotSupportedException {
        DatasetUserUsageCountsArray __copy = (DatasetUserUsageCountsArray)super.copy();
        return __copy;
    }

    @Override
    protected DatasetUserUsageCounts coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new DatasetUserUsageCounts(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private DatasetUserUsageCounts.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<DatasetUserUsageCounts.ProjectionMask, DatasetUserUsageCounts.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? DatasetUserUsageCounts.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DatasetUserUsageCounts.Fields items() {
            return new DatasetUserUsageCounts.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

