/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.dataset.Histogram;
import com.linkedin.dataset.QuantileArray;
import com.linkedin.dataset.ValueFrequencyArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetFieldProfile
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Stats corresponding to fields in a dataset*/record DatasetFieldProfile{fieldPath:string,uniqueCount:optional long,uniqueProportion:optional float,nullCount:optional long,nullProportion:optional float,min:optional string,max:optional string,mean:optional string,median:optional string,stdev:optional string,quantiles:optional array[record Quantile{quantile:string,value:string}]distinctValueFrequencies:optional array[record ValueFrequency{value:string,frequency:long}]histogram:optional record Histogram{boundaries:array[string]heights:array[float]}sampleValues:optional array[string]}", SchemaFormatType.PDL);
    private String _fieldPathField = null;
    private Long _uniqueCountField = null;
    private Float _uniqueProportionField = null;
    private Long _nullCountField = null;
    private Float _nullProportionField = null;
    private String _minField = null;
    private String _maxField = null;
    private String _meanField = null;
    private String _medianField = null;
    private String _stdevField = null;
    private QuantileArray _quantilesField = null;
    private ValueFrequencyArray _distinctValueFrequenciesField = null;
    private Histogram _histogramField = null;
    private StringArray _sampleValuesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_FieldPath = SCHEMA.getField("fieldPath");
    private static final RecordDataSchema.Field FIELD_UniqueCount = SCHEMA.getField("uniqueCount");
    private static final RecordDataSchema.Field FIELD_UniqueProportion = SCHEMA.getField("uniqueProportion");
    private static final RecordDataSchema.Field FIELD_NullCount = SCHEMA.getField("nullCount");
    private static final RecordDataSchema.Field FIELD_NullProportion = SCHEMA.getField("nullProportion");
    private static final RecordDataSchema.Field FIELD_Min = SCHEMA.getField("min");
    private static final RecordDataSchema.Field FIELD_Max = SCHEMA.getField("max");
    private static final RecordDataSchema.Field FIELD_Mean = SCHEMA.getField("mean");
    private static final RecordDataSchema.Field FIELD_Median = SCHEMA.getField("median");
    private static final RecordDataSchema.Field FIELD_Stdev = SCHEMA.getField("stdev");
    private static final RecordDataSchema.Field FIELD_Quantiles = SCHEMA.getField("quantiles");
    private static final RecordDataSchema.Field FIELD_DistinctValueFrequencies = SCHEMA.getField("distinctValueFrequencies");
    private static final RecordDataSchema.Field FIELD_Histogram = SCHEMA.getField("histogram");
    private static final RecordDataSchema.Field FIELD_SampleValues = SCHEMA.getField("sampleValues");

    public DatasetFieldProfile() {
        super(new DataMap(), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetFieldProfile(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFieldPath() {
        if (this._fieldPathField != null) {
            return true;
        }
        return this._map.containsKey("fieldPath");
    }

    public void removeFieldPath() {
        this._map.remove("fieldPath");
    }

    @Nullable
    public String getFieldPath(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFieldPath();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldPathField != null) {
                    return this._fieldPathField;
                }
                Object __rawValue = this._map.get("fieldPath");
                this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._fieldPathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getFieldPath() {
        if (this._fieldPathField != null) {
            return this._fieldPathField;
        }
        Object __rawValue = this._map.get("fieldPath");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("fieldPath");
        }
        this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldPathField;
    }

    public DatasetFieldProfile setFieldPath(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field fieldPath of com.linkedin.dataset.DatasetFieldProfile");
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldPath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setFieldPath(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldPath of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
        this._fieldPathField = value;
        return this;
    }

    public boolean hasUniqueCount() {
        if (this._uniqueCountField != null) {
            return true;
        }
        return this._map.containsKey("uniqueCount");
    }

    public void removeUniqueCount() {
        this._map.remove("uniqueCount");
    }

    @Nullable
    public Long getUniqueCount(GetMode mode) {
        return this.getUniqueCount();
    }

    @Nullable
    public Long getUniqueCount() {
        if (this._uniqueCountField != null) {
            return this._uniqueCountField;
        }
        Object __rawValue = this._map.get("uniqueCount");
        this._uniqueCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._uniqueCountField;
    }

    public DatasetFieldProfile setUniqueCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUniqueCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUniqueCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "uniqueCount", DataTemplateUtil.coerceLongInput(value));
                this._uniqueCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "uniqueCount", DataTemplateUtil.coerceLongInput(value));
                this._uniqueCountField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setUniqueCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field uniqueCount of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "uniqueCount", DataTemplateUtil.coerceLongInput(value));
        this._uniqueCountField = value;
        return this;
    }

    public DatasetFieldProfile setUniqueCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "uniqueCount", DataTemplateUtil.coerceLongInput(value));
        this._uniqueCountField = value;
        return this;
    }

    public boolean hasUniqueProportion() {
        if (this._uniqueProportionField != null) {
            return true;
        }
        return this._map.containsKey("uniqueProportion");
    }

    public void removeUniqueProportion() {
        this._map.remove("uniqueProportion");
    }

    @Nullable
    public Float getUniqueProportion(GetMode mode) {
        return this.getUniqueProportion();
    }

    @Nullable
    public Float getUniqueProportion() {
        if (this._uniqueProportionField != null) {
            return this._uniqueProportionField;
        }
        Object __rawValue = this._map.get("uniqueProportion");
        this._uniqueProportionField = DataTemplateUtil.coerceFloatOutput(__rawValue);
        return this._uniqueProportionField;
    }

    public DatasetFieldProfile setUniqueProportion(@Nullable Float value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUniqueProportion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUniqueProportion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "uniqueProportion", DataTemplateUtil.coerceFloatInput(value));
                this._uniqueProportionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "uniqueProportion", DataTemplateUtil.coerceFloatInput(value));
                this._uniqueProportionField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setUniqueProportion(@Nonnull Float value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field uniqueProportion of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "uniqueProportion", DataTemplateUtil.coerceFloatInput(value));
        this._uniqueProportionField = value;
        return this;
    }

    public DatasetFieldProfile setUniqueProportion(float value) {
        CheckedUtil.putWithoutChecking(this._map, "uniqueProportion", DataTemplateUtil.coerceFloatInput(Float.valueOf(value)));
        this._uniqueProportionField = Float.valueOf(value);
        return this;
    }

    public boolean hasNullCount() {
        if (this._nullCountField != null) {
            return true;
        }
        return this._map.containsKey("nullCount");
    }

    public void removeNullCount() {
        this._map.remove("nullCount");
    }

    @Nullable
    public Long getNullCount(GetMode mode) {
        return this.getNullCount();
    }

    @Nullable
    public Long getNullCount() {
        if (this._nullCountField != null) {
            return this._nullCountField;
        }
        Object __rawValue = this._map.get("nullCount");
        this._nullCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._nullCountField;
    }

    public DatasetFieldProfile setNullCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNullCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNullCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nullCount", DataTemplateUtil.coerceLongInput(value));
                this._nullCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nullCount", DataTemplateUtil.coerceLongInput(value));
                this._nullCountField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setNullCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nullCount of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nullCount", DataTemplateUtil.coerceLongInput(value));
        this._nullCountField = value;
        return this;
    }

    public DatasetFieldProfile setNullCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "nullCount", DataTemplateUtil.coerceLongInput(value));
        this._nullCountField = value;
        return this;
    }

    public boolean hasNullProportion() {
        if (this._nullProportionField != null) {
            return true;
        }
        return this._map.containsKey("nullProportion");
    }

    public void removeNullProportion() {
        this._map.remove("nullProportion");
    }

    @Nullable
    public Float getNullProportion(GetMode mode) {
        return this.getNullProportion();
    }

    @Nullable
    public Float getNullProportion() {
        if (this._nullProportionField != null) {
            return this._nullProportionField;
        }
        Object __rawValue = this._map.get("nullProportion");
        this._nullProportionField = DataTemplateUtil.coerceFloatOutput(__rawValue);
        return this._nullProportionField;
    }

    public DatasetFieldProfile setNullProportion(@Nullable Float value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNullProportion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNullProportion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nullProportion", DataTemplateUtil.coerceFloatInput(value));
                this._nullProportionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nullProportion", DataTemplateUtil.coerceFloatInput(value));
                this._nullProportionField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setNullProportion(@Nonnull Float value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nullProportion of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nullProportion", DataTemplateUtil.coerceFloatInput(value));
        this._nullProportionField = value;
        return this;
    }

    public DatasetFieldProfile setNullProportion(float value) {
        CheckedUtil.putWithoutChecking(this._map, "nullProportion", DataTemplateUtil.coerceFloatInput(Float.valueOf(value)));
        this._nullProportionField = Float.valueOf(value);
        return this;
    }

    public boolean hasMin() {
        if (this._minField != null) {
            return true;
        }
        return this._map.containsKey("min");
    }

    public void removeMin() {
        this._map.remove("min");
    }

    @Nullable
    public String getMin(GetMode mode) {
        return this.getMin();
    }

    @Nullable
    public String getMin() {
        if (this._minField != null) {
            return this._minField;
        }
        Object __rawValue = this._map.get("min");
        this._minField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._minField;
    }

    public DatasetFieldProfile setMin(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMin(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMin();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "min", value);
                this._minField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "min", value);
                this._minField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setMin(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field min of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "min", value);
        this._minField = value;
        return this;
    }

    public boolean hasMax() {
        if (this._maxField != null) {
            return true;
        }
        return this._map.containsKey("max");
    }

    public void removeMax() {
        this._map.remove("max");
    }

    @Nullable
    public String getMax(GetMode mode) {
        return this.getMax();
    }

    @Nullable
    public String getMax() {
        if (this._maxField != null) {
            return this._maxField;
        }
        Object __rawValue = this._map.get("max");
        this._maxField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._maxField;
    }

    public DatasetFieldProfile setMax(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMax(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMax();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "max", value);
                this._maxField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "max", value);
                this._maxField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setMax(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field max of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "max", value);
        this._maxField = value;
        return this;
    }

    public boolean hasMean() {
        if (this._meanField != null) {
            return true;
        }
        return this._map.containsKey("mean");
    }

    public void removeMean() {
        this._map.remove("mean");
    }

    @Nullable
    public String getMean(GetMode mode) {
        return this.getMean();
    }

    @Nullable
    public String getMean() {
        if (this._meanField != null) {
            return this._meanField;
        }
        Object __rawValue = this._map.get("mean");
        this._meanField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._meanField;
    }

    public DatasetFieldProfile setMean(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMean(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMean();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "mean", value);
                this._meanField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "mean", value);
                this._meanField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setMean(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field mean of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "mean", value);
        this._meanField = value;
        return this;
    }

    public boolean hasMedian() {
        if (this._medianField != null) {
            return true;
        }
        return this._map.containsKey("median");
    }

    public void removeMedian() {
        this._map.remove("median");
    }

    @Nullable
    public String getMedian(GetMode mode) {
        return this.getMedian();
    }

    @Nullable
    public String getMedian() {
        if (this._medianField != null) {
            return this._medianField;
        }
        Object __rawValue = this._map.get("median");
        this._medianField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._medianField;
    }

    public DatasetFieldProfile setMedian(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMedian(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMedian();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "median", value);
                this._medianField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "median", value);
                this._medianField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setMedian(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field median of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "median", value);
        this._medianField = value;
        return this;
    }

    public boolean hasStdev() {
        if (this._stdevField != null) {
            return true;
        }
        return this._map.containsKey("stdev");
    }

    public void removeStdev() {
        this._map.remove("stdev");
    }

    @Nullable
    public String getStdev(GetMode mode) {
        return this.getStdev();
    }

    @Nullable
    public String getStdev() {
        if (this._stdevField != null) {
            return this._stdevField;
        }
        Object __rawValue = this._map.get("stdev");
        this._stdevField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._stdevField;
    }

    public DatasetFieldProfile setStdev(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStdev(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStdev();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "stdev", value);
                this._stdevField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "stdev", value);
                this._stdevField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setStdev(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field stdev of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "stdev", value);
        this._stdevField = value;
        return this;
    }

    public boolean hasQuantiles() {
        if (this._quantilesField != null) {
            return true;
        }
        return this._map.containsKey("quantiles");
    }

    public void removeQuantiles() {
        this._map.remove("quantiles");
    }

    @Nullable
    public QuantileArray getQuantiles(GetMode mode) {
        return this.getQuantiles();
    }

    @Nullable
    public QuantileArray getQuantiles() {
        if (this._quantilesField != null) {
            return this._quantilesField;
        }
        Object __rawValue = this._map.get("quantiles");
        this._quantilesField = __rawValue == null ? null : new QuantileArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._quantilesField;
    }

    public DatasetFieldProfile setQuantiles(@Nullable QuantileArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQuantiles(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQuantiles();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "quantiles", value.data());
                this._quantilesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "quantiles", value.data());
                this._quantilesField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setQuantiles(@Nonnull QuantileArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field quantiles of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "quantiles", value.data());
        this._quantilesField = value;
        return this;
    }

    public boolean hasDistinctValueFrequencies() {
        if (this._distinctValueFrequenciesField != null) {
            return true;
        }
        return this._map.containsKey("distinctValueFrequencies");
    }

    public void removeDistinctValueFrequencies() {
        this._map.remove("distinctValueFrequencies");
    }

    @Nullable
    public ValueFrequencyArray getDistinctValueFrequencies(GetMode mode) {
        return this.getDistinctValueFrequencies();
    }

    @Nullable
    public ValueFrequencyArray getDistinctValueFrequencies() {
        if (this._distinctValueFrequenciesField != null) {
            return this._distinctValueFrequenciesField;
        }
        Object __rawValue = this._map.get("distinctValueFrequencies");
        this._distinctValueFrequenciesField = __rawValue == null ? null : new ValueFrequencyArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._distinctValueFrequenciesField;
    }

    public DatasetFieldProfile setDistinctValueFrequencies(@Nullable ValueFrequencyArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDistinctValueFrequencies(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDistinctValueFrequencies();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "distinctValueFrequencies", value.data());
                this._distinctValueFrequenciesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "distinctValueFrequencies", value.data());
                this._distinctValueFrequenciesField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setDistinctValueFrequencies(@Nonnull ValueFrequencyArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field distinctValueFrequencies of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "distinctValueFrequencies", value.data());
        this._distinctValueFrequenciesField = value;
        return this;
    }

    public boolean hasHistogram() {
        if (this._histogramField != null) {
            return true;
        }
        return this._map.containsKey("histogram");
    }

    public void removeHistogram() {
        this._map.remove("histogram");
    }

    @Nullable
    public Histogram getHistogram(GetMode mode) {
        return this.getHistogram();
    }

    @Nullable
    public Histogram getHistogram() {
        if (this._histogramField != null) {
            return this._histogramField;
        }
        Object __rawValue = this._map.get("histogram");
        this._histogramField = __rawValue == null ? null : new Histogram(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._histogramField;
    }

    public DatasetFieldProfile setHistogram(@Nullable Histogram value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHistogram(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHistogram();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "histogram", value.data());
                this._histogramField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "histogram", value.data());
                this._histogramField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setHistogram(@Nonnull Histogram value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field histogram of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "histogram", value.data());
        this._histogramField = value;
        return this;
    }

    public boolean hasSampleValues() {
        if (this._sampleValuesField != null) {
            return true;
        }
        return this._map.containsKey("sampleValues");
    }

    public void removeSampleValues() {
        this._map.remove("sampleValues");
    }

    @Nullable
    public StringArray getSampleValues(GetMode mode) {
        return this.getSampleValues();
    }

    @Nullable
    public StringArray getSampleValues() {
        if (this._sampleValuesField != null) {
            return this._sampleValuesField;
        }
        Object __rawValue = this._map.get("sampleValues");
        this._sampleValuesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._sampleValuesField;
    }

    public DatasetFieldProfile setSampleValues(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSampleValues(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSampleValues();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sampleValues", value.data());
                this._sampleValuesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sampleValues", value.data());
                this._sampleValuesField = value;
            }
        }
        return this;
    }

    public DatasetFieldProfile setSampleValues(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sampleValues of com.linkedin.dataset.DatasetFieldProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sampleValues", value.data());
        this._sampleValuesField = value;
        return this;
    }

    @Override
    public DatasetFieldProfile clone() throws CloneNotSupportedException {
        DatasetFieldProfile __clone = (DatasetFieldProfile)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetFieldProfile copy() throws CloneNotSupportedException {
        DatasetFieldProfile __copy = (DatasetFieldProfile)super.copy();
        __copy._maxField = null;
        __copy._sampleValuesField = null;
        __copy._distinctValueFrequenciesField = null;
        __copy._nullCountField = null;
        __copy._nullProportionField = null;
        __copy._quantilesField = null;
        __copy._histogramField = null;
        __copy._uniqueProportionField = null;
        __copy._minField = null;
        __copy._medianField = null;
        __copy._meanField = null;
        __copy._fieldPathField = null;
        __copy._stdevField = null;
        __copy._uniqueCountField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetFieldProfile __objectRef;

        private ChangeListener(DatasetFieldProfile reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "max": {
                    this.__objectRef._maxField = null;
                    break;
                }
                case "sampleValues": {
                    this.__objectRef._sampleValuesField = null;
                    break;
                }
                case "distinctValueFrequencies": {
                    this.__objectRef._distinctValueFrequenciesField = null;
                    break;
                }
                case "nullCount": {
                    this.__objectRef._nullCountField = null;
                    break;
                }
                case "nullProportion": {
                    this.__objectRef._nullProportionField = null;
                    break;
                }
                case "quantiles": {
                    this.__objectRef._quantilesField = null;
                    break;
                }
                case "histogram": {
                    this.__objectRef._histogramField = null;
                    break;
                }
                case "uniqueProportion": {
                    this.__objectRef._uniqueProportionField = null;
                    break;
                }
                case "min": {
                    this.__objectRef._minField = null;
                    break;
                }
                case "median": {
                    this.__objectRef._medianField = null;
                    break;
                }
                case "mean": {
                    this.__objectRef._meanField = null;
                    break;
                }
                case "fieldPath": {
                    this.__objectRef._fieldPathField = null;
                    break;
                }
                case "stdev": {
                    this.__objectRef._stdevField = null;
                    break;
                }
                case "uniqueCount": {
                    this.__objectRef._uniqueCountField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec fieldPath() {
            return new PathSpec(this.getPathComponents(), "fieldPath");
        }

        public PathSpec uniqueCount() {
            return new PathSpec(this.getPathComponents(), "uniqueCount");
        }

        public PathSpec uniqueProportion() {
            return new PathSpec(this.getPathComponents(), "uniqueProportion");
        }

        public PathSpec nullCount() {
            return new PathSpec(this.getPathComponents(), "nullCount");
        }

        public PathSpec nullProportion() {
            return new PathSpec(this.getPathComponents(), "nullProportion");
        }

        public PathSpec min() {
            return new PathSpec(this.getPathComponents(), "min");
        }

        public PathSpec max() {
            return new PathSpec(this.getPathComponents(), "max");
        }

        public PathSpec mean() {
            return new PathSpec(this.getPathComponents(), "mean");
        }

        public PathSpec median() {
            return new PathSpec(this.getPathComponents(), "median");
        }

        public PathSpec stdev() {
            return new PathSpec(this.getPathComponents(), "stdev");
        }

        public QuantileArray.Fields quantiles() {
            return new QuantileArray.Fields(this.getPathComponents(), "quantiles");
        }

        public PathSpec quantiles(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "quantiles");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public ValueFrequencyArray.Fields distinctValueFrequencies() {
            return new ValueFrequencyArray.Fields(this.getPathComponents(), "distinctValueFrequencies");
        }

        public PathSpec distinctValueFrequencies(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "distinctValueFrequencies");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public Histogram.Fields histogram() {
            return new Histogram.Fields(this.getPathComponents(), "histogram");
        }

        public PathSpec sampleValues() {
            return new PathSpec(this.getPathComponents(), "sampleValues");
        }

        public PathSpec sampleValues(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "sampleValues");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private QuantileArray.ProjectionMask _quantilesMask;
        private ValueFrequencyArray.ProjectionMask _distinctValueFrequenciesMask;
        private Histogram.ProjectionMask _histogramMask;

        ProjectionMask() {
        }

        public ProjectionMask withFieldPath() {
            this.getDataMap().put("fieldPath", 1);
            return this;
        }

        public ProjectionMask withUniqueCount() {
            this.getDataMap().put("uniqueCount", 1);
            return this;
        }

        public ProjectionMask withUniqueProportion() {
            this.getDataMap().put("uniqueProportion", 1);
            return this;
        }

        public ProjectionMask withNullCount() {
            this.getDataMap().put("nullCount", 1);
            return this;
        }

        public ProjectionMask withNullProportion() {
            this.getDataMap().put("nullProportion", 1);
            return this;
        }

        public ProjectionMask withMin() {
            this.getDataMap().put("min", 1);
            return this;
        }

        public ProjectionMask withMax() {
            this.getDataMap().put("max", 1);
            return this;
        }

        public ProjectionMask withMean() {
            this.getDataMap().put("mean", 1);
            return this;
        }

        public ProjectionMask withMedian() {
            this.getDataMap().put("median", 1);
            return this;
        }

        public ProjectionMask withStdev() {
            this.getDataMap().put("stdev", 1);
            return this;
        }

        public ProjectionMask withQuantiles(Function<QuantileArray.ProjectionMask, QuantileArray.ProjectionMask> nestedMask) {
            this._quantilesMask = nestedMask.apply(this._quantilesMask == null ? QuantileArray.createMask() : this._quantilesMask);
            this.getDataMap().put("quantiles", this._quantilesMask.getDataMap());
            return this;
        }

        public ProjectionMask withQuantiles() {
            this._quantilesMask = null;
            this.getDataMap().put("quantiles", 1);
            return this;
        }

        public ProjectionMask withQuantiles(Function<QuantileArray.ProjectionMask, QuantileArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._quantilesMask = nestedMask.apply(this._quantilesMask == null ? QuantileArray.createMask() : this._quantilesMask);
            this.getDataMap().put("quantiles", this._quantilesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("quantiles").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("quantiles").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withQuantiles(Integer start, Integer count) {
            this._quantilesMask = null;
            this.getDataMap().put("quantiles", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("quantiles").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("quantiles").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDistinctValueFrequencies(Function<ValueFrequencyArray.ProjectionMask, ValueFrequencyArray.ProjectionMask> nestedMask) {
            this._distinctValueFrequenciesMask = nestedMask.apply(this._distinctValueFrequenciesMask == null ? ValueFrequencyArray.createMask() : this._distinctValueFrequenciesMask);
            this.getDataMap().put("distinctValueFrequencies", this._distinctValueFrequenciesMask.getDataMap());
            return this;
        }

        public ProjectionMask withDistinctValueFrequencies() {
            this._distinctValueFrequenciesMask = null;
            this.getDataMap().put("distinctValueFrequencies", 1);
            return this;
        }

        public ProjectionMask withDistinctValueFrequencies(Function<ValueFrequencyArray.ProjectionMask, ValueFrequencyArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._distinctValueFrequenciesMask = nestedMask.apply(this._distinctValueFrequenciesMask == null ? ValueFrequencyArray.createMask() : this._distinctValueFrequenciesMask);
            this.getDataMap().put("distinctValueFrequencies", this._distinctValueFrequenciesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("distinctValueFrequencies").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("distinctValueFrequencies").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDistinctValueFrequencies(Integer start, Integer count) {
            this._distinctValueFrequenciesMask = null;
            this.getDataMap().put("distinctValueFrequencies", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("distinctValueFrequencies").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("distinctValueFrequencies").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withHistogram(Function<Histogram.ProjectionMask, Histogram.ProjectionMask> nestedMask) {
            this._histogramMask = nestedMask.apply(this._histogramMask == null ? Histogram.createMask() : this._histogramMask);
            this.getDataMap().put("histogram", this._histogramMask.getDataMap());
            return this;
        }

        public ProjectionMask withHistogram() {
            this._histogramMask = null;
            this.getDataMap().put("histogram", 1);
            return this;
        }

        public ProjectionMask withSampleValues() {
            this.getDataMap().put("sampleValues", 1);
            return this;
        }

        public ProjectionMask withSampleValues(Integer start, Integer count) {
            this.getDataMap().put("sampleValues", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("sampleValues").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("sampleValues").put("$count", count);
            }
            return this;
        }
    }
}

