/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.ByteString;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.TemplateOutputCastException;

public abstract class FixedTemplate
implements DataTemplate<ByteString> {
    protected final FixedDataSchema _schema;
    protected final ByteString _data;

    protected FixedTemplate(Object object, FixedDataSchema schema) throws TemplateOutputCastException {
        Class<?> objectClass = object.getClass();
        if (objectClass == String.class) {
            String data = (String)object;
            if (data.length() != schema.getSize()) {
                throw new TemplateOutputCastException("Fixed size is " + schema.getSize() + ", string length is " + data.length());
            }
            this._schema = schema;
            this._data = ByteString.copyAvroString(data, true);
            if (this._data == null) {
                throw new TemplateOutputCastException("String is not a valid representation of bytes");
            }
        } else if (objectClass == ByteString.class) {
            ByteString bytes = (ByteString)object;
            if (bytes.length() != schema.getSize()) {
                throw new TemplateOutputCastException("Fixed size is " + schema.getSize() + ", ByteString length is " + bytes.length());
            }
            this._schema = schema;
            this._data = bytes;
        } else {
            throw new TemplateOutputCastException("Fixed input " + object + " is not a string or ByteString");
        }
    }

    public ByteString bytes() {
        return this._data;
    }

    @Override
    public FixedDataSchema schema() {
        return this._schema;
    }

    @Override
    public ByteString data() {
        return this._data;
    }

    public FixedTemplate clone() throws CloneNotSupportedException {
        FixedTemplate clone = (FixedTemplate)super.clone();
        return clone;
    }

    public FixedTemplate copy() throws CloneNotSupportedException {
        return this.clone();
    }

    public int hashCode() {
        return this._data.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof FixedTemplate) {
            return this._data.equals(((FixedTemplate)object)._data);
        }
        return false;
    }

    public String toString() {
        return this._data.toString();
    }
}

