/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.NamedDataSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class UnionDataSchema
extends ComplexDataSchema {
    private boolean isPartialSchema = false;
    private List<Member> _members = Collections.emptyList();
    private Map<String, Integer> _memberKeyToIndexMap = _emptyTypesToIndexMap;
    private boolean _membersAliased = false;
    private static final Map<String, Integer> _emptyTypesToIndexMap = Collections.emptyMap();

    public UnionDataSchema() {
        super(DataSchema.Type.UNION);
    }

    public boolean setMembers(List<Member> members, StringBuilder errorMessageBuilder) {
        boolean ok = true;
        HashSet<String> avroMemberKeys = new HashSet<String>(members.size());
        HashMap<String, Integer> memberKeyMap = new HashMap<String, Integer>(members.size());
        Optional<Boolean> areMembersAliased = Optional.empty();
        int index = 0;
        for (Member member : members) {
            Integer existing;
            DataSchema memberType = member.getType();
            boolean memberHasAlias = member.hasAlias();
            if (memberType.getDereferencedType() != DataSchema.Type.NULL) {
                if (!areMembersAliased.isPresent()) {
                    areMembersAliased = Optional.of(memberHasAlias);
                } else if ((Boolean)areMembersAliased.get() != memberHasAlias) {
                    errorMessageBuilder.append("Union definition should have aliases specified for either all or zero members.\n");
                    ok = false;
                }
            } else if (memberHasAlias) {
                errorMessageBuilder.append(memberType).append(" member should not have an alias.\n");
                ok = false;
            }
            if (memberType.getDereferencedType() == DataSchema.Type.UNION) {
                errorMessageBuilder.append(memberType).append(" union cannot be inside another union.\n");
                ok = false;
            }
            if ((existing = memberKeyMap.put(member.getUnionMemberKey(), index)) != null) {
                errorMessageBuilder.append(memberHasAlias ? "alias " : "").append(member.getUnionMemberKey()).append(" appears more than once in a union.\n");
                ok = false;
            } else {
                String avroMemberKey = UnionDataSchema.avroUnionMemberKey(memberType);
                boolean unique = avroMemberKeys.add(avroMemberKey);
                if (!unique && !memberHasAlias) {
                    errorMessageBuilder.append(memberType).append(" has name ").append(avroMemberKey).append(" that appears more than once in a union, this may cause compatibility problems with Avro.\n");
                    ok = false;
                }
            }
            ++index;
        }
        this._members = Collections.unmodifiableList(members);
        this._memberKeyToIndexMap = Collections.unmodifiableMap(memberKeyMap);
        this._membersAliased = areMembersAliased.orElse(false);
        if (!ok) {
            this.setHasError();
        }
        return ok;
    }

    public List<Member> getMembers() {
        return this._members;
    }

    public boolean contains(String memberKey) {
        return this._memberKeyToIndexMap.containsKey(memberKey);
    }

    @Deprecated
    public DataSchema getType(String memberKey) {
        return this.getTypeByMemberKey(memberKey);
    }

    public DataSchema getTypeByMemberKey(String memberKey) {
        Integer index = this._memberKeyToIndexMap.get(memberKey);
        return index != null ? this._members.get(index).getType() : null;
    }

    public Member getMemberByMemberKey(String memberKey) {
        Integer index = this._memberKeyToIndexMap.get(memberKey);
        return index != null ? this._members.get(index) : null;
    }

    public boolean areMembersAliased() {
        return this._membersAliased;
    }

    @Override
    public String getUnionMemberKey() {
        return "union";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == UnionDataSchema.class) {
            UnionDataSchema other = (UnionDataSchema)object;
            return super.equals(other) && this._members.equals(other._members);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._members.hashCode();
    }

    public static String avroUnionMemberKey(DataSchema schema) {
        DataSchema dereferencedSchema = schema.getDereferencedDataSchema();
        String name = dereferencedSchema instanceof NamedDataSchema ? ((NamedDataSchema)dereferencedSchema).getName() : dereferencedSchema.getUnionMemberKey();
        return name;
    }

    public void setPartialSchema(boolean partialSchema) {
        this.isPartialSchema = partialSchema;
    }

    public boolean isPartialSchema() {
        return this.isPartialSchema;
    }

    public static class Member
    implements Cloneable {
        private String _alias = null;
        private DataSchema _type = DataSchemaConstants.NULL_DATA_SCHEMA;
        private String _doc = "";
        private Map<String, Object> _properties = Collections.emptyMap();
        private boolean _declaredInline = false;
        private boolean _hasError = false;

        public Member(DataSchema type) {
            this.setType(type);
        }

        public boolean setAlias(String alias, StringBuilder errorMessageBuilder) {
            boolean ok = true;
            if (!DataSchemaConstants.FIELD_NAME_PATTERN.matcher(alias).matches()) {
                errorMessageBuilder.append("\"").append(alias).append("\" is an invalid member alias.\n");
                ok = false;
            } else if (DataSchemaConstants.RESTRICTED_UNION_ALIASES.contains(alias)) {
                errorMessageBuilder.append("\"").append(alias).append("\" is restricted keyword for a member alias.\n");
                ok = false;
            }
            this._alias = alias;
            this._hasError |= !ok;
            return ok;
        }

        public void setType(DataSchema type) {
            if (type == null) {
                this._type = DataSchemaConstants.NULL_DATA_SCHEMA;
                this._hasError = true;
            } else {
                this._type = type;
            }
        }

        public void setDoc(String documentation) {
            this._doc = documentation;
        }

        public void setProperties(Map<String, Object> properties) {
            this._properties = Collections.unmodifiableMap(properties);
        }

        public void setDeclaredInline(boolean declaredInline) {
            this._declaredInline = declaredInline;
        }

        public String getAlias() {
            return this._alias;
        }

        public DataSchema getType() {
            return this._type;
        }

        public String getDoc() {
            return this._doc;
        }

        public Map<String, Object> getProperties() {
            return this._properties;
        }

        public boolean isDeclaredInline() {
            return this._declaredInline;
        }

        public boolean hasAlias() {
            return this._alias != null;
        }

        public String getUnionMemberKey() {
            return this.hasAlias() ? this._alias : this._type.getUnionMemberKey();
        }

        public boolean hasError() {
            return this._hasError;
        }

        public boolean equals(Object object) {
            boolean result = false;
            if (this == object) {
                result = true;
            } else if (object != null && object.getClass() == Member.class) {
                Member other = (Member)object;
                result = (this._alias == null ? other._alias == null : this._alias.equals(other._alias)) && this._type.equals(other._type) && this._doc.equals(other._doc) && this._properties.equals(other._properties) && this._hasError == other._hasError;
            }
            return result;
        }

        public int hashCode() {
            return this._alias == null ? 0 : this._alias.hashCode() ^ this._type.hashCode() ^ this._doc.hashCode() ^ this._properties.hashCode() ^ (this._hasError ? -1431655766 : 0x55555555);
        }

        public Member clone() throws CloneNotSupportedException {
            return (Member)super.clone();
        }
    }
}

