/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.symbol;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.codec.DataCodec;
import com.linkedin.data.codec.symbol.InMemorySymbolTable;
import com.linkedin.data.codec.symbol.SymbolTable;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;

public class SymbolTableSerializer {
    private SymbolTableSerializer() {
    }

    public static SymbolTable fromByteString(ByteString byteString, DataCodec codec) throws IOException {
        return SymbolTableSerializer.fromByteString(byteString, codec, null);
    }

    public static SymbolTable fromByteString(ByteString byteString, DataCodec codec, Function<String, String> symbolTableRenamer) throws IOException {
        return SymbolTableSerializer.fromInputStream(byteString.asInputStream(), codec, symbolTableRenamer);
    }

    public static SymbolTable fromInputStream(InputStream inputStream, DataCodec codec, Function<String, String> symbolTableRenamer) throws IOException {
        DataList dataList = codec.readList(inputStream);
        String symbolTableName = (String)dataList.get(0);
        if (symbolTableRenamer != null) {
            symbolTableName = symbolTableRenamer.apply(symbolTableName);
        }
        return new InMemorySymbolTable(symbolTableName, dataList.subList(1, dataList.size()));
    }

    public static ByteString toByteString(DataCodec codec, SymbolTable symbolTable) throws IOException {
        DataList dataList = new DataList(symbolTable.size() + 1);
        dataList.add(symbolTable.getName());
        for (int i = 0; i < symbolTable.size(); ++i) {
            dataList.add(symbolTable.getSymbolName(i));
        }
        return ByteString.unsafeWrap(codec.listToBytes(dataList));
    }
}

