/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.entitystream.JacksonLICORDataDecoder;
import com.linkedin.data.codec.entitystream.JacksonLICORDataEncoder;
import com.linkedin.data.codec.entitystream.StreamDataCodec;
import com.linkedin.data.codec.symbol.SymbolTable;
import com.linkedin.entitystream.EntityStream;
import com.linkedin.entitystream.EntityStreams;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.dataformat.smile.SmileFactory;
import datahub.shaded.jackson.dataformat.smile.SmileGenerator;
import java.util.concurrent.CompletionStage;

public class JacksonLICORStreamDataCodec
implements StreamDataCodec {
    private static final JsonFactory TEXT_FACTORY = new JsonFactory();
    private static final JsonFactory BINARY_FACTORY = new SmileFactory().enable(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES);
    static final byte MAP_ORDINAL = 0;
    static final byte LIST_ORDINAL = 1;
    protected final int _bufferSize;
    protected final boolean _useBinary;
    protected final SymbolTable _symbolTable;

    public JacksonLICORStreamDataCodec(int bufferSize, boolean useBinary) {
        this(bufferSize, useBinary, (SymbolTable)null);
    }

    public JacksonLICORStreamDataCodec(int bufferSize, boolean useBinary, SymbolTable symbolTable) {
        this._bufferSize = bufferSize;
        this._useBinary = useBinary;
        this._symbolTable = symbolTable;
    }

    @Deprecated
    public JacksonLICORStreamDataCodec(int bufferSize, boolean useBinary, String symbolTableName) {
        this(bufferSize, useBinary);
    }

    @Override
    public CompletionStage<DataMap> decodeMap(EntityStream<ByteString> entityStream) {
        JacksonLICORDataDecoder decoder = new JacksonLICORDataDecoder(this._useBinary, false, this._symbolTable);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public CompletionStage<DataList> decodeList(EntityStream<ByteString> entityStream) {
        JacksonLICORDataDecoder decoder = new JacksonLICORDataDecoder(this._useBinary, true, this._symbolTable);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public EntityStream<ByteString> encodeMap(DataMap map) {
        JacksonLICORDataEncoder encoder = new JacksonLICORDataEncoder(map, this._bufferSize, this._useBinary, this._symbolTable);
        return EntityStreams.newEntityStream(encoder);
    }

    @Override
    public EntityStream<ByteString> encodeList(DataList list) {
        JacksonLICORDataEncoder encoder = new JacksonLICORDataEncoder(list, this._bufferSize, this._useBinary, this._symbolTable);
        return EntityStreams.newEntityStream(encoder);
    }

    static JsonFactory getFactory(boolean encodeBinary) {
        return encodeBinary ? BINARY_FACTORY : TEXT_FACTORY;
    }
}

