/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.entitystream.DataDecoder;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.parser.NonBlockingDataParser;
import com.linkedin.entitystream.ReadHandle;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class AbstractDataDecoder<T extends DataComplex>
implements DataDecoder<T> {
    private static final EnumSet<NonBlockingDataParser.Token> SIMPLE_VALUE = EnumSet.of(NonBlockingDataParser.Token.STRING, new NonBlockingDataParser.Token[]{NonBlockingDataParser.Token.RAW_BYTES, NonBlockingDataParser.Token.INTEGER, NonBlockingDataParser.Token.LONG, NonBlockingDataParser.Token.FLOAT, NonBlockingDataParser.Token.DOUBLE, NonBlockingDataParser.Token.BOOL_TRUE, NonBlockingDataParser.Token.BOOL_FALSE, NonBlockingDataParser.Token.NULL});
    private static final EnumSet<NonBlockingDataParser.Token> FIELD_NAME = EnumSet.of(NonBlockingDataParser.Token.STRING);
    private static final EnumSet<NonBlockingDataParser.Token> VALUE = EnumSet.of(NonBlockingDataParser.Token.START_OBJECT, NonBlockingDataParser.Token.START_ARRAY);
    private static final EnumSet<NonBlockingDataParser.Token> NEXT_OBJECT_FIELD = EnumSet.of(NonBlockingDataParser.Token.END_OBJECT);
    private static final EnumSet<NonBlockingDataParser.Token> NEXT_ARRAY_ITEM = EnumSet.of(NonBlockingDataParser.Token.END_ARRAY);
    protected static final EnumSet<NonBlockingDataParser.Token> NONE = EnumSet.noneOf(NonBlockingDataParser.Token.class);
    protected static final EnumSet<NonBlockingDataParser.Token> START_TOKENS = EnumSet.of(NonBlockingDataParser.Token.START_OBJECT, NonBlockingDataParser.Token.START_ARRAY);
    public static final EnumSet<NonBlockingDataParser.Token> START_ARRAY_TOKEN = EnumSet.of(NonBlockingDataParser.Token.START_ARRAY);
    public static final EnumSet<NonBlockingDataParser.Token> START_OBJECT_TOKEN = EnumSet.of(NonBlockingDataParser.Token.START_OBJECT);
    private final CompletableFuture<T> _completable = new CompletableFuture();
    private T _result = null;
    private ReadHandle _readHandle;
    private NonBlockingDataParser _parser;
    private final Deque<DataComplex> _stack = new ArrayDeque<DataComplex>();
    private final Deque<String> _currFieldStack = new ArrayDeque<String>();
    private String _currField;
    private boolean _isCurrList;
    private ByteString _currentChunk;
    private int _currentChunkIndex = -1;
    protected EnumSet<NonBlockingDataParser.Token> _expectedTokens;

    protected AbstractDataDecoder(EnumSet<NonBlockingDataParser.Token> expectedFirstTokens) {
        this._expectedTokens = expectedFirstTokens;
    }

    protected AbstractDataDecoder() {
        this(START_TOKENS);
    }

    @Override
    public void onInit(ReadHandle rh) {
        this._readHandle = rh;
        try {
            this._parser = this.createDataParser();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        this._readHandle.request(1);
    }

    protected abstract NonBlockingDataParser createDataParser() throws IOException;

    @Override
    public void onDataAvailable(ByteString data) {
        this._currentChunk = data;
        this._currentChunkIndex = 0;
        this.processCurrentChunk();
    }

    private void readNextChunk() {
        if (this._currentChunkIndex == -1) {
            this._readHandle.request(1);
            return;
        }
        this.processCurrentChunk();
    }

    private void processCurrentChunk() {
        try {
            this._currentChunkIndex = this._currentChunk.feed(this._parser, this._currentChunkIndex);
            this.processTokens();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    private void processTokens() {
        try {
            NonBlockingDataParser.Token token;
            block17: while ((token = this._parser.nextToken()) != NonBlockingDataParser.Token.EOF_INPUT) {
                this.validate(token);
                switch (token) {
                    case START_OBJECT: {
                        this.push(this.createDataObject(this._parser), false);
                        continue block17;
                    }
                    case START_ARRAY: {
                        this.push(this.createDataList(this._parser), true);
                        continue block17;
                    }
                    case END_OBJECT: 
                    case END_ARRAY: {
                        this.pop();
                        continue block17;
                    }
                    case STRING: {
                        if (!this._isCurrList && this._currField == null) {
                            this._currField = this._parser.getString();
                            this._expectedTokens = VALUE;
                            continue block17;
                        }
                        this.addValue(this._parser.getString());
                        continue block17;
                    }
                    case RAW_BYTES: {
                        this.addValue(this._parser.getRawBytes());
                        continue block17;
                    }
                    case INTEGER: {
                        this.addValue(this._parser.getIntValue());
                        continue block17;
                    }
                    case LONG: {
                        this.addValue(this._parser.getLongValue());
                        continue block17;
                    }
                    case FLOAT: {
                        this.addValue(Float.valueOf(this._parser.getFloatValue()));
                        continue block17;
                    }
                    case DOUBLE: {
                        this.addValue(this._parser.getDoubleValue());
                        continue block17;
                    }
                    case BOOL_TRUE: {
                        this.addValue(Boolean.TRUE);
                        continue block17;
                    }
                    case BOOL_FALSE: {
                        this.addValue(Boolean.FALSE);
                        continue block17;
                    }
                    case NULL: {
                        this.addValue(Data.NULL);
                        continue block17;
                    }
                    case NOT_AVAILABLE: {
                        this.readNextChunk();
                        return;
                    }
                }
                this.handleException(new Exception("Unexpected token " + (Object)((Object)token) + " from data parser"));
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected abstract DataComplex createDataObject(NonBlockingDataParser var1);

    protected abstract DataComplex createDataList(NonBlockingDataParser var1);

    protected final boolean isCurrList() {
        return this._isCurrList;
    }

    protected final void validate(NonBlockingDataParser.Token token) {
        if (token != NonBlockingDataParser.Token.NOT_AVAILABLE && !this._expectedTokens.contains((Object)token)) {
            this.handleException(new Exception("Expecting " + this._expectedTokens + " but got " + (Object)((Object)token)));
        }
    }

    private void push(DataComplex dataComplex, boolean isList) {
        if (!this._isCurrList && !this._stack.isEmpty()) {
            this._currFieldStack.push(this._currField);
            this._currField = null;
        }
        this._stack.push(dataComplex);
        this._isCurrList = isList;
        this.updateExpected();
    }

    private void pop() {
        assert (!this._stack.isEmpty()) : "Trying to pop empty stack";
        DataComplex tmp = this._stack.pop();
        tmp = this.postProcessDataComplex(tmp);
        if (this._stack.isEmpty()) {
            this._result = tmp;
            this._expectedTokens = NONE;
        } else {
            this._isCurrList = this._stack.peek() instanceof DataList;
            if (!this._isCurrList) {
                this._currField = this._currFieldStack.pop();
            }
            this.addValue(tmp);
            this.updateExpected();
        }
    }

    protected DataComplex postProcessDataComplex(DataComplex dataComplex) {
        return dataComplex;
    }

    protected void addValue(Object value) {
        if (!this._stack.isEmpty()) {
            DataComplex currItem = this._stack.peek();
            if (this._isCurrList) {
                CheckedUtil.addWithoutChecking((DataList)currItem, value);
            } else {
                this.addEntryToDataObject(currItem, this._currField, value);
                this._currField = null;
            }
            this.updateExpected();
        }
    }

    protected void addEntryToDataObject(DataComplex dataObject, String currField, Object currValue) {
        CheckedUtil.putWithoutChecking((DataMap)dataObject, currField, currValue);
    }

    protected final void replaceObjectStackTop(DataComplex dataComplex) {
        this._stack.pop();
        this._stack.push(dataComplex);
    }

    protected void updateExpected() {
        this._expectedTokens = this._isCurrList ? NEXT_ARRAY_ITEM : NEXT_OBJECT_FIELD;
    }

    @Override
    public void onDone() {
        this._parser.endOfInput();
        this.processTokens();
        if (this._stack.isEmpty()) {
            this._completable.complete(this._result);
        } else {
            this.handleException(new Exception("Unexpected end of source"));
        }
    }

    @Override
    public void onError(Throwable e) {
        this._completable.completeExceptionally(e);
    }

    @Override
    public CompletionStage<T> getResult() {
        return this._completable;
    }

    protected void handleException(Throwable e) {
        this._readHandle.cancel();
        this._completable.completeExceptionally(e);
    }

    static {
        VALUE.addAll(SIMPLE_VALUE);
        NEXT_OBJECT_FIELD.addAll(FIELD_NAME);
        NEXT_ARRAY_ITEM.addAll(VALUE);
    }
}

