/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.AbstractJacksonDataCodec;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.codec.TextDataCodec;
import datahub.shaded.jackson.core.JsonEncoding;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.PrettyPrinter;
import datahub.shaded.jackson.core.util.Instantiatable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class JacksonDataCodec
extends AbstractJacksonDataCodec
implements TextDataCodec {
    protected boolean _allowComments;
    protected PrettyPrinter _prettyPrinter;
    protected JsonEncoding _jsonEncoding = JsonEncoding.UTF8;

    public JacksonDataCodec() {
        this(JSON_FACTORY);
    }

    public JacksonDataCodec(JsonFactory jsonFactory) {
        super(jsonFactory);
        this.setAllowComments(true);
    }

    public void setAllowComments(boolean allowComments) {
        this._factory.configure(JsonParser.Feature.ALLOW_COMMENTS, allowComments);
        this._allowComments = allowComments;
    }

    private PrettyPrinter getPrettyPrinter() {
        return this._prettyPrinter instanceof Instantiatable ? (PrettyPrinter)((Instantiatable)((Object)this._prettyPrinter)).createInstance() : this._prettyPrinter;
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._prettyPrinter = prettyPrinter;
    }

    @Override
    public String getStringEncoding() {
        return this._jsonEncoding.getJavaName();
    }

    @Override
    public String mapToString(DataMap map) throws IOException {
        return this.objectToString(map);
    }

    @Override
    public String listToString(DataList list) throws IOException {
        return this.objectToString(list);
    }

    protected String objectToString(Object object) throws IOException {
        StringWriter out = new StringWriter(4096);
        this.writeObject(object, this.createJsonGenerator(out));
        return out.toString();
    }

    @Override
    protected JsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        JsonGenerator generator = this._factory.createGenerator(out);
        if (this._prettyPrinter != null) {
            generator.setPrettyPrinter(this.getPrettyPrinter());
        }
        return generator;
    }

    @Override
    protected JsonGenerator createJsonGenerator(Writer out) throws IOException {
        JsonGenerator generator = this._factory.createGenerator(out);
        if (this._prettyPrinter != null) {
            generator.setPrettyPrinter(this.getPrettyPrinter());
        }
        return generator;
    }

    @Override
    public DataMap stringToMap(String input) throws IOException {
        return this.parse(this._factory.createParser(input), DataMap.class);
    }

    @Override
    public DataList stringToList(String input) throws IOException {
        return this.parse(this._factory.createParser(input), DataList.class);
    }

    @Override
    public void writeMap(DataMap map, Writer out) throws IOException {
        this.writeObject(map, this.createJsonGenerator(out));
    }

    @Override
    public void writeList(DataList list, Writer out) throws IOException {
        this.writeObject(list, this.createJsonGenerator(out));
    }

    @Override
    public DataMap readMap(Reader in) throws IOException {
        return this.parse(this._factory.createParser(in), DataMap.class);
    }

    @Override
    public DataList readList(Reader in) throws IOException {
        return this.parse(this._factory.createParser(in), DataList.class);
    }

    public List<Object> parse(Reader in, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws IOException {
        return this.parse(this._factory.createParser(in), mesg, locationMap);
    }
}

