/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.DataMapBuilder;
import com.linkedin.data.codec.DataCodec;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.codec.DataEncodingException;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.util.FastByteArrayOutputStream;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonLocation;
import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractJacksonDataCodec
implements DataCodec {
    public static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
    protected static final int DEFAULT_BUFFER_SIZE = 4096;
    protected final JsonFactory _factory;
    private boolean _sortKeys;

    protected AbstractJacksonDataCodec(JsonFactory factory) {
        this._factory = factory;
    }

    public void setSortKeys(boolean sortKeys) {
        this._sortKeys = sortKeys;
    }

    @Override
    public byte[] mapToBytes(DataMap map) throws IOException {
        return this.objectToBytes(map);
    }

    @Override
    public byte[] listToBytes(DataList list) throws IOException {
        return this.objectToBytes(list);
    }

    protected byte[] objectToBytes(Object object) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(4096);
        this.writeObject(object, this.createJsonGenerator(out));
        return out.toByteArray();
    }

    @Override
    public DataMap bytesToMap(byte[] input) throws IOException {
        return this.parse(this._factory.createParser(input), DataMap.class);
    }

    @Override
    public DataList bytesToList(byte[] input) throws IOException {
        return this.parse(this._factory.createParser(input), DataList.class);
    }

    @Override
    public void writeMap(DataMap map, OutputStream out) throws IOException {
        this.writeObject(map, this.createJsonGenerator(out));
    }

    @Override
    public void writeList(DataList list, OutputStream out) throws IOException {
        this.writeObject(list, this.createJsonGenerator(out));
    }

    protected JsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        return this._factory.createGenerator(out);
    }

    protected JsonGenerator createJsonGenerator(Writer out) throws IOException {
        return this._factory.createGenerator(out);
    }

    protected void writeObject(Object object, JsonGenerator generator) throws IOException {
        try (Data.TraverseCallback callback = this.createTraverseCallback(generator);){
            Data.traverse(object, callback);
        }
    }

    protected Data.TraverseCallback createTraverseCallback(JsonGenerator generator) {
        return this.createTraverseCallback(generator, this._sortKeys);
    }

    protected Data.TraverseCallback createTraverseCallback(JsonGenerator generator, boolean traverseMapBySortedKeyOrder) {
        return new JacksonTraverseCallback(generator, traverseMapBySortedKeyOrder);
    }

    @Override
    public DataMap readMap(InputStream in) throws IOException {
        return this.parse(this._factory.createParser(in), DataMap.class);
    }

    @Override
    public DataList readList(InputStream in) throws IOException {
        return this.parse(this._factory.createParser(in), DataList.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DataComplex> T parse(JsonParser jsonParser, Class<T> expectType) throws IOException {
        try {
            T t2 = new Parser().parse(jsonParser, expectType);
            return t2;
        }
        finally {
            DataCodec.closeQuietly(jsonParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> parse(JsonParser jsonParser, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws IOException {
        try {
            List<Object> list = new Parser(true).parse(jsonParser, mesg, locationMap);
            return list;
        }
        finally {
            DataCodec.closeQuietly(jsonParser);
        }
    }

    public List<Object> parse(InputStream in, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws IOException {
        return this.parse(this._factory.createParser(in), mesg, locationMap);
    }

    public void objectToJsonGenerator(Object object, JsonGenerator generator) throws IOException {
        this.objectToJsonGenerator(object, generator, false);
    }

    public void objectToJsonGenerator(Object object, JsonGenerator generator, boolean orderMapByKey) throws IOException {
        Data.TraverseCallback callback = this.createTraverseCallback(generator, orderMapByKey);
        Data.traverse(object, callback);
    }

    private static class Location
    implements DataLocation {
        private final JsonLocation _location;

        private Location(JsonLocation location) {
            this._location = location;
        }

        public int getColumn() {
            return this._location.getColumnNr();
        }

        public int getLine() {
            return this._location.getLineNr();
        }

        @Override
        public int compareTo(DataLocation other) {
            return (int)(this._location.getCharOffset() - ((Location)other)._location.getCharOffset());
        }

        public String toString() {
            return this.getLine() + "," + this.getColumn();
        }
    }

    private static class Parser {
        private static final int MAX_DATA_MAP_RECURSION_SIZE = 6;
        private StringBuilder _errorBuilder = null;
        private JsonParser _parser = null;
        private boolean _debug = false;
        private Deque<Object> _nameStack = null;
        private Map<Object, DataLocation> _locationMap = null;

        Parser() {
            this(false);
        }

        Parser(boolean debug) {
            this._debug = debug;
        }

        private Map<DataLocation, Object> sortedLocationsMap() {
            if (this._locationMap == null) {
                return null;
            }
            TreeMap<DataLocation, Object> sortedMap = new TreeMap<DataLocation, Object>();
            for (Map.Entry<Object, DataLocation> e : this._locationMap.entrySet()) {
                sortedMap.put(e.getValue(), e.getKey());
            }
            return sortedMap;
        }

        List<Object> parse(JsonParser parser, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws IOException {
            JsonToken token;
            this._locationMap = locationMap;
            DataList list = new DataList();
            this._errorBuilder = mesg;
            if (this._debug) {
                this._nameStack = new ArrayDeque<Object>();
            }
            this._parser = parser;
            while ((token = this._parser.nextToken()) != null) {
                this.parse(list, null, token);
            }
            this._errorBuilder = null;
            return list;
        }

        <T extends DataComplex> T parse(JsonParser parser, Class<T> expectType) throws IOException {
            DataComplex result;
            this._errorBuilder = null;
            if (this._debug) {
                this._nameStack = new ArrayDeque<Object>();
            }
            this._parser = parser;
            JsonToken token = this._parser.nextToken();
            if (expectType == DataMap.class) {
                if (!JsonToken.START_OBJECT.equals((Object)token)) {
                    throw new DataDecodingException("Object must start with start object token.");
                }
                DataMap map = this.parseDataMap();
                if (this._errorBuilder != null) {
                    map.addError(this._errorBuilder.toString());
                }
                result = (DataComplex)expectType.cast(map);
            } else if (expectType == DataList.class) {
                if (!JsonToken.START_ARRAY.equals((Object)token)) {
                    throw new DataDecodingException("Array must start with start object token.");
                }
                DataList list = this.parseDataList();
                if (this._errorBuilder != null) {
                    // empty if block
                }
                result = (DataComplex)expectType.cast(list);
            } else {
                throw new DataDecodingException("Expected type must be either DataMap or DataList.");
            }
            return (T)result;
        }

        private DataLocation currentDataLocation() {
            return this._locationMap == null ? null : new Location(this._parser.getTokenLocation());
        }

        private void saveDataLocation(Object o, DataLocation location) {
            if (this._locationMap != null && o != null) {
                assert (location != null);
                this._locationMap.put(o, location);
            }
        }

        private Object parse(DataComplex parent, String name, JsonToken token) throws IOException {
            return this.parse(parent, name, token, true);
        }

        private Object parse(JsonToken token) throws IOException {
            return this.parse(null, null, token, false);
        }

        private Object parse(DataComplex parent, String name, JsonToken token, boolean shouldUpdateParent) throws IOException {
            Object value;
            if (token == null) {
                throw new DataDecodingException("Missing token");
            }
            DataLocation location = this.currentDataLocation();
            switch (token) {
                case START_OBJECT: {
                    value = this.parseDataMap();
                    if (!shouldUpdateParent) break;
                    this.updateParent(parent, name, value);
                    break;
                }
                case START_ARRAY: {
                    value = this.parseDataList();
                    if (!shouldUpdateParent) break;
                    this.updateParent(parent, name, value);
                    break;
                }
                default: {
                    value = this.parsePrimitive(token);
                    if (value == null || !shouldUpdateParent) break;
                    this.updateParent(parent, name, value);
                }
            }
            this.saveDataLocation(value, location);
            return value;
        }

        private void updateParent(DataComplex parent, String name, Object value) {
            if (parent instanceof DataMap) {
                Object replaced = CheckedUtil.putWithoutChecking((DataMap)parent, name, value);
                if (replaced != null) {
                    if (this._errorBuilder == null) {
                        this._errorBuilder = new StringBuilder();
                    }
                    this._errorBuilder.append(new Location(this._parser.getTokenLocation())).append(": \"").append(name).append("\" defined more than once.\n");
                }
            } else {
                CheckedUtil.addWithoutChecking((DataList)parent, value);
            }
        }

        private Object parsePrimitive(JsonToken token) throws IOException {
            Object object;
            block0 : switch (token) {
                case VALUE_STRING: {
                    object = this._parser.getText();
                    break;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    JsonParser.NumberType numberType = this._parser.getNumberType();
                    if (numberType == null) {
                        this.error(token, null);
                        object = null;
                        break;
                    }
                    switch (numberType) {
                        case INT: {
                            object = this._parser.getIntValue();
                            break block0;
                        }
                        case LONG: {
                            object = this._parser.getLongValue();
                            break block0;
                        }
                        case FLOAT: {
                            object = Float.valueOf(this._parser.getFloatValue());
                            break block0;
                        }
                        case DOUBLE: {
                            object = this._parser.getDoubleValue();
                            break block0;
                        }
                        case BIG_INTEGER: {
                            this.error(token, numberType);
                            object = null;
                            break block0;
                        }
                    }
                    this.error(token, numberType);
                    object = null;
                    break;
                }
                case VALUE_TRUE: {
                    object = Boolean.TRUE;
                    break;
                }
                case VALUE_FALSE: {
                    object = Boolean.FALSE;
                    break;
                }
                case VALUE_NULL: {
                    object = Data.NULL;
                    break;
                }
                default: {
                    this.error(token, null);
                    object = null;
                }
            }
            return object;
        }

        private DataMap parseDataMap() throws IOException {
            return this.parseDataMapRecursive(0);
        }

        private DataMap parseDataMapRecursive(int dataMapSize) throws IOException {
            if (this._parser.nextToken() == JsonToken.END_OBJECT) {
                return new DataMap(DataMapBuilder.getOptimumHashMapCapacityFromSize(dataMapSize));
            }
            if (dataMapSize >= 6) {
                return this.parseDataMapIterative();
            }
            String key = this._parser.getCurrentName();
            if (this._debug) {
                this._nameStack.addLast(key);
            }
            JsonToken token = this._parser.nextToken();
            Object value = this.parse(token);
            DataMap map = this.parseDataMapRecursive(dataMapSize + 1);
            if (value != null) {
                this.updateParent(map, key, value);
            }
            if (this._debug) {
                this._nameStack.removeLast();
            }
            return map;
        }

        private DataMap parseDataMapIterative() throws IOException {
            DataMap map = new DataMap();
            this.addToMap(map);
            while (this._parser.nextToken() != JsonToken.END_OBJECT) {
                this.addToMap(map);
            }
            return map;
        }

        private void addToMap(DataMap map) throws IOException {
            String key = this._parser.getCurrentName();
            if (this._debug) {
                this._nameStack.addLast(key);
            }
            JsonToken token = this._parser.nextToken();
            this.parse(map, key, token);
            if (this._debug) {
                this._nameStack.removeLast();
            }
        }

        private DataList parseDataList() throws IOException {
            JsonToken token;
            DataList list = new DataList();
            int index = 0;
            while ((token = this._parser.nextToken()) != JsonToken.END_ARRAY) {
                if (this._debug) {
                    this._nameStack.addLast(index);
                    ++index;
                }
                this.parse(list, null, token);
                if (!this._debug) continue;
                this._nameStack.removeLast();
            }
            return list;
        }

        private void error(JsonToken token, JsonParser.NumberType type) throws IOException {
            if (this._errorBuilder == null) {
                this._errorBuilder = new StringBuilder();
            }
            this._errorBuilder.append(this._parser.getTokenLocation()).append(": ");
            if (this._debug) {
                this._errorBuilder.append("name: ");
                Data.appendNames(this._errorBuilder, this._nameStack);
                this._errorBuilder.append(", ");
            }
            this._errorBuilder.append("value: ").append(this._parser.getText()).append(", token: ").append((Object)token);
            if (type != null) {
                this._errorBuilder.append(", number type: ").append((Object)type);
            }
            this._errorBuilder.append(" not parsed.\n");
        }
    }

    public static class JacksonTraverseCallback
    implements Data.TraverseCallback {
        protected final JsonGenerator _generator;
        private final boolean _orderMapEntriesByKey;

        protected JacksonTraverseCallback(JsonGenerator generator) {
            this(generator, false);
        }

        protected JacksonTraverseCallback(JsonGenerator generator, boolean orderMapEntriesByKey) {
            this._generator = generator;
            this._orderMapEntriesByKey = orderMapEntriesByKey;
        }

        @Override
        public void nullValue() throws IOException {
            this._generator.writeNull();
        }

        @Override
        public void booleanValue(boolean value) throws IOException {
            this._generator.writeBoolean(value);
        }

        @Override
        public void integerValue(int value) throws IOException {
            this._generator.writeNumber(value);
        }

        @Override
        public void longValue(long value) throws IOException {
            this._generator.writeNumber(value);
        }

        @Override
        public void floatValue(float value) throws IOException {
            this._generator.writeNumber(value);
        }

        @Override
        public void doubleValue(double value) throws IOException {
            this._generator.writeNumber(value);
        }

        @Override
        public void stringValue(String value) throws IOException {
            this._generator.writeString(value);
        }

        @Override
        public void byteStringValue(ByteString value) throws IOException {
            char[] avroCharArray = value.asAvroCharArray();
            this._generator.writeString(avroCharArray, 0, avroCharArray.length);
        }

        @Override
        public void illegalValue(Object value) throws DataEncodingException {
            throw new DataEncodingException("Illegal value encountered: " + value);
        }

        @Override
        public void emptyMap() throws IOException {
            this._generator.writeStartObject();
            this._generator.writeEndObject();
        }

        @Override
        public void startMap(DataMap map) throws IOException {
            this._generator.writeStartObject();
        }

        @Override
        public void key(String key) throws IOException {
            this._generator.writeFieldName(key);
        }

        @Override
        public Iterable<Map.Entry<String, Object>> orderMap(DataMap map) {
            if (this._orderMapEntriesByKey) {
                return Data.orderMapEntries(map);
            }
            return null;
        }

        @Override
        public void endMap() throws IOException {
            this._generator.writeEndObject();
        }

        @Override
        public void emptyList() throws IOException {
            this._generator.writeStartArray();
            this._generator.writeEndArray();
        }

        @Override
        public void startList(DataList list) throws IOException {
            this._generator.writeStartArray();
        }

        @Override
        public void index(int index) {
        }

        @Override
        public void endList() throws IOException {
            this._generator.writeEndArray();
        }

        @Override
        public void close() throws IOException {
            this._generator.flush();
            this._generator.close();
        }
    }
}

