/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetadataAttribution
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}", SchemaFormatType.PDL);
    private Long _timeField = null;
    private Urn _actorField = null;
    private Urn _sourceField = null;
    private StringMap _sourceDetailField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Time = SCHEMA.getField("time");
    private static final RecordDataSchema.Field FIELD_Actor = SCHEMA.getField("actor");
    private static final RecordDataSchema.Field FIELD_Source = SCHEMA.getField("source");
    private static final RecordDataSchema.Field FIELD_SourceDetail = SCHEMA.getField("sourceDetail");
    private static final StringMap DEFAULT_SourceDetail;

    public MetadataAttribution() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public MetadataAttribution(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTime() {
        if (this._timeField != null) {
            return true;
        }
        return this._map.containsKey("time");
    }

    public void removeTime() {
        this._map.remove("time");
    }

    @Nullable
    public Long getTime(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTime();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timeField != null) {
                    return this._timeField;
                }
                Object __rawValue = this._map.get("time");
                this._timeField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTime() {
        if (this._timeField != null) {
            return this._timeField;
        }
        Object __rawValue = this._map.get("time");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("time");
        }
        this._timeField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timeField;
    }

    public MetadataAttribution setTime(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTime(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field time of com.linkedin.common.MetadataAttribution");
                }
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTime();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
            }
        }
        return this;
    }

    public MetadataAttribution setTime(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field time of com.linkedin.common.MetadataAttribution to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
        this._timeField = value;
        return this;
    }

    public MetadataAttribution setTime(long value) {
        CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
        this._timeField = value;
        return this;
    }

    public boolean hasActor() {
        if (this._actorField != null) {
            return true;
        }
        return this._map.containsKey("actor");
    }

    public void removeActor() {
        this._map.remove("actor");
    }

    @Nullable
    public Urn getActor(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getActor();
            }
            case DEFAULT: 
            case NULL: {
                if (this._actorField != null) {
                    return this._actorField;
                }
                Object __rawValue = this._map.get("actor");
                this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._actorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getActor() {
        if (this._actorField != null) {
            return this._actorField;
        }
        Object __rawValue = this._map.get("actor");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("actor");
        }
        this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._actorField;
    }

    public MetadataAttribution setActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field actor of com.linkedin.common.MetadataAttribution");
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
            }
        }
        return this;
    }

    public MetadataAttribution setActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actor of com.linkedin.common.MetadataAttribution to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._actorField = value;
        return this;
    }

    public boolean hasSource() {
        if (this._sourceField != null) {
            return true;
        }
        return this._map.containsKey("source");
    }

    public void removeSource() {
        this._map.remove("source");
    }

    @Nullable
    public Urn getSource(GetMode mode) {
        return this.getSource();
    }

    @Nullable
    public Urn getSource() {
        if (this._sourceField != null) {
            return this._sourceField;
        }
        Object __rawValue = this._map.get("source");
        this._sourceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._sourceField;
    }

    public MetadataAttribution setSource(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "source", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "source", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceField = value;
            }
        }
        return this;
    }

    public MetadataAttribution setSource(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field source of com.linkedin.common.MetadataAttribution to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "source", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._sourceField = value;
        return this;
    }

    public boolean hasSourceDetail() {
        if (this._sourceDetailField != null) {
            return true;
        }
        return this._map.containsKey("sourceDetail");
    }

    public void removeSourceDetail() {
        this._map.remove("sourceDetail");
    }

    @Nullable
    public StringMap getSourceDetail(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getSourceDetail();
            }
            case NULL: {
                if (this._sourceDetailField != null) {
                    return this._sourceDetailField;
                }
                Object __rawValue = this._map.get("sourceDetail");
                this._sourceDetailField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._sourceDetailField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getSourceDetail() {
        if (this._sourceDetailField != null) {
            return this._sourceDetailField;
        }
        Object __rawValue = this._map.get("sourceDetail");
        if (__rawValue == null) {
            return DEFAULT_SourceDetail;
        }
        this._sourceDetailField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceDetailField;
    }

    public MetadataAttribution setSourceDetail(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceDetail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field sourceDetail of com.linkedin.common.MetadataAttribution");
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceDetail", value.data());
                this._sourceDetailField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceDetail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceDetail", value.data());
                this._sourceDetailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceDetail", value.data());
                this._sourceDetailField = value;
            }
        }
        return this;
    }

    public MetadataAttribution setSourceDetail(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceDetail of com.linkedin.common.MetadataAttribution to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceDetail", value.data());
        this._sourceDetailField = value;
        return this;
    }

    @Override
    public MetadataAttribution clone() throws CloneNotSupportedException {
        MetadataAttribution __clone = (MetadataAttribution)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MetadataAttribution copy() throws CloneNotSupportedException {
        MetadataAttribution __copy = (MetadataAttribution)super.copy();
        __copy._actorField = null;
        __copy._sourceDetailField = null;
        __copy._timeField = null;
        __copy._sourceField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_SourceDetail = FIELD_SourceDetail.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_SourceDetail.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MetadataAttribution __objectRef;

        private ChangeListener(MetadataAttribution reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "actor": {
                    this.__objectRef._actorField = null;
                    break;
                }
                case "sourceDetail": {
                    this.__objectRef._sourceDetailField = null;
                    break;
                }
                case "time": {
                    this.__objectRef._timeField = null;
                    break;
                }
                case "source": {
                    this.__objectRef._sourceField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec time() {
            return new PathSpec(this.getPathComponents(), "time");
        }

        public PathSpec actor() {
            return new PathSpec(this.getPathComponents(), "actor");
        }

        public PathSpec source() {
            return new PathSpec(this.getPathComponents(), "source");
        }

        public PathSpec sourceDetail() {
            return new PathSpec(this.getPathComponents(), "sourceDetail");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withTime() {
            this.getDataMap().put("time", 1);
            return this;
        }

        public ProjectionMask withActor() {
            this.getDataMap().put("actor", 1);
            return this;
        }

        public ProjectionMask withSource() {
            this.getDataMap().put("source", 1);
            return this;
        }

        public ProjectionMask withSourceDetail() {
            this.getDataMap().put("sourceDetail", 1);
            return this;
        }
    }
}

