/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.chart;

import com.linkedin.chart.ChartQueryType;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChartQuery
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.chart/**Information for chart query which is used for getting data of the chart*/@Aspect.name=\"chartQuery\"record ChartQuery{/**Raw query to build a chart from input datasets*/rawQuery:string/**Chart query type*/@Searchable={\"addToFilters\":true,\"fieldName\":\"queryType\",\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Query Type\"}type:enum ChartQueryType{/**LookML queries*/LOOKML/**SQL type queries*/SQL}}", SchemaFormatType.PDL);
    private String _rawQueryField = null;
    private ChartQueryType _typeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_RawQuery = SCHEMA.getField("rawQuery");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");

    public ChartQuery() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public ChartQuery(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasRawQuery() {
        if (this._rawQueryField != null) {
            return true;
        }
        return this._map.containsKey("rawQuery");
    }

    public void removeRawQuery() {
        this._map.remove("rawQuery");
    }

    @Nullable
    public String getRawQuery(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRawQuery();
            }
            case DEFAULT: 
            case NULL: {
                if (this._rawQueryField != null) {
                    return this._rawQueryField;
                }
                Object __rawValue = this._map.get("rawQuery");
                this._rawQueryField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._rawQueryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRawQuery() {
        if (this._rawQueryField != null) {
            return this._rawQueryField;
        }
        Object __rawValue = this._map.get("rawQuery");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("rawQuery");
        }
        this._rawQueryField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._rawQueryField;
    }

    public ChartQuery setRawQuery(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRawQuery(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field rawQuery of com.linkedin.chart.ChartQuery");
                }
                CheckedUtil.putWithoutChecking(this._map, "rawQuery", value);
                this._rawQueryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRawQuery();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rawQuery", value);
                this._rawQueryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rawQuery", value);
                this._rawQueryField = value;
            }
        }
        return this;
    }

    public ChartQuery setRawQuery(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rawQuery of com.linkedin.chart.ChartQuery to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rawQuery", value);
        this._rawQueryField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public ChartQueryType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, ChartQueryType.class, ChartQueryType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ChartQueryType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, ChartQueryType.class, ChartQueryType.$UNKNOWN);
        return this._typeField;
    }

    public ChartQuery setType(@Nullable ChartQueryType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.chart.ChartQuery");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public ChartQuery setType(@Nonnull ChartQueryType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.chart.ChartQuery to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    @Override
    public ChartQuery clone() throws CloneNotSupportedException {
        ChartQuery __clone = (ChartQuery)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ChartQuery copy() throws CloneNotSupportedException {
        ChartQuery __copy = (ChartQuery)super.copy();
        __copy._typeField = null;
        __copy._rawQueryField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ChartQuery __objectRef;

        private ChangeListener(ChartQuery reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "rawQuery": {
                    this.__objectRef._rawQueryField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec rawQuery() {
            return new PathSpec(this.getPathComponents(), "rawQuery");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withRawQuery() {
            this.getDataMap().put("rawQuery", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }
    }
}

