/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util.validator;

import com.datahub.util.validator.ValidationUtils;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.UnionTemplate;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import lombok.Generated;

public class RelationshipValidator {
    private static final Set<Class<? extends RecordTemplate>> VALIDATED = ConcurrentHashMap.newKeySet();
    private static final Set<Class<? extends UnionTemplate>> UNION_VALIDATED = ConcurrentHashMap.newKeySet();

    private RelationshipValidator() {
    }

    public static void validateRelationshipSchema(@Nonnull RecordDataSchema schema) {
        String className = schema.getBindingName();
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, field -> ValidationUtils.isValidUrnField(field, "source"))) {
            ValidationUtils.invalidSchema("Relationship '%s' must contain an non-optional 'source' field of URN type", className);
        }
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, field -> ValidationUtils.isValidUrnField(field, "destination"))) {
            ValidationUtils.invalidSchema("Relationship '%s' must contain an non-optional 'destination' field of URN type", className);
        }
        ValidationUtils.fieldsUsingInvalidType(schema, ValidationUtils.PRIMITIVE_TYPES).forEach(field -> ValidationUtils.invalidSchema("Relationship '%s' contains a field '%s' that makes use of a disallowed type '%s'.", new Object[]{className, field.getName(), field.getType().getType()}));
    }

    public static void validateRelationshipSchema(@Nonnull Class<? extends RecordTemplate> clazz) {
        if (VALIDATED.contains(clazz)) {
            return;
        }
        RelationshipValidator.validateRelationshipSchema(ValidationUtils.getRecordSchema(clazz));
        VALIDATED.add(clazz);
    }

    public static void validateRelationshipUnionSchema(@Nonnull Class<? extends UnionTemplate> clazz) {
        if (UNION_VALIDATED.contains(clazz)) {
            return;
        }
        RelationshipValidator.validateRelationshipUnionSchema(ValidationUtils.getUnionSchema(clazz), clazz.getCanonicalName());
        UNION_VALIDATED.add(clazz);
    }

    public static void validateRelationshipUnionSchema(@Nonnull UnionDataSchema schema, @Nonnull String relationshipClassName) {
        if (!ValidationUtils.isUnionWithOnlyComplexMembers(schema)) {
            ValidationUtils.invalidSchema("Relationship '%s' must be a union containing only record type members", relationshipClassName);
        }
    }

    private static final class Pair {
        private final String source;
        private final String destination;

        @Generated
        public Pair(String source, String destination) {
            this.source = source;
            this.destination = destination;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getDestination() {
            return this.destination;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelationshipValidator.Pair(source=" + this.getSource() + ", destination=" + this.getDestination() + ")";
        }
    }
}

