/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.util;

import com.generationjava.collections.OrderedSet;
import com.generationjava.lang.StringW;
import com.generationjava.util.OrderedProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CommentedOrderedProperties
extends OrderedProperties {
    private char commentChar = (char)35;

    public static CommentedOrderedProperties createCommentedOrderedProperties(File file) {
        CommentedOrderedProperties props = new CommentedOrderedProperties();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(35);
                String comment = null;
                boolean found = false;
                if (idx != -1) {
                    comment = line.substring(idx + 1);
                    line = line.substring(0, idx);
                    found = true;
                }
                if ((idx = line.indexOf(61)) != -1) {
                    props.setProperty(line.substring(0, idx), line.substring(idx + 1));
                    found = true;
                }
                if (comment != null) {
                    props.addComment(comment);
                    found = true;
                }
                if (found) continue;
                props.addSeparator();
            }
            reader.close();
            return props;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return props;
        }
    }

    public CommentedOrderedProperties() {
    }

    public CommentedOrderedProperties(Properties props) {
        super(props);
    }

    public synchronized Set keySet() {
        Iterator iterator = this.index.iterator();
        OrderedSet set = new OrderedSet();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (this.get(key) == null) continue;
            set.add(key);
        }
        return set;
    }

    public void save(OutputStream outstrm, String header) {
        try {
            this.store(outstrm, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(OutputStream outstrm, String header) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outstrm);
        writer.write("#");
        writer.write(header);
        writer.write("\n");
        writer.write("#");
        writer.write(new Date().toString());
        writer.write("\n");
        Iterator iterator = this.index.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (this.get(key) == null) {
                writer.write(key.toString());
            } else {
                writer.write(key.toString());
                writer.write("=");
                writer.write(this.get(key).toString());
            }
            writer.write("\n");
        }
        ((Writer)writer).close();
    }

    public void setCommentChar(char ch) {
        this.commentChar = ch;
    }

    public char getCommentChar() {
        return this.commentChar;
    }

    public void addComment(String str) {
        this.addComment(this.commentChar, str);
    }

    public void addComment(char ch, String str) {
        this.index.add("" + ch + " " + str);
    }

    public void addSeparator() {
        this.index.add("");
    }

    public void wordWrapComment(char ch, String str, int width) {
        str = StringW.wordWrap(str, width - 2);
        String[] strs = StringUtils.split((String)str, (String)"\n");
        int sz = strs.length;
        for (int i = 0; i < sz; ++i) {
            this.addComment(ch, strs[i]);
        }
    }

    public void insertComment(char ch, String str, Object key) {
        int idx = this.index.indexOf(key);
        if (idx == -1) {
            this.addComment(ch, str);
        } else {
            this.index.add(idx, "" + ch + " " + str);
        }
    }
}

