/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.math;

public class Interval {
    private double lower;
    private double upper;

    public Interval(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public static Interval makeIntervalCenterWidth(double center, double difference) {
        return new Interval(center - difference, center + difference);
    }

    public static Interval makeIntervalCenterPercentage(double center, float percentage) {
        return new Interval(center - center * (double)percentage / 100.0, center + center * (double)percentage / 100.0);
    }

    public Interval add(Interval i) {
        return new Interval(i.lower + this.lower, i.upper + this.upper);
    }

    public Interval mul(Interval i) {
        double p1 = i.lower * this.lower;
        double p2 = i.lower * this.upper;
        double p3 = i.upper * this.lower;
        double p4 = i.upper * this.upper;
        return new Interval(this.min(p1, p2, p3, p4), this.max(p1, p2, p3, p4));
    }

    public Interval div(Interval i) {
        return this.mul(new Interval(1.0 / i.upper, 1.0 / i.lower));
    }

    public Interval sub(Interval i) {
        return this.add(new Interval(-i.upper, -i.lower));
    }

    private double min(double d1, double d2, double d3, double d4) {
        double tmp = d1;
        if (d2 < tmp) {
            tmp = d2;
        }
        if (d3 < tmp) {
            tmp = d3;
        }
        if (d4 < tmp) {
            tmp = d4;
        }
        return tmp;
    }

    private double max(double d1, double d2, double d3, double d4) {
        double tmp = d1;
        if (d2 > tmp) {
            tmp = d2;
        }
        if (d3 > tmp) {
            tmp = d3;
        }
        if (d4 > tmp) {
            tmp = d4;
        }
        return tmp;
    }

    public String toString() {
        return this.lower + " - " + this.upper;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Interval) {
            Interval ivl = (Interval)obj;
            return this.lower == ivl.lower && this.upper == ivl.upper;
        }
        return false;
    }

    public int hashCode() {
        return (int)((this.lower + this.upper) % 2.147483647E9);
    }
}

