/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.math;

public class Fraction {
    private int num;
    private int den;

    public static int gcd(int i1, int i2) {
        if (i2 == 0) {
            return i1;
        }
        return Fraction.gcd(i2, i1 % i2);
    }

    public static Fraction reduce(Fraction f) {
        int d = Fraction.gcd(f.num, f.den);
        return new Fraction(f.num / d, f.den / d);
    }

    public Fraction(int num, int den) {
        this.num = num;
        this.den = den;
    }

    public Fraction(int num) {
        this(num, 1);
    }

    public Fraction add(Fraction f) {
        return new Fraction(this.num * f.den + this.den * f.num, this.den * f.den);
    }

    public Fraction sub(Fraction f) {
        return new Fraction(this.num * f.den - this.den * f.num, this.den * f.den);
    }

    public Fraction mul(Fraction f) {
        return new Fraction(this.num * f.num, this.den * f.den);
    }

    public Fraction div(Fraction f) {
        return new Fraction(this.num * f.den, this.den * f.num);
    }

    public Fraction inverse() {
        return new Fraction(this.den, this.num);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Fraction) {
            Fraction f = (Fraction)obj;
            return this.num * f.den == this.den * f.num;
        }
        return false;
    }

    public int hashCode() {
        return Integer.MAX_VALUE / this.den * this.num;
    }

    public String toString() {
        return this.num + "/" + this.den;
    }
}

