/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.jdbc;

import com.generationjava.jdbc.JdbcW;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class ResultSetIterator
implements Iterator {
    private ResultSet rs;
    private boolean hasNextCalledLast = false;
    private Object val = null;

    public ResultSetIterator(ResultSet rs) {
        this.rs = rs;
    }

    public boolean hasNext() {
        if (!this.hasNextCalledLast) {
            this.hasNextCalledLast = true;
            this.doNext();
        }
        return this.val != null;
    }

    public Object next() {
        if (this.val == null) {
            this.doNext();
        }
        this.hasNextCalledLast = false;
        return this.val;
    }

    private void doNext() {
        try {
            this.rs.next();
            this.val = JdbcW.resultSetToArray(this.rs);
        }
        catch (SQLException sqle) {
            this.val = null;
        }
    }

    public void remove() {
        try {
            this.rs.deleteRow();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }
}

