/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.io;

import com.generationjava.io.Table;
import com.generationjava.io.TableRow;
import java.util.Collection;

public class Tablifier {
    private String rowSep = "\n";
    private String colSep = " ";
    private String[] header;
    private String[] footer;
    private int width;
    private int numCols;
    private int[] columnLocations;

    public String tablify(Collection coll2d) {
        if (coll2d == null) {
            return null;
        }
        Table table = new Table(coll2d);
        return this.tablify(table);
    }

    public String tablify(Table table) {
        StringBuffer buffer = new StringBuffer();
        int[] columnwidths = table.getColumnWidths();
        this.columnLocations = this.evaluateColumnLocations(columnwidths);
        this.width = table.getWidth();
        this.numCols = table.getNumberOfColumns();
        String[] header = this.getHeader();
        if (header != null) {
            // empty if block
        }
        while (table.hasNext()) {
            TableRow row = (TableRow)table.next();
            int idx = 0;
            buffer.append(this.getVerticalBorder());
            while (row.hasNext()) {
                String value = (String)row.next();
                if (!row.firstColumn()) {
                    buffer.append(this.getColumnSeparator());
                }
                buffer.append(this.pad(value, columnwidths[idx], this.getColumnSeparator()));
                ++idx;
                if (row.lastColumn()) continue;
                buffer.append(this.getVerticalBorder());
            }
            buffer.append(this.getVerticalBorder());
            buffer.append(this.getRowSeparator());
        }
        String[] footer = this.getFooter();
        if (footer != null) {
            // empty if block
        }
        return buffer.toString();
    }

    public int[] evaluateColumnLocations(int[] columnwidths) {
        String vs = this.getVerticalBorder();
        int vsln = vs.length();
        if (vsln == 0) {
            return null;
        }
        int sz = this.getPrintedWidth();
        int count = 0;
        int[] cols = new int[sz + 1];
        cols[0] = 0;
        for (int i = 0; i < sz; ++i) {
            count += vsln;
            cols[i + 1] = count += columnwidths[i];
        }
        return cols;
    }

    public String pad(String value, int width, String chr) {
        while (width > value.length()) {
            value = chr + value;
        }
        return value;
    }

    public int getPrintedWidth() {
        int sz = this.width;
        sz += this.getVerticalBorder().length() * (this.numCols + 1);
        return sz += this.getColumnSeparator().length() * (this.numCols - 1);
    }

    public void printBottom(StringBuffer buffer) {
        this.printTop(buffer);
    }

    public void printTop(StringBuffer buffer) {
        int count = 1;
        int sz = this.getPrintedWidth();
        for (int i = 0; i < sz; ++i) {
            if (i == 0 || i == sz - 1) {
                if (this.getColumnSeparator().length() > 0) {
                    buffer.append(this.getCornerBorder());
                    continue;
                }
            } else if (this.columnLocations != null && this.columnLocations[count] == i) {
                buffer.append(this.getIntersectionBorder());
                ++count;
                continue;
            }
            buffer.append(this.getHorizontalBorder());
        }
        buffer.append(this.getRowSeparator());
    }

    public String getHorizontalBorder() {
        return "-";
    }

    public String getIntersectionBorder() {
        return "+";
    }

    public String getCornerBorder() {
        return ".";
    }

    public String getVerticalBorder() {
        return "|";
    }

    public void setHeader(String[] strs) {
        this.header = strs;
    }

    public void setFooter(String[] strs) {
        this.footer = strs;
    }

    public void setRowSeparator(String sep) {
        this.rowSep = sep;
    }

    public void setColumnSeparator(String sep) {
        this.colSep = sep;
    }

    public String getRowSeparator() {
        return this.rowSep;
    }

    public String getColumnSeparator() {
        return this.colSep;
    }

    public String[] getHeader() {
        return this.header;
    }

    public String[] getFooter() {
        return this.footer;
    }
}

