/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.StringUtils;

public class FixedWidthReader {
    private BufferedReader rdr;
    private int[] widths;
    private String trim;
    private int minWidth;
    private boolean hasGlob;

    public FixedWidthReader(Reader rdr) {
        if (!(rdr instanceof BufferedReader)) {
            rdr = new BufferedReader(rdr);
        }
        this.rdr = (BufferedReader)rdr;
    }

    public void setWidths(int[] widths) {
        this.widths = widths;
        this.calcSizeCondition();
    }

    public void setWidths(String widths) {
        String[] nums = StringUtils.split((String)widths, (String)",");
        int sz = nums.length;
        this.widths = new int[sz];
        for (int i = 0; i < sz; ++i) {
            this.widths[i] = "*".equals(nums[i]) ? 0 : NumberUtils.stringToInt((String)nums[i]);
        }
        this.calcSizeCondition();
    }

    private void calcSizeCondition() {
        if (this.widths != null) {
            this.hasGlob = false;
            for (int i = 0; i < this.widths.length; ++i) {
                if (this.widths[i] == 0) {
                    this.hasGlob = true;
                    continue;
                }
                this.minWidth += this.widths[i];
            }
        }
    }

    public void setTrim(String trim) {
        this.trim = trim;
    }

    public Object[] readLine() throws IOException {
        String line = this.rdr.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() < this.minWidth) {
            return null;
        }
        if (!this.hasGlob && line.length() > this.minWidth) {
            return null;
        }
        int sz = this.widths.length;
        Object[] fields = new String[this.widths.length];
        boolean reverse = false;
        int idx = 0;
        int i = 0;
        for (i = 0; i < sz; ++i) {
            if (this.widths[i] == 0) {
                reverse = true;
                break;
            }
            fields[i] = line.substring(idx, idx + this.widths[i]);
            idx += this.widths[i];
        }
        if (reverse) {
            int rev = line.length();
            for (int j = sz - 1; j > i; --j) {
                fields[j] = line.substring(rev -= this.widths[j], rev + this.widths[j]);
            }
            fields[i] = line.substring(idx, rev);
        }
        if (this.trim != null) {
            for (int index = 0; index < sz; ++index) {
                fields[index] = StringUtils.strip((String)fields[index], (String)this.trim);
            }
        }
        return fields;
    }
}

