/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.collections;

import com.generationjava.collections.FQEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FQMap
implements Map {
    private Map myMap = null;
    private char myChar;
    private int numberFQMapValues = 0;

    public FQMap(Map m, char separator) {
        m.clear();
        this.myMap = m;
        this.myChar = separator;
    }

    public FQMap() {
        this(new HashMap(), '.');
    }

    public FQMap(Map m) {
        this(m, '.');
    }

    public FQMap(char c) {
        this(new HashMap(), c);
    }

    public String toString() {
        return "{" + this.myMap + "}";
    }

    public Map createEmptyMap() {
        return new FQMap(this.myChar);
    }

    public char getSeperationChar() {
        return this.myChar;
    }

    public Collection[] getSeparatedValues() {
        Collection col = this.myMap.values();
        if (col == null) {
            return null;
        }
        ArrayList fqmaps = null;
        ArrayList nonfqmaps = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Object ob = it.next();
            if (ob instanceof FQMap) {
                if (fqmaps == null) {
                    fqmaps = new ArrayList();
                }
                fqmaps.add(ob);
                continue;
            }
            if (nonfqmaps == null) {
                nonfqmaps = new ArrayList();
            }
            nonfqmaps.add(ob);
        }
        Collection[] retVal = new Collection[]{fqmaps, nonfqmaps};
        return retVal;
    }

    public void clear() {
        this.myMap.clear();
    }

    public boolean containsKey(Object key) {
        return this.get(key) == null;
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Set entrySet() {
        Set keys = this.keySet();
        if (keys == null) {
            return null;
        }
        HashSet<FQEntry> retSet = new HashSet<FQEntry>();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            retSet.add(new FQEntry(this, key));
        }
        return retSet;
    }

    public boolean equals(Object o) {
        return ((Object)this.myMap).equals(o);
    }

    public Object get(Object key) {
        if (key instanceof String) {
            String keyStr = (String)key;
            int idx = keyStr.indexOf(this.myChar);
            if (idx == -1 || idx == keyStr.length() - 1) {
                return this.myMap.get(key);
            }
            String first = keyStr.substring(0, idx);
            Object ob = this.myMap.get(first);
            Map subMap = null;
            if (ob != null) {
                if (ob instanceof Map) {
                    subMap = (Map)ob;
                    return subMap.get(keyStr.substring(idx + 1));
                }
                return null;
            }
            return null;
        }
        return this.myMap.get(key);
    }

    public int hashCode() {
        return ((Object)this.myMap).hashCode();
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public Set keySet() {
        Set keys = this.myMap.keySet();
        if (keys == null) {
            return null;
        }
        HashSet<String> retSet = new HashSet<String>();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = this.myMap.get(key);
            if (value instanceof FQMap) {
                Set subkeys = ((FQMap)value).keySet();
                if (subkeys == null) continue;
                Iterator subIt = subkeys.iterator();
                while (subIt.hasNext()) {
                    retSet.add("" + key + this.myChar + subIt.next());
                }
                continue;
            }
            retSet.add((String)key);
        }
        return retSet;
    }

    public Object put(Object key, Object value) {
        if (key instanceof String) {
            String keyStr = (String)key;
            int idx = keyStr.indexOf(this.myChar);
            if (idx == -1 || idx == keyStr.length() - 1) {
                return this.myMap.put(key, value);
            }
            String first = keyStr.substring(0, idx);
            Object ob = this.myMap.get(first);
            Map subMap = null;
            if (ob != null) {
                if (ob instanceof Map) {
                    subMap = (Map)ob;
                    return subMap.put(keyStr.substring(idx + 1), value);
                }
                subMap = this.createEmptyMap();
                subMap.put(keyStr.substring(idx + 1), value);
                this.myMap.put(first, subMap);
                return ob;
            }
            subMap = this.createEmptyMap();
            subMap.put(keyStr.substring(idx + 1), value);
            this.myMap.put(first, subMap);
            return ob;
        }
        return this.myMap.put(key, value);
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        Set keys = t.keySet();
        if (keys == null) {
            return;
        }
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object ob = it.next();
            this.put(ob, t.get(ob));
        }
    }

    public Object remove(Object key) {
        return null;
    }

    public int size() {
        if (this.myMap.size() == 0) {
            return 0;
        }
        Collection[] values = this.getSeparatedValues();
        int ret_int = 0;
        if (values[0] != null) {
            Iterator it = values[0].iterator();
            while (it.hasNext()) {
                FQMap map = (FQMap)it.next();
                ret_int += map.size();
            }
        }
        if (values[1] != null) {
            ret_int += values[1].size();
        }
        return ret_int;
    }

    public Collection values() {
        Collection[] values = this.getSeparatedValues();
        if (values == null) {
            return null;
        }
        ArrayList retList = null;
        if (values[0] != null) {
            if (retList == null) {
                retList = new ArrayList();
            }
            Iterator it = values[0].iterator();
            while (it.hasNext()) {
                FQMap map = (FQMap)it.next();
                retList.addAll(map.values());
            }
        }
        if (values[1] != null) {
            if (retList == null) {
                retList = new ArrayList();
            }
            retList.addAll(values[1]);
        }
        return retList;
    }
}

