/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.collections;

import com.generationjava.collections.ResetableIterator;
import java.util.Iterator;
import java.util.LinkedList;

public class CachingIterator
implements ResetableIterator {
    private Iterator iterator;
    private LinkedList cacheList;
    private Iterator cacheIterator;
    private boolean caching;

    static Iterator cache(Iterator iterator) {
        if (iterator instanceof CachingIterator) {
            return ((CachingIterator)iterator).iterate();
        }
        return new CachingIterator(iterator);
    }

    public CachingIterator(Iterator iterator) {
        this.iterator = iterator;
        this.cacheList = new LinkedList();
    }

    public Object next() {
        if (this.caching) {
            return this.cacheIterator.next();
        }
        Object tmp = this.iterator.next();
        this.cacheList.add(tmp);
        return tmp;
    }

    public boolean hasNext() {
        if (this.caching) {
            boolean tmp = this.cacheIterator.hasNext();
            return tmp;
        }
        boolean tmp = this.iterator.hasNext();
        if (!tmp) {
            this.caching = true;
            this.reset();
        }
        return tmp;
    }

    public void remove() {
        if (this.caching) {
            throw new UnsupportedOperationException("Not possible to remove from the Iterator once it has begun to cache. ");
        }
        this.iterator.remove();
    }

    public void loadCache() {
        if (!this.caching) {
            while (this.iterator.hasNext()) {
                this.cacheList.add(this.iterator.next());
            }
        }
    }

    public void reset() {
        this.cacheIterator = this.iterate();
    }

    public Iterator iterate() {
        this.loadCache();
        return this.cacheList.iterator();
    }
}

