/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertiesLoader {
    private Properties properties = null;

    public PropertiesLoader() {
        this(new Properties());
    }

    public PropertiesLoader(Properties properties) {
        this.properties = properties;
    }

    public Properties findProperties(String filename) {
        Properties props;
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (loader != null) {
            URL url = loader.getResource(filename);
            if (url == null) {
                url = loader.getResource("/" + filename);
            }
            if (url != null) {
                try {
                    InputStream in = url.openStream();
                    Properties props2 = (Properties)this.properties.clone();
                    props2.load(in);
                    return props2;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if ((props = this.loadProperties(filename)) != null) {
            return props;
        }
        props = this.loadProperties(System.getProperty("properties.path"), filename);
        if (props != null) {
            return props;
        }
        props = this.loadProperties(System.getProperty("user.dir"), filename);
        if (props != null) {
            return props;
        }
        props = this.loadProperties(System.getProperty("user.home"), filename);
        return props;
    }

    public Properties loadProperties(String directory, String filename) {
        return this.loadProperties(directory + File.separatorChar + filename);
    }

    public Properties loadProperties(String pathname) {
        try {
            Properties loadedProperties = (Properties)this.properties.clone();
            FileInputStream fis = new FileInputStream(pathname);
            loadedProperties.load(fis);
            fis.close();
            return loadedProperties;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (IOException fnfe) {
            return null;
        }
    }
}

