/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.lang;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ClassConstantsReflector {
    public static final int MAGIC = -889275714;
    public static final byte CLASS = 7;
    public static final byte FIELD_REF = 9;
    public static final byte METHOD_REF = 10;
    public static final byte INTERFACE_METHOD_REF = 11;
    public static final byte STRING = 8;
    public static final byte INTEGER = 3;
    public static final byte FLOAT = 4;
    public static final byte LONG = 5;
    public static final byte DOUBLE = 6;
    public static final byte NAME_AND_TYPE = 12;
    public static final byte UTF8 = 1;
    private String name = null;
    int minorVersion;
    int majorVersion;
    ArrayList constantPool;
    int accessFlags;
    int this_class;
    Object thisClass;
    int super_class;
    Object superClass;

    public static void main(String[] args) throws Throwable {
        ClassConstantsReflector c = new ClassConstantsReflector();
        for (int i = 0; i < args.length; ++i) {
            System.err.println("Class=" + c.getFullyQualifiedDottedName(args[i]));
            System.err.println("Name=" + c.getName() + "; super=" + c.getSuperName());
            System.err.println(c.getClassConstants(args[i]));
            System.err.println("\n");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSuperName() {
        return "" + this.superClass;
    }

    public String getFullyQualifiedDottedName(String filename) throws IOException {
        String name = this.getFullyQualifiedName(filename);
        return StringUtils.replace((String)name, (String)"/", (String)".");
    }

    public String getFullyQualifiedName(String filename) throws IOException {
        String name = null;
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(filename));
            if (in.readInt() != -889275714) {
                throw new IOException("Not a class file");
            }
            in.readUnsignedShort();
            in.readUnsignedShort();
            int length = in.readUnsignedShort();
            in.readByte();
            in.readUnsignedShort();
            in.readByte();
            name = in.readUTF();
            in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return name;
    }

    public List getClassConstants(String classname) {
        this.name = classname.substring(0, classname.length() - 6);
        this.name = this.name.replace('/', '.');
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(classname));
            this.readFrom(in);
            this.resolve();
            return this.getDependencies();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new ArrayList();
        }
    }

    List getDependencies() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iterator = this.constantPool.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof C7)) continue;
            list.add(obj.toString());
        }
        return list;
    }

    public void readFrom(DataInputStream in) throws IOException {
        if (in.readInt() != -889275714) {
            throw new IOException("Bad Magic Number");
        }
        this.minorVersion = in.readUnsignedShort();
        this.majorVersion = in.readUnsignedShort();
        if (this.majorVersion != 45 && (this.majorVersion != 46 || this.minorVersion != 0)) {
            throw new IOException("Unsupported version number");
        }
        int length = in.readUnsignedShort();
        this.constantPool = new ArrayList(length);
        this.constantPool.add(null);
        block13: for (int i = 1; i < length; ++i) {
            byte readByte = in.readByte();
            switch (readByte) {
                case 7: {
                    C7 c7 = new C7();
                    c7.readFrom(in);
                    this.constantPool.add(c7);
                    continue block13;
                }
                case 1: {
                    C1 c1 = new C1();
                    c1.readFrom(in);
                    this.constantPool.add(c1);
                    continue block13;
                }
                case 9: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.add(null);
                    continue block13;
                }
                case 10: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.add(null);
                    continue block13;
                }
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.add(null);
                    continue block13;
                }
                case 8: {
                    in.readUnsignedShort();
                    this.constantPool.add(null);
                    continue block13;
                }
                case 3: {
                    in.readInt();
                    this.constantPool.add(null);
                    continue block13;
                }
                case 4: {
                    in.readFloat();
                    this.constantPool.add(null);
                    continue block13;
                }
                case 5: {
                    ++i;
                    in.readLong();
                    this.constantPool.add(null);
                    this.constantPool.add(null);
                    continue block13;
                }
                case 6: {
                    ++i;
                    in.readDouble();
                    this.constantPool.add(null);
                    this.constantPool.add(null);
                    continue block13;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.add(null);
                    continue block13;
                }
                default: {
                    throw new IOException("Invalid Constant Found " + readByte + " at " + i + " of " + length);
                }
            }
        }
        this.accessFlags = in.readUnsignedShort();
        this.this_class = in.readUnsignedShort();
        this.super_class = in.readUnsignedShort();
        in.close();
    }

    public void resolve() {
        Iterator i = this.constantPool.iterator();
        i.next();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof C7)) continue;
            ((C7)obj).resolve();
        }
        if (this.this_class == 0 || this.this_class >= this.constantPool.size() || this.super_class == 0 || this.super_class >= this.constantPool.size()) {
            throw new RuntimeException("Invalid Constant Pool Reference");
        }
        Object ob = this.constantPool.get(this.this_class);
        if (!(ob instanceof C7)) {
            throw new RuntimeException("Wrong type of object at reference in constant pool");
        }
        this.thisClass = (C7)ob;
        ob = this.constantPool.get(this.super_class);
        if (!(ob instanceof C7)) {
            throw new RuntimeException("Wrong type of object at reference in constant pool");
        }
        this.superClass = (C7)ob;
    }

    class C7 {
        int index;
        C1 name;

        C7() {
        }

        public byte getType() {
            return 7;
        }

        public C1 getClassName() {
            return this.name;
        }

        public void readFrom(DataInputStream in) throws IOException {
            this.index = in.readUnsignedShort();
        }

        public void resolve() {
            if (this.index == 0) {
                throw new RuntimeException("Invalid Constant Pool Reference: " + this.index);
            }
            if (this.index >= ClassConstantsReflector.this.constantPool.size()) {
                throw new RuntimeException("Invalid Constant Pool Reference: " + this.index + "/" + ClassConstantsReflector.this.constantPool.size());
            }
            Object ob = ClassConstantsReflector.this.constantPool.get(this.index);
            if (!(ob instanceof C1)) {
                throw new RuntimeException("Wrong type of object at reference in constant pool");
            }
            this.name = (C1)ob;
        }

        public boolean equals(Object obj) {
            return obj instanceof C7 && ((C7)obj).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name.toString().replace('/', '.');
        }
    }

    class C1 {
        String value;

        C1() {
        }

        C1(String value) {
            this.value = value;
        }

        public byte getType() {
            return 1;
        }

        public String getValue() {
            return this.value;
        }

        public void readFrom(DataInputStream in) throws IOException {
            this.value = in.readUTF();
        }

        public boolean equals(Object obj) {
            return obj instanceof C1 && ((C1)obj).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }
}

